/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.sugar.impl.ref;

import com.llamalad7.mixinextras.lib.apache.a.e;
import com.llamalad7.mixinextras.service.MixinExtrasService;
import com.llamalad7.mixinextras.sugar.impl.ref.LocalRefClassGenerator;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalByteRef;
import com.llamalad7.mixinextras.sugar.ref.LocalCharRef;
import com.llamalad7.mixinextras.sugar.ref.LocalDoubleRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.llamalad7.mixinextras.sugar.ref.LocalLongRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.llamalad7.mixinextras.sugar.ref.LocalShortRef;
import com.llamalad7.mixinextras.utils.ASMUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class LocalRefUtils {
    public static Class getInterfaceFor(Type type) {
        if (!ASMUtils.isPrimitive(type)) {
            return LocalRef.class;
        }
        switch (type.getDescriptor().charAt(0)) {
            case 'Z': {
                return LocalBooleanRef.class;
            }
            case 'B': {
                return LocalByteRef.class;
            }
            case 'C': {
                return LocalCharRef.class;
            }
            case 'S': {
                return LocalShortRef.class;
            }
            case 'I': {
                return LocalIntRef.class;
            }
            case 'J': {
                return LocalLongRef.class;
            }
            case 'F': {
                return LocalFloatRef.class;
            }
            case 'D': {
                return LocalDoubleRef.class;
            }
        }
        throw new IllegalStateException("Illegal descriptor " + type.getDescriptor());
    }

    public static Type getTargetType(Type type, Type type2) {
        if (type.getSort() != 10 || !MixinExtrasService.getInstance().isClassOwned(type.getClassName())) {
            return type;
        }
        switch (e.d(type.getInternalName(), "/")) {
            case "LocalBooleanRef": {
                return Type.BOOLEAN_TYPE;
            }
            case "LocalByteRef": {
                return Type.BYTE_TYPE;
            }
            case "LocalCharRef": {
                return Type.CHAR_TYPE;
            }
            case "LocalDoubleRef": {
                return Type.DOUBLE_TYPE;
            }
            case "LocalFloatRef": {
                return Type.FLOAT_TYPE;
            }
            case "LocalIntRef": {
                return Type.INT_TYPE;
            }
            case "LocalLongRef": {
                return Type.LONG_TYPE;
            }
            case "LocalShortRef": {
                return Type.SHORT_TYPE;
            }
            case "LocalRef": {
                if (type2 == null) {
                    throw new IllegalStateException("LocalRef must have a concrete type argument!");
                }
                return type2;
            }
        }
        return type;
    }

    public static void generateNew(InsnList insnList, Type object) {
        object = LocalRefClassGenerator.getForType(object);
        insnList.add((AbstractInsnNode)new TypeInsnNode(187, (String)object));
        insnList.add((AbstractInsnNode)new InsnNode(89));
        insnList.add((AbstractInsnNode)new MethodInsnNode(183, (String)object, "<init>", "()V", false));
    }

    public static void generateInitialization(InsnList insnList, Type type) {
        String string = LocalRefClassGenerator.getForType(type);
        insnList.add((AbstractInsnNode)new MethodInsnNode(182, string, "init", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{LocalRefUtils.getErasedType(type)}), false));
    }

    public static void generateDisposal(InsnList insnList, Type type) {
        String string = LocalRefClassGenerator.getForType(type);
        insnList.add((AbstractInsnNode)new MethodInsnNode(182, string, "dispose", Type.getMethodDescriptor((Type)LocalRefUtils.getErasedType(type), (Type[])new Type[0]), false));
        if (!ASMUtils.isPrimitive(type)) {
            insnList.add((AbstractInsnNode)new TypeInsnNode(192, type.getInternalName()));
        }
    }

    public static void generateUnwrapping(InsnList insnList, Type type, Runnable runnable) {
        String string = Type.getInternalName((Class)LocalRefUtils.getInterfaceFor(type));
        runnable.run();
        insnList.add((AbstractInsnNode)new MethodInsnNode(185, string, "get", Type.getMethodDescriptor((Type)LocalRefUtils.getErasedType(type), (Type[])new Type[0]), true));
        if (!ASMUtils.isPrimitive(type)) {
            insnList.add((AbstractInsnNode)new TypeInsnNode(192, type.getInternalName()));
        }
    }

    private static Type getErasedType(Type type) {
        if (ASMUtils.isPrimitive(type)) {
            return type;
        }
        return ASMUtils.a;
    }
}

