/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.utils;

import com.llamalad7.mixinextras.lib.apache.a.e;
import com.llamalad7.mixinextras.service.MixinExtrasService;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Bytecode;

public class ASMUtils {
    public static final Type a = Type.getType(Object.class);
    public static final Handle b = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", Bytecode.generateDescriptor(CallSite.class, (Object[])new Object[]{MethodHandles.Lookup.class, String.class, MethodType.class, MethodType.class, MethodHandle.class, MethodType.class}), false);

    public static String annotationToString(AnnotationNode object) {
        StringBuilder stringBuilder = new StringBuilder("@").append(ASMUtils.typeToString(Type.getType((String)((AnnotationNode)object).desc)));
        object = ((AnnotationNode)object).values;
        if (object == null || object.isEmpty()) {
            return stringBuilder.toString();
        }
        stringBuilder.append('(');
        for (int i2 = 0; i2 < object.size(); i2 += 2) {
            if (i2 != 0) {
                stringBuilder.append(", ");
            }
            String string = (String)object.get(i2);
            Object e2 = object.get(i2 + 1);
            stringBuilder.append(string).append(" = ").append(ASMUtils.valueToString(e2));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static String typeToString(Type object) {
        object = object.getClassName();
        return object.substring(object.lastIndexOf(46) + 1).replace('$', '.');
    }

    private static String valueToString(Object object) {
        block5: {
            while (true) {
                if (object instanceof String) {
                    return "\"" + object.toString() + '\"';
                }
                if (object instanceof Type) {
                    object = (Type)object;
                    return ASMUtils.typeToString((Type)object) + ".class";
                }
                if (object instanceof String[]) {
                    object = (String[])object;
                    return ASMUtils.typeToString(Type.getType((String)object[0])) + '.' + (String)object[1];
                }
                if (object instanceof AnnotationNode) {
                    return ASMUtils.annotationToString((AnnotationNode)object);
                }
                if (!(object instanceof List)) break block5;
                if ((object = (List)object).size() != 1) break;
                object = object.get(0);
            }
            return "{" + object.stream().map(ASMUtils::valueToString).collect(Collectors.joining(", ")) + '}';
        }
        return object.toString();
    }

    public static boolean isPrimitive(Type type) {
        return type.getDescriptor().length() == 1;
    }

    public static MethodInsnNode getInvokeInstruction(ClassNode classNode, MethodNode methodNode) {
        boolean bl;
        boolean bl2 = bl = (classNode.access & 0x200) != 0;
        int n2 = (methodNode.access & 8) != 0 ? 184 : ((methodNode.access & 2) != 0 ? 183 : (bl ? 185 : 182));
        return new MethodInsnNode(n2, classNode.name, methodNode.name, methodNode.desc, bl);
    }

    public static int getDummyOpcodeForType(Type type) {
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 3;
            }
            case 6: {
                return 11;
            }
            case 7: {
                return 9;
            }
            case 8: {
                return 14;
            }
            case 9: 
            case 10: {
                return 1;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static MethodInsnNode findInitNodeFor(Target object, TypeInsnNode typeInsnNode) {
        int n2 = object.indexOf((AbstractInsnNode)typeInsnNode);
        int n3 = 0;
        object = ((Target)object).insns.iterator(n2);
        while (object.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)object.next();
            if (abstractInsnNode instanceof TypeInsnNode && abstractInsnNode.getOpcode() == 187) {
                if (!((TypeInsnNode)abstractInsnNode).desc.equals(typeInsnNode.desc)) continue;
                ++n3;
                continue;
            }
            if (!(abstractInsnNode instanceof MethodInsnNode) || abstractInsnNode.getOpcode() != 183) continue;
            abstractInsnNode = (MethodInsnNode)abstractInsnNode;
            if (!"<init>".equals(abstractInsnNode.name) || !abstractInsnNode.owner.equals(typeInsnNode.desc) || --n3 != 0) continue;
            return abstractInsnNode;
        }
        return null;
    }

    public static void ifElse(InsnList insnList, int n2, Runnable runnable, Runnable runnable2) {
        InsnList insnList2 = insnList;
        ASMUtils.ifElse(insnList2, labelNode -> insnList2.add((AbstractInsnNode)new JumpInsnNode(n2, labelNode)), runnable, runnable2);
    }

    public static void ifElse(InsnList insnList, Consumer consumer, Runnable runnable, Runnable runnable2) {
        LabelNode labelNode = new LabelNode();
        LabelNode labelNode2 = new LabelNode();
        consumer.accept(labelNode);
        runnable.run();
        insnList.add((AbstractInsnNode)new JumpInsnNode(167, labelNode2));
        insnList.add((AbstractInsnNode)labelNode);
        runnable2.run();
        insnList.add((AbstractInsnNode)labelNode2);
    }

    public static AnnotationNode getRepeatedMEAnnotation(MethodNode methodNode, Class clazz) {
        Class<? extends Annotation> clazz2 = clazz.getAnnotation(Repeatable.class).value();
        AnnotationNode annotationNode = ASMUtils.getInvisibleMEAnnotation(methodNode, clazz2);
        if (annotationNode != null) {
            return annotationNode;
        }
        if ((methodNode = ASMUtils.getInvisibleMEAnnotation(methodNode, clazz)) == null) {
            return null;
        }
        clazz = new AnnotationNode(Type.getDescriptor(clazz2));
        clazz.visit("value", methodNode);
        return clazz;
    }

    public static AnnotationNode getInvisibleMEAnnotation(MethodNode methodNode, Class clazz) {
        return ASMUtils.getMEAnnotation(methodNode.invisibleAnnotations, Type.getInternalName((Class)clazz));
    }

    private static AnnotationNode getMEAnnotation(List object, String string) {
        string = "." + e.d(string, "/");
        if (object == null) {
            return null;
        }
        object = object.iterator();
        while (object.hasNext()) {
            AnnotationNode annotationNode = (AnnotationNode)object.next();
            String string2 = Type.getType((String)annotationNode.desc).getClassName();
            if (!MixinExtrasService.getInstance().isClassOwned(string2) || !string2.endsWith(string)) continue;
            return annotationNode;
        }
        return null;
    }

    public static Type getConstantType(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode instanceof TypeInsnNode) {
            return null;
        }
        return Bytecode.getConstantType((AbstractInsnNode)abstractInsnNode);
    }
}

