/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.utils;

import com.llamalad7.mixinextras.utils.ASMUtils;
import com.llamalad7.mixinextras.utils.CompatibilityHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.SignaturePrinter;

public class InjectorUtils {
    public static boolean isVirtualRedirect(InjectionNodes.InjectionNode injectionNode) {
        return injectionNode.isReplaced() && injectionNode.hasDecoration("redirector") && injectionNode.getCurrentTarget().getOpcode() != 184;
    }

    public static boolean isDynamicInstanceofRedirect(InjectionNodes.InjectionNode injectionNode) {
        AbstractInsnNode abstractInsnNode = injectionNode.getOriginalTarget();
        injectionNode = injectionNode.getCurrentTarget();
        return abstractInsnNode.getOpcode() == 193 && injectionNode instanceof MethodInsnNode && Type.getReturnType((String)((MethodInsnNode)injectionNode).desc).equals((Object)Type.getType(Class.class));
    }

    public static void checkForDupedNews(Map object) {
        object = object.entrySet().iterator();
        while (object.hasNext()) {
            for (InjectionNodes.InjectionNode injectionNode : (List)((Map.Entry)object.next()).getValue()) {
                AbstractInsnNode abstractInsnNode = injectionNode.getCurrentTarget();
                if (abstractInsnNode.getOpcode() != 187 || abstractInsnNode.getNext().getOpcode() != 89) continue;
                injectionNode.decorate("mixinextras_newIsDuped", (Object)Boolean.TRUE);
            }
        }
    }

    public static boolean isDupedNew(InjectionNodes.InjectionNode injectionNode) {
        AbstractInsnNode abstractInsnNode = injectionNode.getCurrentTarget();
        return abstractInsnNode != null && abstractInsnNode.getOpcode() == 187 && injectionNode.hasDecoration("mixinextras_newIsDuped");
    }

    public static boolean isDupedFactoryRedirect(InjectionNodes.InjectionNode injectionNode) {
        AbstractInsnNode abstractInsnNode = injectionNode.getOriginalTarget();
        return injectionNode.isReplaced() && abstractInsnNode.getOpcode() == 187 && !injectionNode.hasDecoration("mixinextras_wrappedOperation") && injectionNode.hasDecoration("mixinextras_newIsDuped");
    }

    public static void checkForImmediatePops(Map object) {
        object = object.values().iterator();
        while (object.hasNext()) {
            for (InjectionNodes.InjectionNode injectionNode : (List)object.next()) {
                AbstractInsnNode abstractInsnNode = injectionNode.getCurrentTarget();
                if (!(abstractInsnNode instanceof MethodInsnNode) || !InjectorUtils.isTypePoppedByInstruction(Type.getReturnType((String)((MethodInsnNode)abstractInsnNode).desc), abstractInsnNode.getNext())) continue;
                injectionNode.decorate("mixinextras_operationIsImmediatelyPopped", (Object)Boolean.TRUE);
            }
        }
    }

    private static boolean isTypePoppedByInstruction(Type type, AbstractInsnNode abstractInsnNode) {
        switch (type.getSize()) {
            case 2: {
                return abstractInsnNode.getOpcode() == 88;
            }
            case 1: {
                return abstractInsnNode.getOpcode() == 87;
            }
        }
        return false;
    }

    public static LocalVariableDiscriminator.Context getOrCreateLocalContext(Target target, InjectionNodes.InjectionNode injectionNode, InjectionInfo injectionInfo, Type type, boolean bl) {
        String string = InjectorUtils.getLocalContextKey(type, bl);
        if (injectionNode.hasDecoration(string)) {
            return (LocalVariableDiscriminator.Context)injectionNode.getDecoration(string);
        }
        target = CompatibilityHelper.makeLvtContext(injectionInfo, type, bl, target, injectionNode.getCurrentTarget());
        injectionNode.decorate(string, (Object)target);
        return target;
    }

    private static String getLocalContextKey(Type type, boolean bl) {
        return String.format("mixinextras_persistent_localContext(%s,%s)", type, bl ? "argsOnly" : "fullFrame");
    }

    public static void printLocals(Target target, AbstractInsnNode abstractInsnNode, LocalVariableDiscriminator.Context context, LocalVariableDiscriminator localVariableDiscriminator, Type type, boolean bl) {
        int n2 = target.isStatic ? 0 : 1;
        new PrettyPrinter().kvWidth(20).kv("Target Class", (Object)target.classNode.name.replace('/', '.')).kv("Target Method", (Object)target.method.name).kv("Capture Type", (Object)SignaturePrinter.getTypeName((Type)type, (boolean)false)).kv("Instruction", "[%d] %s %s", new Object[]{target.insns.indexOf(abstractInsnNode), abstractInsnNode.getClass().getSimpleName(), Bytecode.getOpcodeName((int)abstractInsnNode.getOpcode())}).hr().kv("Match mode", (Object)(InjectorUtils.isImplicit(localVariableDiscriminator, n2) ? "IMPLICIT (match single)" : "EXPLICIT (match by criteria)")).kv("Match ordinal", localVariableDiscriminator.getOrdinal() < 0 ? "any" : Integer.valueOf(localVariableDiscriminator.getOrdinal())).kv("Match index", localVariableDiscriminator.getIndex() < n2 ? "any" : Integer.valueOf(localVariableDiscriminator.getIndex())).kv("Match name(s)", localVariableDiscriminator.hasNames() ? localVariableDiscriminator.getNames() : "any").kv("Args only", (Object)bl).hr().add((PrettyPrinter.IPrettyPrintable)context).print(System.err);
    }

    private static boolean isImplicit(LocalVariableDiscriminator localVariableDiscriminator, int n2) {
        return localVariableDiscriminator.getOrdinal() < 0 && localVariableDiscriminator.getIndex() < n2 && localVariableDiscriminator.getNames().isEmpty();
    }

    public static void decorateInjectorSpecific(InjectionNodes.InjectionNode injectionNode, InjectionInfo injectionInfo, String string, Object object) {
        if (!injectionNode.hasDecoration(string)) {
            injectionNode.decorate(string, new HashMap());
        }
        ((Map)injectionNode.getDecoration(string)).put(injectionInfo, object);
    }

    public static Object getInjectorSpecificDecoration(InjectionNodes.InjectionNode object, InjectionInfo injectionInfo, String string) {
        if ((object = (Map)object.getDecoration(string)) == null) {
            return null;
        }
        return object.get(injectionInfo);
    }

    public static boolean hasInjectorSpecificDecoration(InjectionNodes.InjectionNode object, InjectionInfo injectionInfo, String string) {
        if ((object = (Map)object.getDecoration(string)) == null) {
            return false;
        }
        return object.containsKey(injectionInfo);
    }

    public static void coerceReturnType(Injector.InjectorData injectorData, InsnList insnList, Type type) {
        if (injectorData.coerceReturnType && type.getSort() >= 9) {
            insnList.add((AbstractInsnNode)new TypeInsnNode(192, type.getInternalName()));
        }
    }

    public static AbstractInsnNode findCoerce(InjectionNodes.InjectionNode injectionNode, Type type) {
        if (!injectionNode.isReplaced() || InjectorUtils.isDynamicInstanceofRedirect(injectionNode)) {
            return null;
        }
        if (!((injectionNode = injectionNode.getCurrentTarget()) instanceof MethodInsnNode)) {
            return null;
        }
        injectionNode = (MethodInsnNode)injectionNode;
        if (ASMUtils.isPrimitive(type) || Type.getReturnType((String)injectionNode.desc).equals((Object)type)) {
            return null;
        }
        if (injectionNode.getNext().getOpcode() == 192) {
            TypeInsnNode typeInsnNode = (TypeInsnNode)injectionNode.getNext();
            if (typeInsnNode.desc.equals(type.getInternalName())) {
                return typeInsnNode;
            }
        }
        throw new AssertionError((Object)String.format("Could not find @Coerce CHECKCAST instruction! Expected '%s' but got '%s'! Please inform LlamaLad7!", "[CHECKCAST] " + type.getInternalName(), Bytecode.describeNode((AbstractInsnNode)injectionNode.getNext())));
    }
}

