/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.stream.Collectors;

interface InternalConstructor {
    public Object newInstance(Object ... var1);

    public static InternalConstructor of(Class clazz, Class ... classArray) {
        Constructor constructor;
        try {
            constructor = clazz.getDeclaredConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(String.format("Failed to find constructor %s(%s)! Please report to LlamaLad7!", clazz, Arrays.stream(classArray).map(Class::getName).collect(Collectors.joining(", "))), noSuchMethodException);
        }
        constructor.setAccessible(true);
        return objectArray -> {
            try {
                return constructor.newInstance(objectArray);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                throw new RuntimeException(String.format("Failed to construct %s(%s) with args [%s]! Please report to LlamaLad7!", clazz, Arrays.stream(classArray).map(Class::getName).collect(Collectors.joining(", ")), Arrays.stream(objectArray).map(Object::toString).collect(Collectors.joining(", "))), reflectiveOperationException);
            }
        };
    }

    public static InternalConstructor of(String string, Class ... classArray) {
        try {
            return InternalConstructor.of(Class.forName(string), classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(String.format("Failed to find class %s! Please report to LlamaLad7!", string), classNotFoundException);
        }
    }
}

