/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.spongepowered.asm.util.VersionNumber;

public class MixinAPVersion {
    private static final VersionNumber a = VersionNumber.parse((String)"0.8.3");
    private static boolean b = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void check(ProcessingEnvironment processingEnvironment) {
        if (b) {
            return;
        }
        b = true;
        try {
            VersionNumber versionNumber;
            InputStream inputStream;
            block11: {
                block10: {
                    inputStream = MixinAPVersion.findBootstrapClass();
                    try {
                        if (inputStream != null) break block10;
                        MixinAPVersion.printFailed(processingEnvironment);
                        if (inputStream == null) return;
                    }
                    catch (Throwable throwable) {
                        if (inputStream == null) throw throwable;
                        try {
                            inputStream.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    inputStream.close();
                    return;
                }
                ClassNode classNode = new ClassNode();
                new ClassReader(inputStream).accept((ClassVisitor)classNode, 1);
                versionNumber = MixinAPVersion.getBootstrapVersion(classNode);
                if (versionNumber != null) break block11;
                MixinAPVersion.printFailed(processingEnvironment);
                if (inputStream == null) return;
                inputStream.close();
                return;
            }
            if (versionNumber.compareTo(a) < 0) {
                throw new IllegalStateException("MixinExtras requires the Mixin AP to be at least 0.8.3");
            }
            if (inputStream == null) return;
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            MixinAPVersion.printFailed(processingEnvironment);
            return;
        }
    }

    private static VersionNumber getBootstrapVersion(ClassNode object) {
        for (FieldNode fieldNode : ((ClassNode)object).fields) {
            if (!fieldNode.name.equals("VERSION")) continue;
            if (!(fieldNode.value instanceof String)) {
                return null;
            }
            return VersionNumber.parse((String)((String)fieldNode.value));
        }
        return null;
    }

    private static void printFailed(ProcessingEnvironment processingEnvironment) {
        processingEnvironment.getMessager().printMessage(Diagnostic.Kind.WARNING, "[MixinExtras] Failed to determine Mixin version. Assuming >=0.8.3");
    }

    private static InputStream findBootstrapClass() {
        Enumeration<URL> enumeration = MixinAPVersion.class.getClassLoader().getResources("org/spongepowered/asm/launch/MixinBootstrap.class");
        if (!enumeration.hasMoreElements()) {
            return null;
        }
        return enumeration.nextElement().openStream();
    }
}

