/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.wrapper;

import com.llamalad7.mixinextras.injector.LateApplyingInjectorInfo;
import com.llamalad7.mixinextras.sugar.impl.SingleIterationList;
import com.llamalad7.mixinextras.utils.CompatibilityHelper;
import com.llamalad7.mixinextras.utils.MixinInternals;
import com.llamalad7.mixinextras.wrapper.InjectorWrapperImpl$HandlerCallCallback;
import com.llamalad7.mixinextras.wrapper.WrapperInjectionInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;

public abstract class InjectorWrapperImpl {
    private final InjectionInfo b;
    protected final ClassNode a;
    private final boolean c;

    protected InjectorWrapperImpl(InjectionInfo injectionInfo, MixinTargetContext mixinTargetContext, MethodNode methodNode, AnnotationNode annotationNode, boolean bl) {
        this.b = injectionInfo;
        this.a = mixinTargetContext.getTargetClassNode();
        this.c = bl;
    }

    public boolean usesGranularInject() {
        return this.c;
    }

    protected abstract InjectionInfo getDelegate();

    protected abstract MethodNode getHandler();

    protected boolean isValid() {
        return this.getDelegate().isValid();
    }

    public int getOrder() {
        return CompatibilityHelper.getOrder(this.getDelegate());
    }

    protected void prepare() {
        this.getDelegate().prepare();
        MethodNode methodNode = this.getHandler();
        methodNode.visibleAnnotations.remove(InjectionInfo.getInjectorAnnotation((IMixinInfo)CompatibilityHelper.getMixin(this.b).getMixin(), (MethodNode)methodNode));
    }

    protected void preInject() {
        CompatibilityHelper.preInject(this.getDelegate());
    }

    protected void doInject() {
        if (this.c) {
            this.granularInject((target, injectionNode, methodInsnNode) -> {});
            return;
        }
        if (this.getDelegate() instanceof LateApplyingInjectorInfo) {
            ((LateApplyingInjectorInfo)this.getDelegate()).lateInject();
            return;
        }
        this.getDelegate().inject();
    }

    protected void granularInject(InjectorWrapperImpl$HandlerCallCallback injectorWrapperImpl$HandlerCallCallback) {
        InjectionInfo injectionInfo = this.getDelegate();
        if (injectionInfo instanceof WrapperInjectionInfo) {
            ((WrapperInjectionInfo)injectionInfo).a.granularInject(injectorWrapperImpl$HandlerCallCallback);
            return;
        }
        this.doGranularInject(injectorWrapperImpl$HandlerCallCallback);
    }

    protected void doPostInject(Runnable runnable) {
        runnable.run();
    }

    protected void addCallbackInvocation(MethodNode methodNode) {
        this.getDelegate().addCallbackInvocation(methodNode);
    }

    protected RuntimeException granularInjectNotSupported() {
        return new IllegalStateException(this.getDelegate().getClass() + " does not support granular injection! Please report to LlamaLad7!");
    }

    private void doGranularInject(InjectorWrapperImpl$HandlerCallCallback injectorWrapperImpl$HandlerCallCallback) {
        InjectionInfo injectionInfo = this.getDelegate();
        Map map = MixinInternals.getTargets(injectionInfo);
        injectionInfo = MixinInternals.getInjector(injectionInfo);
        for (Map.Entry entry : map.entrySet()) {
            Target target = (Target)entry.getKey();
            HashSet<MethodInsnNode> hashSet = new HashSet<MethodInsnNode>(this.findHandlerCalls(target));
            for (InjectionNodes.InjectionNode injectionNode : (List)entry.getValue()) {
                InjectorWrapperImpl.inject((Injector)injectionInfo, target, injectionNode);
                for (MethodInsnNode methodInsnNode : this.findHandlerCalls(target)) {
                    if (!hashSet.add(methodInsnNode)) continue;
                    injectorWrapperImpl$HandlerCallCallback.onFound(target, injectionNode, methodInsnNode);
                }
            }
            InjectorWrapperImpl.postInject((Injector)injectionInfo, target, (List)entry.getValue());
        }
        map.clear();
    }

    private List findHandlerCalls(Target object) {
        MethodNode methodNode = this.getHandler();
        ArrayList<AbstractInsnNode> arrayList = new ArrayList<AbstractInsnNode>();
        object = object.iterator();
        while (object.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)object.next();
            if (!(abstractInsnNode instanceof MethodInsnNode)) continue;
            abstractInsnNode = (MethodInsnNode)abstractInsnNode;
            if (!abstractInsnNode.owner.equals(this.a.name) || !abstractInsnNode.name.equals(methodNode.name) || !abstractInsnNode.desc.equals(methodNode.desc)) continue;
            arrayList.add(abstractInsnNode);
        }
        return arrayList;
    }

    private static void inject(Injector injector, Target target, InjectionNodes.InjectionNode injectionNode) {
        injector.inject(target, (List)new SingleIterationList(Collections.singletonList(injectionNode), 0));
    }

    private static void postInject(Injector injector, Target target, List list) {
        injector.inject(target, (List)new SingleIterationList(list, 1));
    }
}

