/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.jgsi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.modmuss50.jgsi.HTTPServer;
import me.modmuss50.jgsi.api.GameStateIntegration;
import me.modmuss50.jgsi.api.models.Auth;
import me.modmuss50.jgsi.api.models.GameState;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GameStateIntegrationImpl
implements GameStateIntegration {
    private int port = 8181;
    private List<Consumer<GameState>> updateListeners = new ArrayList<Consumer<GameState>>();
    private List<Consumer<String>> rawListeners = new ArrayList<Consumer<String>>();
    private List<Predicate<Auth>> authPredicates = new ArrayList<Predicate<Auth>>();
    private @Nullable HTTPServer httpServer;
    private GameState gameState;

    private GameStateIntegrationImpl() {
    }

    public static GameStateIntegration create() {
        return new GameStateIntegrationImpl();
    }

    @Override
    public GameStateIntegrationImpl start() throws IOException {
        if (this.httpServer != null) {
            throw new RuntimeException("server already started");
        }
        this.httpServer = new HTTPServer(this);
        return this;
    }

    @Override
    public GameStateIntegration onUpdate(Consumer<GameState> state) {
        this.updateListeners.add(state);
        return this;
    }

    @Override
    public GameStateIntegration onUpdateRaw(Consumer<String> rawPayload) {
        this.rawListeners.add(rawPayload);
        return this;
    }

    @Override
    public GameState getSate() {
        return this.gameState;
    }

    void handle(GameState gameState, String raw) {
        this.gameState = gameState;
        this.updateListeners.forEach(gameStateConsumer -> gameStateConsumer.accept(gameState));
        this.rawListeners.forEach(stringConsumer -> stringConsumer.accept(raw));
    }

    @Override
    public GameStateIntegrationImpl setPort(int port) {
        this.port = port;
        return this;
    }

    @Override
    public GameStateIntegration validateAuth(Predicate<Auth> authPredicate) {
        this.authPredicates.add(authPredicate);
        return this;
    }

    boolean isValidAuth(Auth auth) {
        if (this.authPredicates.isEmpty()) {
            return true;
        }
        return this.authPredicates.stream().anyMatch(authPredicate -> authPredicate.test(auth));
    }

    public int getPort() {
        return this.port;
    }

    public @Nullable HTTPServer getHttpServer() {
        return this.httpServer;
    }
}

