/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.jgsi;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.javalin.Context;
import io.javalin.Javalin;
import java.io.IOException;
import me.modmuss50.jgsi.GameStateIntegrationImpl;
import me.modmuss50.jgsi.api.models.GameState;

class HTTPServer {
    private static final Gson GSON = new GsonBuilder().create();
    private GameStateIntegrationImpl gameStateIntegration;
    private Javalin javalin;

    HTTPServer(GameStateIntegrationImpl integration) throws IOException {
        this.gameStateIntegration = integration;
        this.javalin = Javalin.create().start(integration.getPort());
        this.javalin.post("/", this::handlePost);
        System.out.println("Http server running @ http://localhost:" + integration.getPort());
    }

    private void handlePost(Context context) {
        String body = context.body();
        GameState gameState = (GameState)GSON.fromJson(body, GameState.class);
        if (gameState != null) {
            if (!this.gameStateIntegration.isValidAuth(gameState.auth)) {
                System.out.println("Forbidden connection from " + context.ip());
                context.status(403);
                return;
            }
            this.gameStateIntegration.handle(gameState, body);
        }
        context.status(200);
    }
}

