/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.remotesign;

import java.io.File;
import me.modmuss50.remotesign.DummySignatureProvider;
import me.modmuss50.remotesign.RemoteSignJarTask;
import me.modmuss50.remotesign.RemoteSignatureProvider;
import me.modmuss50.remotesign.SignatureMethod;
import me.modmuss50.remotesign.SignatureProvider;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublicationArtifact;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public abstract class RemoteSignExtension {
    private final Project project;
    private final File tempDir;

    abstract Property<String> getRequestUrl();

    abstract Property<String> getPgpAuthKey();

    abstract Property<String> getJarAuthKey();

    abstract Property<Boolean> getUseDummyForTesting();

    public RemoteSignExtension(Project project) {
        this.project = project;
        this.getRequestUrl().finalizeValueOnRead();
        this.getPgpAuthKey().finalizeValueOnRead();
        this.getJarAuthKey().finalizeValueOnRead();
        this.getUseDummyForTesting().convention((Object)false).finalizeValueOnRead();
        this.tempDir = new File(project.getBuildDir(), "remotesign");
    }

    public void sign(Publication ... publications) {
        for (Publication publication : publications) {
            this.signArtifact((PublicationInternal)publication);
        }
    }

    public void sign(AbstractArchiveTask ... tasks) {
        for (AbstractArchiveTask task : tasks) {
            String name = "sign" + StringUtils.capitalize((String)task.getName());
            this.project.getTasks().register(name, RemoteSignJarTask.class, remoteSignJarTask -> {
                remoteSignJarTask.getInput().set(task.getArchiveFile());
                remoteSignJarTask.getOutput().set(this.getOutputFile(name, ((RegularFile)task.getArchiveFile().get()).getAsFile()));
                remoteSignJarTask.getSignatureMethod().set((Object)SignatureMethod.JARSIGN);
                remoteSignJarTask.setGroup("sign");
                remoteSignJarTask.dependsOn(new Object[]{task});
            });
        }
    }

    public TaskProvider<RemoteSignJarTask> sign(File inputFile, File outputFile, String name) {
        return this.project.getTasks().register("sign" + StringUtils.capitalize((String)name), RemoteSignJarTask.class, remoteSignJarTask -> {
            remoteSignJarTask.getInput().set(inputFile);
            remoteSignJarTask.getOutput().set(outputFile);
            remoteSignJarTask.getSignatureMethod().set((Object)SignatureMethod.JARSIGN);
            remoteSignJarTask.setGroup("sign");
        });
    }

    private <T extends PublicationArtifact> void signArtifact(PublicationInternal<T> publication) {
        String taskNamePrefix = "sign" + StringGroovyMethods.capitalize((CharSequence)publication.getName());
        int i = 0;
        for (PublicationArtifact artifact : publication.getPublishableArtifacts()) {
            String name = taskNamePrefix + i++;
            TaskProvider task = this.project.getTasks().register(name, RemoteSignJarTask.class, remoteSignJarTask -> {
                remoteSignJarTask.getInput().set(artifact.getFile());
                remoteSignJarTask.getOutput().set(this.getOutputFile(name, artifact.getFile(), "asc"));
                remoteSignJarTask.getSignatureMethod().set((Object)SignatureMethod.PGPSIGN);
                remoteSignJarTask.setGroup("sign");
                remoteSignJarTask.dependsOn(new Object[]{artifact.getBuildDependencies()});
            });
            PublicationArtifact derivedArtifact = publication.addDerivedArtifact(artifact, (PublicationInternal.DerivedArtifact)new SignedArtifact(task));
            derivedArtifact.builtBy(new Object[]{task});
        }
    }

    private File getOutputFile(String name, File input) {
        return new File(this.tempDir, name + "/" + input.getName());
    }

    private File getOutputFile(String name, File input, String ext) {
        return new File(this.tempDir, name + "/" + input.getName() + "." + ext);
    }

    @Internal
    public SignatureProvider signatureProvider(SignatureMethod method) {
        if (((Boolean)this.getUseDummyForTesting().get()).booleanValue()) {
            return new DummySignatureProvider(method);
        }
        return new RemoteSignatureProvider(method, (String)this.getRequestUrl().get(), method == SignatureMethod.PGPSIGN ? (String)this.getPgpAuthKey().get() : (String)this.getJarAuthKey().get());
    }

    private static class SignedArtifact
    implements PublicationInternal.DerivedArtifact {
        private final TaskProvider<RemoteSignJarTask> task;

        private SignedArtifact(TaskProvider<RemoteSignJarTask> task) {
            this.task = task;
        }

        public boolean shouldBePublished() {
            return ((RemoteSignJarTask)((Object)this.task.get())).isEnabled();
        }

        public File create() {
            return ((RegularFile)((RemoteSignJarTask)((Object)this.task.get())).getOutput().get()).getAsFile();
        }
    }
}

