/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.remotesign;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.inject.Inject;
import me.modmuss50.remotesign.RemoteSignExtension;
import me.modmuss50.remotesign.SignatureMethod;
import me.modmuss50.remotesign.SignatureProvider;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

public abstract class RemoteSignJarTask
extends DefaultTask {
    @InputFile
    abstract RegularFileProperty getInput();

    @Input
    abstract Property<SignatureMethod> getSignatureMethod();

    @Input
    protected abstract Property<SignatureProvider> getSignatureProvider();

    @OutputFile
    abstract RegularFileProperty getOutput();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    public RemoteSignJarTask() {
        this.getInput().finalizeValueOnRead();
        this.getOutput().finalizeValueOnRead();
        this.getSignatureMethod().finalizeValueOnRead();
        this.getSignatureProvider().set(this.getSignatureMethod().map(signatureMethod -> {
            RemoteSignExtension extension = (RemoteSignExtension)this.getProject().getExtensions().getByType(RemoteSignExtension.class);
            return extension.signatureProvider((SignatureMethod)signatureMethod);
        }));
    }

    @TaskAction
    public void doTask() {
        WorkQueue workQueue = this.getWorkerExecutor().noIsolation();
        workQueue.submit(SignWorkAction.class, parameters -> {
            parameters.getInputFile().set((Provider)this.getInput());
            parameters.getOutputFile().set((Provider)this.getOutput());
            parameters.getSignatureProvider().set((Object)((SignatureProvider)this.getSignatureProvider().get()));
        });
    }

    public static abstract class SignWorkAction
    implements WorkAction<SignWorkParameters> {
        public void execute() {
            File input = (File)((SignWorkParameters)this.getParameters()).getInputFile().getAsFile().get();
            File output = ((RegularFile)((SignWorkParameters)this.getParameters()).getOutputFile().get()).getAsFile();
            if (!input.exists() || input.length() == 0L) {
                throw new UncheckedIOException(new FileNotFoundException(input.getAbsolutePath() + " does not exist or is empty"));
            }
            try (OutputStream outputStream = Files.newOutputStream(output.toPath(), new OpenOption[0]);){
                ((SignatureProvider)((SignWorkParameters)this.getParameters()).getSignatureProvider().get()).sign(input, outputStream);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to sign jar", e);
            }
        }
    }

    public static interface SignWorkParameters
    extends WorkParameters {
        public RegularFileProperty getInputFile();

        public RegularFileProperty getOutputFile();

        public Property<SignatureProvider> getSignatureProvider();
    }
}

