/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.remotesign;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import me.modmuss50.remotesign.SignatureMethod;
import me.modmuss50.remotesign.SignatureProvider;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class RemoteSignatureProvider
implements SignatureProvider {
    private static final int MAX_RETRIES = 5;
    private final SignatureMethod signatureMethod;
    private final String serverUrl;
    private final String authKey;

    public RemoteSignatureProvider(SignatureMethod signatureMethod, String serverUrl, String authKey) {
        this.signatureMethod = Objects.requireNonNull(signatureMethod);
        this.serverUrl = Objects.requireNonNull(serverUrl);
        this.authKey = Objects.requireNonNull(authKey);
    }

    @Override
    public void sign(File file, OutputStream outputStream) throws IOException {
        Throwable exception = null;
        for (int i = 0; i < 5; ++i) {
            byte[] bytes;
            try {
                bytes = this.signFile(file);
            }
            catch (IOException e) {
                if (exception == null) {
                    exception = new IOException("Failed to sign: " + file);
                }
                exception.addSuppressed(e);
                continue;
            }
            IOUtils.copy((InputStream)new ByteArrayInputStream(bytes), (OutputStream)outputStream);
            return;
        }
        throw exception;
    }

    private byte[] signFile(File file) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost request = new HttpPost(this.serverUrl);
        request.setEntity(MultipartEntityBuilder.create().addTextBody("op", this.signatureMethod.name()).addTextBody("key", this.authKey).addBinaryBody("file", file).build());
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException("Failed to post, return code: " + response.getStatusLine().getStatusCode());
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int copied = IOUtils.copy((InputStream)response.getEntity().getContent(), (OutputStream)outputStream);
        if (copied == 0) {
            throw new IOException("No data copied");
        }
        return outputStream.toByteArray();
    }
}

