/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.fractions;

import com.google.common.math.LongMath;
import java.text.DecimalFormat;
import org.jetbrains.annotations.NotNull;

public final class Fraction
extends Number
implements Comparable<Fraction> {
    private static final Fraction EMPTY = Fraction.ofWhole(0L);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###.###");
    private final long numerator;
    private final long denominator;
    private final boolean integer;
    private boolean simplified;

    private Fraction(long numerator, long denominator) {
        if (denominator > 0L) {
            this.numerator = numerator;
            this.denominator = denominator;
        } else if (denominator < 0L) {
            this.numerator = -numerator;
            this.denominator = -denominator;
        } else {
            throw new ArithmeticException("/ by zero");
        }
        this.integer = (double)this.intValue() == this.doubleValue();
        this.simplified = this.numerator >= -1L && this.numerator <= 1L || this.denominator == 1L;
    }

    public static Fraction empty() {
        return EMPTY;
    }

    public static Fraction ofWhole(long whole) {
        return new Fraction(whole, 1L);
    }

    public static Fraction of(long numerator, long denominator) {
        return new Fraction(numerator, denominator);
    }

    public static Fraction of(long whole, long numerator, long denominator) {
        return Fraction.of(numerator + whole * denominator, denominator);
    }

    public static Fraction from(double value) {
        int whole = (int)value;
        double part = value - (double)whole;
        int i = 1;
        long numerator;
        double tem;
        while (!(Math.abs((tem = part / (1.0 / (double)i)) - (double)(numerator = Math.round(tem))) < 1.0E-5)) {
            ++i;
        }
        return Fraction.of(whole, numerator, i);
    }

    public long getNumerator() {
        return this.numerator;
    }

    public long getDenominator() {
        return this.denominator;
    }

    public Fraction add(Fraction other) {
        if (other.numerator == 0L) {
            return this;
        }
        return Fraction.of(this.numerator * other.denominator + other.numerator * this.denominator, this.denominator * other.denominator);
    }

    public Fraction minus(Fraction other) {
        if (other.numerator == 0L) {
            return this;
        }
        return Fraction.of(this.numerator * other.denominator - other.numerator * this.denominator, this.denominator * other.denominator);
    }

    public Fraction multiply(Fraction other) {
        if (other.numerator == other.denominator) {
            return this;
        }
        return Fraction.of(this.numerator * other.numerator, this.denominator * other.denominator);
    }

    public Fraction divide(Fraction other) {
        if (other.numerator == other.denominator) {
            return this;
        }
        return Fraction.of(this.numerator * other.denominator, this.denominator * other.numerator);
    }

    public Fraction inverse() {
        if (this.numerator == this.denominator) {
            return this;
        }
        Fraction fraction = Fraction.of(this.denominator, this.numerator);
        fraction.simplified = fraction.simplified && this.simplified;
        return fraction;
    }

    public Fraction simplify() {
        if (this.simplified) {
            return this;
        }
        if (this.numerator == 0L) {
            return Fraction.ofWhole(0L);
        }
        long gcd = LongMath.gcd((long)Math.abs(this.numerator), (long)this.denominator);
        Fraction fraction = Fraction.of(this.numerator / gcd, this.denominator / gcd);
        fraction.simplified = true;
        return fraction;
    }

    public boolean isGreaterThan(Fraction fraction) {
        return this.compareTo(fraction) > 0;
    }

    public boolean isLessThan(Fraction fraction) {
        return this.compareTo(fraction) < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fraction fraction = (Fraction)o;
        return this.numerator * fraction.denominator == this.denominator * fraction.numerator;
    }

    public int hashCode() {
        return Double.hashCode(this.doubleValue());
    }

    @Override
    public int compareTo(@NotNull Fraction fraction) {
        return Long.compare(this.numerator * fraction.denominator, this.denominator * fraction.numerator);
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        return this.numerator / this.denominator;
    }

    @Override
    public float floatValue() {
        return (float)this.numerator / (float)this.denominator;
    }

    @Override
    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public String toDecimalString() {
        return DECIMAL_FORMAT.format(this.doubleValue());
    }

    public String toString() {
        if (this.integer) {
            return this.toDecimalString();
        }
        return String.format("%s (%d/%d)", this.toDecimalString(), this.numerator, this.denominator);
    }
}

