/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.server;

import java.util.List;
import net.minecraft.class_1703;
import net.minecraft.class_1799;

@FunctionalInterface
public interface DumpHandler<T extends class_1703> {
    boolean dump(ContainerContext<T> context, class_1799 stackToInsert);
    
    static StackAccessor getOccupiedSlotWithRoomForStack(class_1799 stack, List<StackAccessor> inventoryStacks) {
        for (StackAccessor inventoryStack : inventoryStacks) {
            if (canStackAddMore(inventoryStack.getItemStack(), stack)) {
                return inventoryStack;
            }
        }
        
        return null;
    }
    
    static StackAccessor getEmptySlot(List<StackAccessor> inventoryStacks) {
        for (StackAccessor inventoryStack : inventoryStacks) {
            if (inventoryStack.getItemStack().method_7960()) {
                return inventoryStack;
            }
        }
        
        return null;
    }
    
    static boolean canStackAddMore(class_1799 existingStack, class_1799 stack) {
        return !existingStack.method_7960() && class_1799.method_7987(existingStack, stack) && existingStack.method_7946() && existingStack.method_7947() + stack.method_7947() <= existingStack.method_7914();
    }
}
