/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.server;

import net.minecraft.class_1703;
import net.minecraft.class_1799;

@FunctionalInterface
public interface GridCleanHandler<T extends class_1703> {
    void clean(ContainerContext<T> context);
    
    static void error(String translationKey) {
        throw new IllegalStateException(translationKey);
    }
    
    static <T extends class_1703> void returnSlotToPlayerInventory(ContainerContext<T> context, StackAccessor stackAccessor) {
        DumpHandler<T> dumpHandler = context.getContainerInfo().getDumpHandler();
        class_1799 stackToReturn = stackAccessor.getItemStack();
        if (!stackToReturn.method_7960()) {
            for (; stackToReturn.method_7947() > 0; stackAccessor.takeStack(1)) {
                class_1799 stackToInsert = stackToReturn.method_7972();
                stackToInsert.method_7939(1);
                if (!dumpHandler.dump(context, stackToInsert)) {
                    error("rei.rei.no.slot.in.inv");
                }
            }
        }
    }
}
