/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.impl.Internals;
import me.shedaniel.rei.utils.CollectionUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public interface ClientHelper {
    public static ClientHelper getInstance() {
        return Internals.getClientHelper();
    }

    public boolean isCheating();

    public void setCheating(boolean var1);

    public List<class_1799> getInventoryItemsTypes();

    @Deprecated
    public void openRecipeViewingScreen(Map<RecipeCategory<?>, List<RecipeDisplay>> var1);

    public boolean tryCheatingEntry(EntryStack var1);

    default public boolean tryCheatingStack(class_1799 stack) {
        return this.tryCheatingEntry(EntryStack.create(stack));
    }

    @Deprecated
    default public boolean executeRecipeKeyBind(EntryStack stack) {
        return this.openView(ViewSearchBuilder.builder().addRecipesFor(stack).setOutputNotice(stack).fillPreferredOpenedCategory());
    }

    @Deprecated
    default public boolean executeRecipeKeyBind(class_1799 stack) {
        return this.executeRecipeKeyBind(EntryStack.create(stack));
    }

    @Deprecated
    default public boolean executeUsageKeyBind(EntryStack stack) {
        return this.openView(ViewSearchBuilder.builder().addUsagesFor(stack).setInputNotice(stack).fillPreferredOpenedCategory());
    }

    @Deprecated
    default public boolean executeUsageKeyBind(class_1799 stack) {
        return this.executeUsageKeyBind(EntryStack.create(stack));
    }

    public String getModFromItem(class_1792 var1);

    public void sendDeletePacket();

    public class_2561 getFormattedModFromItem(class_1792 var1);

    public class_2561 getFormattedModFromIdentifier(class_2960 var1);

    default public String getModFromIdentifier(class_2960 identifier) {
        if (identifier == null) {
            return "";
        }
        return this.getModFromModId(identifier.method_12836());
    }

    public String getModFromModId(String var1);

    @Deprecated
    default public boolean executeViewAllRecipesKeyBind() {
        return this.openView(ViewSearchBuilder.builder().addAllCategories().fillPreferredOpenedCategory());
    }

    @Deprecated
    default public boolean executeViewAllRecipesFromCategory(class_2960 category) {
        return this.openView(ViewSearchBuilder.builder().addCategory(category).fillPreferredOpenedCategory());
    }

    @Deprecated
    default public boolean executeViewAllRecipesFromCategories(List<class_2960> categories) {
        return this.openView(ViewSearchBuilder.builder().addCategories(categories).fillPreferredOpenedCategory());
    }

    public boolean openView(ViewSearchBuilder var1);

    public boolean canUseMovePackets();

    public static interface ViewSearchBuilder {
        public static ViewSearchBuilder builder() {
            return Internals.createViewSearchBuilder();
        }

        public ViewSearchBuilder addCategory(class_2960 var1);

        public ViewSearchBuilder addCategories(Collection<class_2960> var1);

        default public ViewSearchBuilder addAllCategories() {
            return this.addCategories(CollectionUtils.map(RecipeHelper.getInstance().getAllCategories(), RecipeCategory::getIdentifier));
        }

        public @NotNull Set<class_2960> getCategories();

        public ViewSearchBuilder addRecipesFor(EntryStack var1);

        public @NotNull List<EntryStack> getRecipesFor();

        public ViewSearchBuilder addUsagesFor(EntryStack var1);

        public @NotNull List<EntryStack> getUsagesFor();

        public ViewSearchBuilder setPreferredOpenedCategory(@Nullable class_2960 var1);

        public @Nullable class_2960 getPreferredOpenedCategory();

        public ViewSearchBuilder fillPreferredOpenedCategory();

        public ViewSearchBuilder setInputNotice(@Nullable EntryStack var1);

        public @Nullable EntryStack getInputNotice();

        public ViewSearchBuilder setOutputNotice(@Nullable EntryStack var1);

        public @Nullable EntryStack getOutputNotice();

        public @NotNull Map<RecipeCategory<?>, List<RecipeDisplay>> buildMap();
    }
}

