/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.rei.api.EntryStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;

public class CollectionUtils {
    public static <A, B> List<B> getOrPutEmptyList(Map<A, List<B>> map, A key) {
        List<B> b = map.get(key);
        if (b != null) {
            return b;
        }
        map.put(key, Lists.newArrayList());
        return map.get(key);
    }

    public static <T> T findFirstOrNullEquals(List<T> list, T obj) {
        for (T t : list) {
            if (!t.equals(obj)) continue;
            return t;
        }
        return null;
    }

    public static <T, R> List<R> castAndMap(List<T> list, Class<R> castClass) {
        ArrayList<T> l = new ArrayList<T>();
        for (T t : list) {
            if (!castClass.isAssignableFrom(t.getClass())) continue;
            l.add(t);
        }
        return l;
    }

    public static <T> T findFirstOrNull(List<T> list, Predicate<T> predicate) {
        for (T t : list) {
            if (!predicate.test(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> boolean anyMatch(List<T> list, Predicate<T> predicate) {
        for (T t : list) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean anyMatchEqualsAll(List<EntryStack> list, EntryStack stack) {
        for (EntryStack t : list) {
            if (!t.equalsAll(stack)) continue;
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean anyMatchEqualsEntryIgnoreAmount(List<EntryStack> list, EntryStack stack) {
        for (EntryStack t : list) {
            if (!t.equalsIgnoreAmount(stack)) continue;
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static EntryStack firstOrNullEqualsAll(List<EntryStack> list, EntryStack stack) {
        for (EntryStack t : list) {
            if (!t.equalsAll(stack)) continue;
            return t;
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public static EntryStack findFirstOrNullEqualsEntryIgnoreAmount(Collection<EntryStack> list, EntryStack stack) {
        for (EntryStack t : list) {
            if (!t.equalsIgnoreAmount(stack)) continue;
            return t;
        }
        return null;
    }

    public static <T> List<T> filter(List<T> list, Predicate<T> predicate) {
        ArrayList l = Lists.newArrayList();
        for (T t : list) {
            if (!predicate.test(t)) continue;
            l.add(t);
        }
        return l;
    }

    public static <T> Set<T> filter(Set<T> list, Predicate<T> predicate) {
        LinkedHashSet l = Sets.newLinkedHashSet();
        for (T t : list) {
            if (!predicate.test(t)) continue;
            l.add(t);
        }
        return l;
    }

    public static <T> List<T> filterSetToList(Set<T> list, Predicate<T> predicate) {
        ArrayList l = Lists.newArrayList();
        for (T t : list) {
            if (!predicate.test(t)) continue;
            l.add(t);
        }
        return l;
    }

    public static <T, R> List<R> map(List<T> list, Function<T, R> function) {
        ArrayList<R> l = new ArrayList<R>(list.size() + 1);
        for (T t : list) {
            l.add(function.apply(t));
        }
        return l;
    }

    public static <T, R> List<R> map(Collection<T> list, Function<T, R> function) {
        ArrayList<R> l = new ArrayList<R>(list.size() + 1);
        for (T t : list) {
            l.add(function.apply(t));
        }
        return l;
    }

    public static <T, R> List<R> mapParallel(Collection<T> list, Function<T, R> function) {
        return list.parallelStream().map(function).collect(Collectors.toList());
    }

    public static <T, R, C extends Collection<R>> C mapParallel(Collection<T> list, Function<T, R> function, Supplier<C> supplier) {
        return (C)((Collection)list.parallelStream().map(function).collect(Collectors.toCollection(supplier)));
    }

    public static <T, R> List<R> map(T[] list, Function<T, R> function) {
        ArrayList<R> l = new ArrayList<R>(list.length + 1);
        for (T t : list) {
            l.add(function.apply(t));
        }
        return l;
    }

    public static <T, R> Optional<R> mapAndMax(List<T> list, Function<T, R> function, Comparator<R> comparator) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return list.stream().max(Comparator.comparing(function, comparator)).map(function);
    }

    public static <T, R> Optional<R> mapAndMax(T[] list, Function<T, R> function, Comparator<R> comparator) {
        if (list.length <= 0) {
            return Optional.empty();
        }
        return Stream.of(list).max(Comparator.comparing(function, comparator)).map(function);
    }

    public static <T> Optional<T> max(List<T> list, Comparator<T> comparator) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return list.stream().max(comparator);
    }

    public static <T> Optional<T> max(T[] list, Comparator<T> comparator) {
        if (list.length <= 0) {
            return Optional.empty();
        }
        return Stream.of(list).max(comparator);
    }

    public static String joinToString(List<String> list, String separator) {
        StringJoiner joiner = new StringJoiner(separator);
        for (String t : list) {
            joiner.add(t);
        }
        return joiner.toString();
    }

    public static String joinToString(String[] list, String separator) {
        StringJoiner joiner = new StringJoiner(separator);
        for (String t : list) {
            joiner.add(t);
        }
        return joiner.toString();
    }

    public static <T> String mapAndJoinToString(List<T> list, Function<T, String> function, String separator) {
        StringJoiner joiner = new StringJoiner(separator);
        for (T t : list) {
            joiner.add(function.apply(t));
        }
        return joiner.toString();
    }

    public static <T> String mapAndJoinToString(T[] list, Function<T, String> function, String separator) {
        StringJoiner joiner = new StringJoiner(separator);
        for (T t : list) {
            joiner.add(function.apply(t));
        }
        return joiner.toString();
    }

    public static <T, R> List<R> filterAndMap(List<T> list, Predicate<T> predicate, Function<T, R> function) {
        ArrayList l = null;
        for (T t : list) {
            if (!predicate.test(t)) continue;
            if (l == null) {
                l = Lists.newArrayList();
            }
            l.add(function.apply(t));
        }
        return l == null ? Collections.emptyList() : l;
    }

    public static <T> int sumInt(List<T> list, Function<T, Integer> function) {
        int sum = 0;
        for (T t : list) {
            sum += function.apply(t).intValue();
        }
        return sum;
    }

    public static <T> int sumInt(List<Integer> list) {
        int sum = 0;
        for (int t : list) {
            sum += t;
        }
        return sum;
    }

    public static <T> double sumDouble(List<T> list, Function<T, Double> function) {
        double sum = 0.0;
        for (T t : list) {
            sum += function.apply(t).doubleValue();
        }
        return sum;
    }

    public static <T> double sumDouble(List<Double> list) {
        double sum = 0.0;
        for (double t : list) {
            sum += t;
        }
        return sum;
    }

    public static <T> Iterable<Iterable<T>> partition(final List<T> list, final int size) {
        return () -> new UnmodifiableIterator<Iterable<T>>(){
            int i = 0;
            int partitionSize = class_3532.method_15386((float)((float)list.size() / (float)size));

            public boolean hasNext() {
                return this.i < this.partitionSize;
            }

            public Iterable<T> next() {
                UnmodifiableIterator iterator = new UnmodifiableIterator<T>(){
                    int cursor;
                    int curSize;
                    {
                        this.cursor = i++ * size;
                        this.curSize = this.cursor + Math.min(list.size() - this.cursor, size);
                    }

                    public boolean hasNext() {
                        return this.cursor < this.curSize;
                    }

                    public T next() {
                        return list.get(this.cursor++);
                    }
                };
                return () -> 1.lambda$next$0((UnmodifiableIterator)iterator);
            }

            private static /* synthetic */ Iterator lambda$next$0(UnmodifiableIterator iterator) {
                return iterator;
            }
        };
    }
}

