/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.api;

import me.shedaniel.rei.impl.Internals;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;

public interface BuiltinPlugin {
    class_2960 CRAFTING = new class_2960("minecraft", "plugins/crafting");
    class_2960 SMELTING = new class_2960("minecraft", "plugins/smelting");
    class_2960 SMOKING = new class_2960("minecraft", "plugins/smoking");
    class_2960 BLASTING = new class_2960("minecraft", "plugins/blasting");
    class_2960 CAMPFIRE = new class_2960("minecraft", "plugins/campfire");
    class_2960 STONE_CUTTING = new class_2960("minecraft", "plugins/stone_cutting");
    class_2960 STRIPPING = new class_2960("minecraft", "plugins/stripping");
    class_2960 BREWING = new class_2960("minecraft", "plugins/brewing");
    class_2960 PLUGIN = new class_2960("roughlyenoughitems", "default_plugin");
    class_2960 COMPOSTING = new class_2960("minecraft", "plugins/composting");
    class_2960 FUEL = new class_2960("minecraft", "plugins/fuel");
    class_2960 SMITHING = new class_2960("minecraft", "plugins/smithing");
    class_2960 BEACON = new class_2960("minecraft", "plugins/beacon");
    class_2960 BEACON_PAYMENT = new class_2960("minecraft", "plugins/beacon_payment");
    class_2960 TILLING = new class_2960("minecraft", "plugins/tilling");
    class_2960 PATHING = new class_2960("minecraft", "plugins/pathing");
    class_2960 INFO = new class_2960("roughlyenoughitems", "plugins/information");
    
    static BuiltinPlugin getInstance() {
        return Internals.getBuiltinPlugin();
    }
    
    default void registerBrewingRecipe(class_1799 input, class_1856 ingredient, class_1799 output) {
        registerBrewingRecipe(class_1856.method_8101(input), ingredient, output);
    }
    
    void registerBrewingRecipe(class_1856 input, class_1856 ingredient, class_1799 output);
    
    void registerInformation(List<EntryStack> entryStacks, class_2561 name, UnaryOperator<List<class_2561>> textBuilder);
    
    default void registerInformation(EntryStack entryStack, class_2561 name, UnaryOperator<List<class_2561>> textBuilder) {
        registerInformation(Collections.singletonList(entryStack), name, textBuilder);
    }
}
