/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.api;

import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.gui.config.DisplayPanelLocation;
import net.minecraft.class_1269;

import static net.minecraft.world.InteractionResult.PASS;

public interface OverlayDecider {
    boolean isHandingScreen(Class<?> screen);
    
    default class_1269 shouldScreenBeOverlayed(Class<?> screen) {
        return class_1269.field_5811;
    }
    
    /**
     * Gets the priority of the handler, the higher it is, the earlier it is called.
     *
     * @return the priority in float
     */
    default float getPriority() {
        return 0f;
    }
    
    /**
     * Checks if REI should recalculate the overlay bounds
     *
     * @param location  the location of the display panel
     * @param rectangle the current overlay bounds
     * @return whether REI should recalculate the overlay bounds
     */
    default boolean shouldRecalculateArea(DisplayPanelLocation location, Rectangle rectangle) {
        return false;
    }
    
    /**
     * Checks if mouse is inside the overlay
     *
     * @param mouseX mouse's x coordinates
     * @param mouseY mouse's y coordinates
     * @return whether mouse is inside the overlay
     */
    default class_1269 isInZone(double mouseX, double mouseY) {
        return field_5811;
    }
}
