/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api;

import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.widgets.Widgets;
import me.shedaniel.rei.gui.entries.RecipeEntry;
import me.shedaniel.rei.gui.entries.SimpleRecipeEntry;
import me.shedaniel.rei.gui.widget.Widget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public interface RecipeCategory<T extends RecipeDisplay> {
    public @NotNull class_2960 getIdentifier();

    default public @NotNull EntryStack getLogo() {
        return EntryStack.empty();
    }

    public @NotNull String getCategoryName();

    default public @NotNull RecipeEntry getSimpleRenderer(T recipe) {
        return SimpleRecipeEntry.from(() -> recipe.getInputEntries(), () -> recipe.getResultingEntries());
    }

    default public @NotNull List<Widget> setupDisplay(T recipeDisplay, Rectangle bounds) {
        return Collections.singletonList(Widgets.createCategoryBase(bounds));
    }

    default public int getDisplayHeight() {
        return 66;
    }

    default public int getDisplayWidth(T display) {
        return 150;
    }

    default public int getMaximumRecipePerPage() {
        return 99;
    }

    default public int getFixedRecipesPerPage() {
        return -1;
    }
}

