/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.widgets;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import me.shedaniel.math.Dimension;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.DrawableConsumer;
import me.shedaniel.rei.api.widgets.Arrow;
import me.shedaniel.rei.api.widgets.BurningFire;
import me.shedaniel.rei.api.widgets.Button;
import me.shedaniel.rei.api.widgets.Label;
import me.shedaniel.rei.api.widgets.Panel;
import me.shedaniel.rei.api.widgets.Slot;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.Internals;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class Widgets {
    private Widgets() {
    }

    public static @NotNull Widget createDrawableWidget(@NotNull DrawableConsumer drawable) {
        return Internals.getWidgetsProvider().createDrawableWidget(drawable);
    }

    public static @NotNull Widget wrapVanillaWidget(@NotNull class_364 element) {
        return new VanillaWrappedWidget(element);
    }

    public static @NotNull Widget createTexturedWidget(@NotNull class_2960 identifier, @NotNull Rectangle bounds) {
        return Widgets.createTexturedWidget(identifier, bounds, 0.0f, 0.0f);
    }

    public static @NotNull Widget createTexturedWidget(@NotNull class_2960 identifier, int x, int y, int width, int height) {
        return Widgets.createTexturedWidget(identifier, x, y, 0.0f, 0.0f, width, height);
    }

    public static @NotNull Widget createTexturedWidget(@NotNull class_2960 identifier, @NotNull Rectangle bounds, float u, float v) {
        return Widgets.createTexturedWidget(identifier, bounds, u, v, 256, 256);
    }

    public static @NotNull Widget createTexturedWidget(@NotNull class_2960 identifier, int x, int y, float u, float v, int width, int height) {
        return Widgets.createTexturedWidget(identifier, x, y, u, v, width, height, 256, 256);
    }

    public static @NotNull Widget createTexturedWidget(@NotNull class_2960 identifier, @NotNull Rectangle bounds, float u, float v, int textureWidth, int textureHeight) {
        return Widgets.createTexturedWidget(identifier, bounds.x, bounds.y, u, v, bounds.width, bounds.height, bounds.width, bounds.height, textureWidth, textureHeight);
    }

    public static @NotNull Widget createTexturedWidget(@NotNull class_2960 identifier, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        return Widgets.createTexturedWidget(identifier, x, y, u, v, width, height, width, height, textureWidth, textureHeight);
    }

    public static @NotNull Widget createTexturedWidget(@NotNull class_2960 identifier, @NotNull Rectangle bounds, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        return Widgets.createTexturedWidget(identifier, bounds.x, bounds.y, u, v, bounds.width, bounds.height, uWidth, vHeight, textureWidth, textureHeight);
    }

    public static @NotNull Widget createTexturedWidget(@NotNull class_2960 identifier, int x, int y, float u, float v, int width, int height, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        return Widgets.createDrawableWidget(Internals.getWidgetsProvider().createTexturedConsumer(identifier, x, y, width, height, u, v, uWidth, vHeight, textureWidth, textureHeight));
    }

    public static @NotNull Widget createFilledRectangle(@NotNull Rectangle rectangle, int color) {
        return Widgets.createDrawableWidget(Internals.getWidgetsProvider().createFillRectangleConsumer(rectangle, color));
    }

    public static @NotNull Label createLabel(@NotNull Point point, @NotNull class_2561 text) {
        return Internals.getWidgetsProvider().createLabel(point, (class_5348)text);
    }

    public static @NotNull Label createClickableLabel(@NotNull Point point, @NotNull class_2561 text, @Nullable Consumer<Label> onClick) {
        return Widgets.createLabel(point, text).clickable().onClick(onClick);
    }

    public static @NotNull Arrow createArrow(@NotNull Point point) {
        return Internals.getWidgetsProvider().createArrow(new Rectangle(point, new Dimension(24, 17)));
    }

    public static @NotNull BurningFire createBurningFire(@NotNull Point point) {
        return Internals.getWidgetsProvider().createBurningFire(new Rectangle(point, new Dimension(14, 14)));
    }

    public static @NotNull Widget createSlotBackground(@NotNull Point point) {
        return Widgets.createSlotBase(new Rectangle(point.x - 1, point.y - 1, 18, 18));
    }

    public static @NotNull Widget createResultSlotBackground(@NotNull Point point) {
        return Widgets.createSlotBase(new Rectangle(point.x - 5, point.y - 5, 26, 26));
    }

    public static @NotNull Panel createRecipeBase(@NotNull Rectangle rectangle) {
        return Internals.getWidgetsProvider().createPanelWidget(rectangle).yTextureOffset(ConfigObject.getInstance().getRecipeBorderType().getYOffset()).rendering(Widgets::shouldRecipeBaseRender);
    }

    public static @NotNull Panel createCategoryBase(@NotNull Rectangle rectangle) {
        return Internals.getWidgetsProvider().createPanelWidget(rectangle).rendering(Widgets::shouldSlotBaseRender);
    }

    private static boolean shouldRecipeBaseRender(@NotNull Panel panel) {
        return ConfigObject.getInstance().getRecipeBorderType().isRendering() && Internals.getWidgetsProvider().isRenderingPanel(panel);
    }

    public static @NotNull Panel createRecipeBase(@NotNull Rectangle rectangle, int color) {
        return Widgets.createRecipeBase(rectangle).color(color);
    }

    public static @NotNull Panel createCategoryBase(@NotNull Rectangle rectangle, int color) {
        return Widgets.createCategoryBase(rectangle).color(color);
    }

    public static @NotNull Panel createSlotBase(@NotNull Rectangle rectangle) {
        return Internals.getWidgetsProvider().createPanelWidget(rectangle).yTextureOffset(-66).rendering(Widgets::shouldSlotBaseRender);
    }

    private static boolean shouldSlotBaseRender(@NotNull Panel panel) {
        return true;
    }

    public static @NotNull Panel createSlotBase(@NotNull Rectangle rectangle, int color) {
        return Widgets.createSlotBase(rectangle).color(color);
    }

    public static @NotNull Slot createSlot(@NotNull Point point) {
        return Internals.getWidgetsProvider().createSlot(point);
    }

    public static @NotNull Button createButton(@NotNull Rectangle bounds, @NotNull class_2561 text) {
        return Internals.getWidgetsProvider().createButton(bounds, text);
    }

    public static void produceClickSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
    }

    private static class VanillaWrappedWidget
    extends Widget {
        private class_364 element;

        public VanillaWrappedWidget(class_364 element) {
            this.element = Objects.requireNonNull(element);
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            if (this.element instanceof class_332) {
                ((class_332)this.element).method_25304(this.getZ());
            }
            if (this.element instanceof class_4068) {
                ((class_4068)this.element).method_25394(matrices, mouseX, mouseY, delta);
            }
        }

        public List<? extends class_364> method_25396() {
            return Collections.singletonList(this.element);
        }
    }
}

