/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.BuiltinPlugin;
import me.shedaniel.rei.api.ClickAreaHandler;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.DrawableConsumer;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.fractions.Fraction;
import me.shedaniel.rei.api.subsets.SubsetsRegistry;
import me.shedaniel.rei.api.widgets.Arrow;
import me.shedaniel.rei.api.widgets.BurningFire;
import me.shedaniel.rei.api.widgets.Button;
import me.shedaniel.rei.api.widgets.Label;
import me.shedaniel.rei.api.widgets.Panel;
import me.shedaniel.rei.api.widgets.Slot;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.gui.widget.Widget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Internals {
    private static Supplier<ConfigManager> configManager = Internals::throwNotSetup;
    private static Supplier<ClientHelper> clientHelper = Internals::throwNotSetup;
    private static Supplier<RecipeHelper> recipeHelper = Internals::throwNotSetup;
    private static Supplier<REIHelper> reiHelper = Internals::throwNotSetup;
    private static Supplier<FluidSupportProvider> fluidSupportProvider = Internals::throwNotSetup;
    private static Supplier<EntryStackProvider> entryStackProvider = Internals::throwNotSetup;
    private static Supplier<SubsetsRegistry> subsetsRegistry = Internals::throwNotSetup;
    private static Supplier<EntryRegistry> entryRegistry = Internals::throwNotSetup;
    private static Supplier<DisplayHelper> displayHelper = Internals::throwNotSetup;
    private static Supplier<WidgetsProvider> widgetsProvider = Internals::throwNotSetup;
    private static Supplier<ClientHelper.ViewSearchBuilder> viewSearchBuilder = Internals::throwNotSetup;
    private static Function<@NotNull Boolean, ClickAreaHandler.Result> clickAreaHandlerResult = result -> (ClickAreaHandler.Result)Internals.throwNotSetup();
    private static BiFunction<@Nullable Point, Collection<class_2561>, Tooltip> tooltipProvider = (point, texts) -> (Tooltip)Internals.throwNotSetup();
    private static Supplier<BuiltinPlugin> builtinPlugin = Internals::throwNotSetup;

    private static <T> T throwNotSetup() {
        throw new AssertionError((Object)"REI Internals have not been initialized!");
    }

    public static @NotNull ConfigManager getConfigManager() {
        return configManager.get();
    }

    public static @NotNull ClientHelper getClientHelper() {
        return clientHelper.get();
    }

    public static @NotNull RecipeHelper getRecipeHelper() {
        return recipeHelper.get();
    }

    public static @NotNull REIHelper getREIHelper() {
        return reiHelper.get();
    }

    public static @NotNull FluidSupportProvider getFluidSupportProvider() {
        return fluidSupportProvider.get();
    }

    public static @NotNull EntryStackProvider getEntryStackProvider() {
        return entryStackProvider.get();
    }

    public static @NotNull SubsetsRegistry getSubsetsRegistry() {
        return subsetsRegistry.get();
    }

    public static @NotNull EntryRegistry getEntryRegistry() {
        return entryRegistry.get();
    }

    public static @NotNull DisplayHelper getDisplayHelper() {
        return displayHelper.get();
    }

    public static @NotNull WidgetsProvider getWidgetsProvider() {
        return widgetsProvider.get();
    }

    public static @NotNull ClientHelper.ViewSearchBuilder createViewSearchBuilder() {
        return viewSearchBuilder.get();
    }

    public static @NotNull ClickAreaHandler.Result createClickAreaHandlerResult(boolean applicable) {
        return clickAreaHandlerResult.apply(applicable);
    }

    public static @NotNull Tooltip createTooltip(@Nullable Point point, Collection<class_2561> texts) {
        return tooltipProvider.apply(point, texts);
    }

    public static @NotNull BuiltinPlugin getBuiltinPlugin() {
        return builtinPlugin.get();
    }

    public static <T> void attachInstance(T instance, Class<T> clazz) {
        Internals.attachInstance(() -> instance, clazz.getSimpleName());
    }

    public static <T> void attachInstance(T instance, String name) {
        try {
            for (Field field : Internals.class.getDeclaredFields()) {
                if (!field.getName().equalsIgnoreCase(name)) continue;
                field.setAccessible(true);
                field.set(null, instance);
                return;
            }
            throw new RuntimeException("Failed to attach " + instance + " with field name: " + name);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface WidgetsProvider {
        public boolean isRenderingPanel(Panel var1);

        public Widget createDrawableWidget(DrawableConsumer var1);

        public Slot createSlot(Point var1);

        public Button createButton(Rectangle var1, class_2561 var2);

        public Panel createPanelWidget(Rectangle var1);

        public Label createLabel(Point var1, class_5348 var2);

        public Arrow createArrow(Rectangle var1);

        public BurningFire createBurningFire(Rectangle var1);

        public DrawableConsumer createTexturedConsumer(class_2960 var1, int var2, int var3, int var4, int var5, float var6, float var7, int var8, int var9, int var10, int var11);

        public DrawableConsumer createFillRectangleConsumer(Rectangle var1, int var2);
    }

    public static interface EntryStackProvider {
        public EntryStack empty();

        public EntryStack fluid(class_3611 var1);

        public EntryStack fluid(class_3611 var1, Fraction var2);

        public EntryStack item(class_1799 var1);
    }
}

