/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.server;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.rei.server.ContainerContext;
import me.shedaniel.rei.server.DumpHandler;
import me.shedaniel.rei.server.GridCleanHandler;
import me.shedaniel.rei.server.InventoryStackAccessor;
import me.shedaniel.rei.server.RecipeFinder;
import me.shedaniel.rei.server.RecipeFinderPopulator;
import me.shedaniel.rei.server.SlotStackAccessor;
import me.shedaniel.rei.server.StackAccessor;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_3222;

public interface ContainerInfo<T extends class_1703> {
    public Class<? extends class_1703> getContainerClass();

    default public StackAccessor getStack(ContainerContext<T> context, int slotIndex) {
        return new SlotStackAccessor(context.getContainer().method_7611(slotIndex));
    }

    default public GridCleanHandler<T> getGridCleanHandler() {
        return context -> {
            Object container = context.getContainer();
            for (StackAccessor gridStack : this.getGridStacks(context)) {
                GridCleanHandler.returnSlotToPlayerInventory(context, gridStack);
            }
            this.clearCraftingSlots(container);
        };
    }

    default public DumpHandler<T> getDumpHandler() {
        return (context, stackToInsert) -> {
            List<StackAccessor> inventoryStacks = context.getContainerInfo().getInventoryStacks(context);
            StackAccessor nextSlot = DumpHandler.getOccupiedSlotWithRoomForStack(stackToInsert, inventoryStacks);
            if (nextSlot == null) {
                nextSlot = DumpHandler.getEmptySlot(inventoryStacks);
            }
            if (nextSlot == null) {
                return false;
            }
            class_1799 stack = stackToInsert.method_7972();
            stack.method_7939(nextSlot.getItemStack().method_7947() + stack.method_7947());
            nextSlot.setItemStack(stack);
            return true;
        };
    }

    default public RecipeFinderPopulator<T> getRecipeFinderPopulator() {
        return context -> recipeFinder -> {
            for (StackAccessor inventoryStack : this.getInventoryStacks(context)) {
                recipeFinder.addNormalItem(inventoryStack.getItemStack());
            }
            this.populateRecipeFinder(context.getContainer(), (RecipeFinder)recipeFinder);
        };
    }

    default public List<StackAccessor> getGridStacks(ContainerContext<T> context) {
        return IntStream.range(0, this.getCraftingWidth(context.getContainer()) * this.getCraftingHeight(context.getContainer()) + 1).filter(value -> value != this.getCraftingResultSlotIndex(context.getContainer())).mapToObj(context::getStack).collect(Collectors.toList());
    }

    default public List<StackAccessor> getInventoryStacks(ContainerContext<T> context) {
        class_1661 inventory = context.getPlayerEntity().field_7514;
        return IntStream.range(0, inventory.field_7547.size()).mapToObj(index -> new InventoryStackAccessor((class_1263)inventory, index)).collect(Collectors.toList());
    }

    default public void markDirty(ContainerContext<T> context) {
        context.getPlayerEntity().field_7514.method_5431();
        context.getContainer().method_7623();
        class_2371 defaultedList = class_2371.method_10211();
        for (class_1735 slot : context.getPlayerEntity().field_7512.field_7761) {
            defaultedList.add((Object)slot.method_7677());
        }
        ((class_3222)context.getPlayerEntity()).method_7634(context.getPlayerEntity().field_7512, defaultedList);
    }

    public int getCraftingResultSlotIndex(T var1);

    public int getCraftingWidth(T var1);

    public int getCraftingHeight(T var1);

    default public void clearCraftingSlots(T container) {
    }

    default public void populateRecipeFinder(T container, RecipeFinder var1) {
    }
}

