/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.*;
import me.shedaniel.rei.api.favorites.FavoriteEntry;
import me.shedaniel.rei.api.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.fractions.Fraction;
import me.shedaniel.rei.api.plugins.REIPluginV0;
import me.shedaniel.rei.plugin.autocrafting.DefaultRecipeBookHandler;
import me.shedaniel.rei.plugin.beacon.DefaultBeaconBaseCategory;
import me.shedaniel.rei.plugin.beacon.DefaultBeaconBaseDisplay;
import me.shedaniel.rei.plugin.beacon_payment.DefaultBeaconPaymentCategory;
import me.shedaniel.rei.plugin.beacon_payment.DefaultBeaconPaymentDisplay;
import me.shedaniel.rei.plugin.blasting.DefaultBlastingDisplay;
import me.shedaniel.rei.plugin.brewing.DefaultBrewingCategory;
import me.shedaniel.rei.plugin.brewing.DefaultBrewingDisplay;
import me.shedaniel.rei.plugin.brewing.RegisteredBrewingRecipe;
import me.shedaniel.rei.plugin.campfire.DefaultCampfireCategory;
import me.shedaniel.rei.plugin.campfire.DefaultCampfireDisplay;
import me.shedaniel.rei.plugin.composting.DefaultCompostingCategory;
import me.shedaniel.rei.plugin.composting.DefaultCompostingDisplay;
import me.shedaniel.rei.plugin.cooking.DefaultCookingCategory;
import me.shedaniel.rei.plugin.crafting.DefaultCraftingCategory;
import me.shedaniel.rei.plugin.crafting.DefaultCustomDisplay;
import me.shedaniel.rei.plugin.crafting.DefaultShapedDisplay;
import me.shedaniel.rei.plugin.crafting.DefaultShapelessDisplay;
import me.shedaniel.rei.plugin.favorites.GameModeFavoriteEntry;
import me.shedaniel.rei.plugin.fuel.DefaultFuelCategory;
import me.shedaniel.rei.plugin.fuel.DefaultFuelDisplay;
import me.shedaniel.rei.plugin.information.DefaultInformationCategory;
import me.shedaniel.rei.plugin.information.DefaultInformationDisplay;
import me.shedaniel.rei.plugin.pathing.DefaultPathingCategory;
import me.shedaniel.rei.plugin.pathing.DefaultPathingDisplay;
import me.shedaniel.rei.plugin.pathing.DummyShovelItem;
import me.shedaniel.rei.plugin.smelting.DefaultSmeltingDisplay;
import me.shedaniel.rei.plugin.smithing.DefaultSmithingCategory;
import me.shedaniel.rei.plugin.smithing.DefaultSmithingDisplay;
import me.shedaniel.rei.plugin.smoking.DefaultSmokingDisplay;
import me.shedaniel.rei.plugin.stonecutting.DefaultStoneCuttingCategory;
import me.shedaniel.rei.plugin.stonecutting.DefaultStoneCuttingDisplay;
import me.shedaniel.rei.plugin.stripping.DefaultStrippingCategory;
import me.shedaniel.rei.plugin.stripping.DefaultStrippingDisplay;
import me.shedaniel.rei.plugin.stripping.DummyAxeItem;
import me.shedaniel.rei.plugin.tilling.DefaultTillingCategory;
import me.shedaniel.rei.plugin.tilling.DefaultTillingDisplay;
import me.shedaniel.rei.plugin.tilling.DummyHoeItem;
import me.shedaniel.rei.utils.CollectionUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1271;
import net.minecraft.class_1743;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1821;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_1856;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2609;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import net.minecraft.class_3611;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3871;
import net.minecraft.class_3873;
import net.minecraft.class_3874;
import net.minecraft.class_3920;
import net.minecraft.class_3962;
import net.minecraft.class_3975;
import net.minecraft.class_465;
import net.minecraft.class_472;
import net.minecraft.class_479;
import net.minecraft.class_485;
import net.minecraft.class_490;
import net.minecraft.class_518;
import net.minecraft.class_5357;
import net.minecraft.client.gui.screens.inventory.*;
import net.minecraft.world.item.*;
import net.minecraft.world.item.crafting.*;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

import java.util.*;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

import static me.shedaniel.rei.impl.Internals.attachInstance;

@Environment(EnvType.CLIENT)
public class DefaultPlugin implements REIPluginV0, BuiltinPlugin {
    private static final Logger LOGGER = LogManager.getFormatterLogger("REI/DefaultPlugin");
    public static final class_2960 CRAFTING = BuiltinPlugin.CRAFTING;
    public static final class_2960 SMELTING = BuiltinPlugin.SMELTING;
    public static final class_2960 SMOKING = BuiltinPlugin.SMOKING;
    public static final class_2960 BLASTING = BuiltinPlugin.BLASTING;
    public static final class_2960 CAMPFIRE = BuiltinPlugin.CAMPFIRE;
    public static final class_2960 STONE_CUTTING = BuiltinPlugin.STONE_CUTTING;
    public static final class_2960 STRIPPING = BuiltinPlugin.STRIPPING;
    public static final class_2960 BREWING = BuiltinPlugin.BREWING;
    public static final class_2960 PLUGIN = BuiltinPlugin.PLUGIN;
    public static final class_2960 COMPOSTING = BuiltinPlugin.COMPOSTING;
    public static final class_2960 FUEL = BuiltinPlugin.FUEL;
    public static final class_2960 SMITHING = BuiltinPlugin.SMITHING;
    public static final class_2960 BEACON = BuiltinPlugin.BEACON;
    public static final class_2960 BEACON_PAYMENT = BuiltinPlugin.BEACON_PAYMENT;
    public static final class_2960 TILLING = BuiltinPlugin.TILLING;
    public static final class_2960 PATHING = BuiltinPlugin.PATHING;
    public static final class_2960 INFO = BuiltinPlugin.INFO;
    private static final class_2960 DISPLAY_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/display.png");
    private static final class_2960 DISPLAY_TEXTURE_DARK = new class_2960("roughlyenoughitems", "textures/gui/display_dark.png");
    
    public static class_2960 getDisplayTexture() {
        return REIHelper.getInstance().getDefaultDisplayTexture();
    }
    
    public DefaultPlugin() {
        attachInstance(this, BuiltinPlugin.class);
    }
    
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static void registerBrewingDisplay(DefaultBrewingDisplay recipe) {
        RecipeHelper.getInstance().registerDisplay(recipe);
    }
    
    public static void registerBrewingRecipe(RegisteredBrewingRecipe recipe) {
        RecipeHelper.getInstance().registerDisplay(new DefaultBrewingDisplay(recipe.input, recipe.ingredient, recipe.output));
    }
    
    public static void registerInfoDisplay(DefaultInformationDisplay display) {
        RecipeHelper.getInstance().registerDisplay(display);
    }
    
    @Override
    public void registerBrewingRecipe(class_1856 input, class_1856 ingredient, class_1799 output) {
        registerBrewingRecipe(new RegisteredBrewingRecipe(input, ingredient, output));
    }
    
    @Override
    public void registerInformation(List<EntryStack> entryStacks, class_2561 name, UnaryOperator<List<class_2561>> textBuilder) {
        registerInfoDisplay(DefaultInformationDisplay.createFromEntries(entryStacks, name).lines(textBuilder.apply(Lists.newArrayList())));
    }
    
    @Override
    public class_2960 getPluginIdentifier() {
        return PLUGIN;
    }
    
    @Override
    public void registerEntries(EntryRegistry entryRegistry) {
        for (class_1792 item : class_2378.field_11142) {
            List<class_1799> stacks = null;
            try {
                stacks = entryRegistry.appendStacksForItem(item);
            } catch (Exception ignored) {
            }
            if (stacks != null) {
                for (class_1799 stack : entryRegistry.appendStacksForItem(item)) {
                    entryRegistry.registerEntry(EntryStack.create(stack));
                }
            } else
                entryRegistry.registerEntry(EntryStack.create(item));
        }
        EntryStack stack = EntryStack.create(class_1802.field_8598);
        List<EntryStack> enchantments = new ArrayList<>();
        for (class_1887 enchantment : class_2378.field_11160) {
            IntConsumer consumer = level -> {
                Map<class_1887, Integer> map = new HashMap<>();
                map.put(enchantment, level);
                class_1799 itemStack = new class_1799(class_1802.field_8598);
                class_1890.method_8214(map, itemStack);
                enchantments.add(EntryStack.create(itemStack).setting(EntryStack.Settings.CHECK_TAGS, EntryStack.Settings.TRUE));
            };
            if (enchantment.method_8183() - enchantment.method_8187() >= 10) {
                consumer.accept(enchantment.method_8187());
                consumer.accept(enchantment.method_8183());
            } else {
                for (int i = enchantment.method_8187(); i <= enchantment.method_8183(); i++) consumer.accept(i);
            }
        }
        entryRegistry.registerEntriesAfter(stack, enchantments);
        for (class_3611 fluid : class_2378.field_11154) {
            if (!fluid.method_15785().method_15769() && fluid.method_15785().method_15771())
                entryRegistry.registerEntry(EntryStack.create(fluid));
        }
    }
    
    @Override
    public void registerPluginCategories(RecipeHelper recipeHelper) {
        recipeHelper.registerCategories(
                new DefaultCraftingCategory(),
                new DefaultCookingCategory(SMELTING, EntryStack.create(class_1802.field_8732), "category.rei.smelting"),
                new DefaultCookingCategory(SMOKING, EntryStack.create(class_1802.field_16309), "category.rei.smoking"),
                new DefaultCookingCategory(BLASTING, EntryStack.create(class_1802.field_16306), "category.rei.blasting"), new DefaultCampfireCategory(),
                new DefaultStoneCuttingCategory(),
                new DefaultFuelCategory(),
                new DefaultBrewingCategory(),
                new DefaultCompostingCategory(),
                new DefaultStrippingCategory(),
                new DefaultSmithingCategory(),
                new DefaultBeaconBaseCategory(),
                new DefaultBeaconPaymentCategory(),
                new DefaultTillingCategory(),
                new DefaultPathingCategory(),
                new DefaultInformationCategory()
        );
    }
    
    @Override
    public void registerRecipeDisplays(RecipeHelper recipeHelper) {
        recipeHelper.registerRecipes(CRAFTING, class_1867.class, DefaultShapelessDisplay::new);
        recipeHelper.registerRecipes(CRAFTING, class_1869.class, DefaultShapedDisplay::new);
        recipeHelper.registerRecipes(SMELTING, class_3861.class, DefaultSmeltingDisplay::new);
        recipeHelper.registerRecipes(SMOKING, class_3862.class, DefaultSmokingDisplay::new);
        recipeHelper.registerRecipes(BLASTING, class_3859.class, DefaultBlastingDisplay::new);
        recipeHelper.registerRecipes(CAMPFIRE, class_3920.class, DefaultCampfireDisplay::new);
        recipeHelper.registerRecipes(STONE_CUTTING, class_3975.class, DefaultStoneCuttingDisplay::new);
        recipeHelper.registerRecipes(SMITHING, class_5357.class, DefaultSmithingDisplay::new);
        for (Map.Entry<class_1792, Integer> entry : class_2609.method_11196().entrySet()) {
            recipeHelper.registerDisplay(new DefaultFuelDisplay(EntryStack.create(entry.getKey()), entry.getValue()));
        }
        List<EntryStack> arrowStack = Collections.singletonList(EntryStack.create(class_1802.field_8107));
        ReferenceSet<class_1842> registeredPotions = new ReferenceOpenHashSet<>();
        EntryRegistry.getInstance().getEntryStacks().filter(entry -> entry.getItem() == class_1802.field_8150).forEach(entry -> {
            class_1842 potion = class_1844.method_8063(entry.getItemStack());
            if (registeredPotions.add(potion)) {
                List<List<EntryStack>> input = new ArrayList<>();
                for (int i = 0; i < 4; i++)
                    input.add(arrowStack);
                input.add(Collections.singletonList(EntryStack.create(entry.getItemStack())));
                for (int i = 0; i < 4; i++)
                    input.add(arrowStack);
                class_1799 outputStack = new class_1799(class_1802.field_8087, 8);
                class_1844.method_8061(outputStack, potion);
                class_1844.method_8056(outputStack, class_1844.method_8068(entry.getItemStack()));
                List<EntryStack> output = Collections.singletonList(EntryStack.create(outputStack).addSetting(EntryStack.Settings.CHECK_TAGS, EntryStack.Settings.TRUE));
                recipeHelper.registerDisplay(new DefaultCustomDisplay(null, input, output));
            }
        });
        if (class_3962.field_17566.isEmpty())
            class_3962.method_17758();
        Object2FloatMap<class_1935> compostables = class_3962.field_17566;
        int i = 0;
        Iterator<List<Object2FloatMap.Entry<class_1935>>> iterator = Iterators.partition(compostables.object2FloatEntrySet().stream().sorted(Map.Entry.comparingByValue()).iterator(), 48);
        while (iterator.hasNext()) {
            List<Object2FloatMap.Entry<class_1935>> entries = iterator.next();
            recipeHelper.registerDisplay(new DefaultCompostingDisplay(i, entries, compostables, new class_1799(class_1802.field_8324)));
            i++;
        }
        DummyAxeItem.getStrippedBlocksMap().entrySet().stream().sorted(Comparator.comparing(b -> class_2378.field_11146.method_10221(b.getKey()))).forEach(set -> {
            recipeHelper.registerDisplay(new DefaultStrippingDisplay(EntryStack.create(set.getKey()), EntryStack.create(set.getValue())));
        });
        DummyHoeItem.getTilledBlocksMap().entrySet().stream().sorted(Comparator.comparing(b -> class_2378.field_11146.method_10221(b.getKey()))).forEach(set -> {
            recipeHelper.registerDisplay(new DefaultTillingDisplay(EntryStack.create(set.getKey()), EntryStack.create(set.getValue().method_26204())));
        });
        DummyShovelItem.getPathBlocksMap().entrySet().stream().sorted(Comparator.comparing(b -> class_2378.field_11146.method_10221(b.getKey()))).forEach(set -> {
            recipeHelper.registerDisplay(new DefaultPathingDisplay(EntryStack.create(set.getKey()), EntryStack.create(set.getValue().method_26204())));
        });
        recipeHelper.registerDisplay(new DefaultBeaconBaseDisplay(CollectionUtils.map(Lists.newArrayList(class_3481.field_22275.method_15138()), class_1799::new)));
        recipeHelper.registerDisplay(new DefaultBeaconPaymentDisplay(CollectionUtils.map(Lists.newArrayList(class_3489.field_22277.method_15138()), class_1799::new)));
        Set<class_1842> potions = Sets.newLinkedHashSet();
        for (class_1856 container : class_1845.field_8957) {
            for (class_1845.class_1846<class_1842> mix : class_1845.field_8956) {
                class_1842 from = mix.from;
                class_1856 ingredient = mix.ingredient;
                class_1842 to = mix.to;
                class_1856 base = class_1856.method_26964(Arrays.stream(container.method_8105())
                        .map(class_1799::method_7972)
                        .map(stack -> class_1844.method_8061(stack, from)));
                class_1799 output = Arrays.stream(container.method_8105())
                        .map(class_1799::method_7972)
                        .map(stack -> class_1844.method_8061(stack, to))
                        .findFirst().orElse(class_1799.field_8037);
                registerBrewingRecipe(base, ingredient, output);
                potions.add(from);
                potions.add(to);
            }
        }
        for (class_1842 potion : potions) {
            for (class_1845.class_1846<class_1792> mix : class_1845.field_8959) {
                class_1792 from = mix.from;
                class_1856 ingredient = mix.ingredient;
                class_1792 to = mix.to;
                class_1856 base = class_1856.method_8101(class_1844.method_8061(new class_1799(from), potion));
                class_1799 output = class_1844.method_8061(new class_1799(to), potion);
                registerBrewingRecipe(base, ingredient, output);
            }
        }
    }
    
    @Override
    public void postRegister() {
        // TODO Turn this into an API
        // Sit tight! This will be a fast journey!
        long time = System.currentTimeMillis();
        EntryRegistry.getInstance().getEntryStacks().forEach(this::applyPotionTransformer);
        for (List<RecipeDisplay> displays : RecipeHelper.getInstance().getAllRecipesNoHandlers().values()) {
            for (RecipeDisplay display : displays) {
                for (List<EntryStack> entries : display.getInputEntries())
                    for (EntryStack stack : entries)
                        applyPotionTransformer(stack);
                for (List<EntryStack> entries : display.getResultingEntries())
                    for (EntryStack stack : entries)
                        applyPotionTransformer(stack);
            }
        }
        time = System.currentTimeMillis() - time;
        LOGGER.info("Applied Check Tags for potion in %dms.", time);
    }
    
    private void applyPotionTransformer(EntryStack stack) {
        if (stack.getItem() instanceof class_1812)
            stack.addSetting(EntryStack.Settings.CHECK_TAGS, EntryStack.Settings.TRUE);
    }
    
    @Override
    public void registerBounds(DisplayHelper displayHelper) {
        BaseBoundsHandler baseBoundsHandler = BaseBoundsHandler.getInstance();
        baseBoundsHandler.registerExclusionZones(class_485.class, new DefaultPotionEffectExclusionZones());
        baseBoundsHandler.registerExclusionZones(class_518.class, new DefaultRecipeBookExclusionZones());
        displayHelper.registerProvider(new DisplayHelper.DisplayBoundsProvider<class_465<?>>() {
            @Override
            public Rectangle getScreenBounds(class_465<?> screen) {
                return new Rectangle(screen.field_2776, screen.field_2800, screen.field_2792, screen.field_2779);
            }
            
            @Override
            public Class<?> getBaseSupportedClass() {
                return class_465.class;
            }
        });
    }
    
    @Override
    public void registerOthers(RecipeHelper recipeHelper) {
        recipeHelper.registerAutoCraftingHandler(new DefaultRecipeBookHandler());
        
        recipeHelper.registerWorkingStations(CRAFTING, EntryStack.create(class_1802.field_8465));
        recipeHelper.registerWorkingStations(SMELTING, EntryStack.create(class_1802.field_8732));
        recipeHelper.registerWorkingStations(SMOKING, EntryStack.create(class_1802.field_16309));
        recipeHelper.registerWorkingStations(BLASTING, EntryStack.create(class_1802.field_16306));
        recipeHelper.registerWorkingStations(CAMPFIRE, EntryStack.create(class_1802.field_17346), EntryStack.create(class_1802.field_23842));
        recipeHelper.registerWorkingStations(FUEL, EntryStack.create(class_1802.field_8732), EntryStack.create(class_1802.field_16309), EntryStack.create(class_1802.field_16306));
        recipeHelper.registerWorkingStations(BREWING, EntryStack.create(class_1802.field_8740));
        recipeHelper.registerWorkingStations(STONE_CUTTING, EntryStack.create(class_1802.field_16305));
        recipeHelper.registerWorkingStations(COMPOSTING, EntryStack.create(class_1802.field_17530));
        recipeHelper.registerWorkingStations(SMITHING, EntryStack.create(class_1802.field_16308));
        recipeHelper.registerWorkingStations(BEACON, EntryStack.create(class_1802.field_8668));
        recipeHelper.registerWorkingStations(BEACON_PAYMENT, EntryStack.create(class_1802.field_8668));
        Set<class_1792> axes = Sets.newHashSet(), hoes = Sets.newHashSet(), shovels = Sets.newHashSet();
        EntryRegistry.getInstance().getEntryStacks().filter(stack -> stack.getType() == EntryStack.Type.ITEM).map(EntryStack::getItem).forEach(item -> {
            if (item instanceof class_1743 && axes.add(item)) {
                recipeHelper.registerWorkingStations(STRIPPING, EntryStack.create(item));
            }
            if (item instanceof class_1794 && hoes.add(item)) {
                recipeHelper.registerWorkingStations(TILLING, EntryStack.create(item));
            }
            if (item instanceof class_1821 && shovels.add(item)) {
                recipeHelper.registerWorkingStations(PATHING, EntryStack.create(item));
            }
        });
        class_3494<class_1792> axesTag = class_310.method_1551().method_1562().method_2867().method_30218().method_30210(new class_2960("c", "axes"));
        if (axesTag != null) {
            for (class_1792 item : axesTag.method_15138()) {
                if (axes.add(item)) recipeHelper.registerWorkingStations(STRIPPING, EntryStack.create(item));
            }
        }
        class_3494<class_1792> hoesTag = class_310.method_1551().method_1562().method_2867().method_30218().method_30210(new class_2960("c", "hoes"));
        if (hoesTag != null) {
            for (class_1792 item : hoesTag.method_15138()) {
                if (hoes.add(item)) recipeHelper.registerWorkingStations(TILLING, EntryStack.create(item));
            }
        }
        class_3494<class_1792> shovelsTag = class_310.method_1551().method_1562().method_2867().method_30218().method_30210(new class_2960("c", "shovels"));
        if (shovelsTag != null) {
            for (class_1792 item : shovelsTag.method_15138()) {
                if (shovels.add(item)) recipeHelper.registerWorkingStations(PATHING, EntryStack.create(item));
            }
        }
        recipeHelper.removeAutoCraftButton(FUEL);
        recipeHelper.removeAutoCraftButton(COMPOSTING);
        recipeHelper.removeAutoCraftButton(BEACON);
        recipeHelper.removeAutoCraftButton(BEACON_PAYMENT);
        recipeHelper.removeAutoCraftButton(INFO);
        recipeHelper.registerContainerClickArea(new Rectangle(88, 32, 28, 23), class_479.class, CRAFTING);
        recipeHelper.registerContainerClickArea(new Rectangle(137, 29, 10, 13), class_490.class, CRAFTING);
        recipeHelper.registerContainerClickArea(new Rectangle(97, 16, 14, 30), class_472.class, BREWING);
        recipeHelper.registerContainerClickArea(new Rectangle(78, 32, 28, 23), class_3873.class, SMELTING);
        recipeHelper.registerContainerClickArea(new Rectangle(78, 32, 28, 23), class_3874.class, SMOKING);
        recipeHelper.registerContainerClickArea(new Rectangle(78, 32, 28, 23), class_3871.class, BLASTING);
        FluidSupportProvider.getInstance().registerProvider(itemStack -> {
            class_1792 item = itemStack.getItem();
            if (item instanceof class_1755)
                return class_1271.method_22427(Stream.of(EntryStack.create(((class_1755) item).field_7905, Fraction.ofWhole(1))));
            return class_1271.method_22430(null);
        });
//        SubsetsRegistry subsetsRegistry = SubsetsRegistry.INSTANCE;
//        subsetsRegistry.registerPathEntry("roughlyenoughitems:food", EntryStack.create(Items.MILK_BUCKET));
//        subsetsRegistry.registerPathEntry("roughlyenoughitems:food/roughlyenoughitems:cookies", EntryStack.create(Items.COOKIE));
    
        FavoriteEntryType.registry().register(GameModeFavoriteEntry.ID, GameModeFavoriteEntry.Type.INSTANCE);
        FavoriteEntryType.registry().getOrCrateSection(new class_2588(GameModeFavoriteEntry.TRANSLATION_KEY))
                .add(Arrays.stream(class_1934.values()).<FavoriteEntry>map(GameModeFavoriteEntry.Type.INSTANCE::fromArgs).toArray(FavoriteEntry[]::new));
    }
    
    @Override
    public int getPriority() {
        return -1;
    }
    
}
