/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.brewing;

import com.google.common.collect.Lists;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.plugin.DefaultPlugin;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Environment(EnvType.CLIENT)
public class DefaultBrewingDisplay implements RecipeDisplay {
    
    private EntryStack output;
    private List<EntryStack> reactant, input;
    
    @ApiStatus.Internal
    public DefaultBrewingDisplay(class_1856 input, class_1856 reactant, class_1799 output) {
        class_1799[] inputItems = input.method_8105();
        this.input = new ArrayList<>(inputItems.length);
        for (class_1799 inputItem : inputItems) {
            EntryStack entryStack = EntryStack.create(inputItem);
            entryStack.setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, s -> Collections.singletonList(new class_2588("category.rei.brewing.input").method_27692(class_124.field_1054)));
            this.input.add(entryStack);
        }
        class_1799[] reactantStacks = reactant.method_8105();
        this.reactant = new ArrayList<>(reactantStacks.length);
        for (class_1799 stack : reactantStacks) {
            EntryStack entryStack = EntryStack.create(stack);
            entryStack.setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, s -> Collections.singletonList(new class_2588("category.rei.brewing.reactant").method_27692(class_124.field_1054)));
            this.reactant.add(entryStack);
        }
        this.output = EntryStack.create(output).setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, stack -> Collections.singletonList(new class_2588("category.rei.brewing.result").method_27692(class_124.field_1054)));
    }
    
    @Override
    public @NotNull List<List<EntryStack>> getInputEntries() {
        return Lists.newArrayList(input, reactant);
    }
    
    @Override
    public @NotNull List<List<EntryStack>> getResultingEntries() {
        return Collections.singletonList(Collections.singletonList(output));
    }
    
    @Override
    public @NotNull class_2960 getRecipeCategory() {
        return DefaultPlugin.BREWING;
    }
    
    public List<EntryStack> getOutput(int slot) {
        List<EntryStack> stack = new ArrayList<>();
        for (int i = 0; i < slot * 2; i++)
            stack.add(EntryStack.empty());
        for (int i = 0; i < 6 - slot * 2; i++)
            stack.add(output);
        return stack;
    }
    
    @Override
    public @NotNull List<List<EntryStack>> getRequiredEntries() {
        return getInputEntries();
    }
}
