/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.composting;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.plugin.DefaultPlugin;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Environment(EnvType.CLIENT)
public class DefaultCompostingDisplay implements RecipeDisplay {
    private List<List<EntryStack>> inputs;
    private Object2FloatMap<class_1935> inputMap;
    private List<List<EntryStack>> output;
    private int page;
    
    public DefaultCompostingDisplay(int page, List<Object2FloatMap.Entry<class_1935>> inputs, Object2FloatMap<class_1935> map, class_1799 output) {
        this.page = page;
        {
            List<EntryStack>[] result = new List[inputs.size()];
            int i = 0;
            for (Object2FloatMap.Entry<class_1935> entry : inputs) {
                result[i] = Collections.singletonList(EntryStack.create(entry.getKey()));
                i++;
            }
            this.inputs = Arrays.asList(result);
        }
        this.inputMap = map;
        this.output = Collections.singletonList(Collections.singletonList(EntryStack.create(output)));
    }
    
    public int getPage() {
        return page;
    }
    
    @Override
    public @NotNull List<List<EntryStack>> getInputEntries() {
        return inputs;
    }
    
    public Object2FloatMap<class_1935> getInputMap() {
        return inputMap;
    }
    
    @Override
    public @NotNull List<List<EntryStack>> getResultingEntries() {
        return output;
    }
    
    @Override
    public @NotNull class_2960 getRecipeCategory() {
        return DefaultPlugin.COMPOSTING;
    }
    
    @Override
    public @NotNull List<List<EntryStack>> getRequiredEntries() {
        return inputs;
    }
}
