/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.containers;

import me.shedaniel.rei.server.ContainerInfo;
import me.shedaniel.rei.server.RecipeFinder;
import net.minecraft.class_1703;
import net.minecraft.class_1729;
import net.minecraft.class_1799;

public class CraftingContainerInfoWrapper<T extends class_1729<?>> implements ContainerInfo<T> {
    private Class<? extends class_1729<?>> containerClass;
    
    public CraftingContainerInfoWrapper(Class<T> containerClass) {
        this.containerClass = containerClass;
    }
    
    public static <R extends class_1729<?>> ContainerInfo<R> create(Class<R> containerClass) {
        return new CraftingContainerInfoWrapper<>(containerClass);
    }
    
    @Override
    public Class<? extends class_1703> getContainerClass() {
        return containerClass;
    }
    
    @Override
    public int getCraftingResultSlotIndex(T container) {
        return container.method_7655();
    }
    
    @Override
    public int getCraftingWidth(T container) {
        return container.method_7653();
    }
    
    @Override
    public int getCraftingHeight(T container) {
        return container.method_7656();
    }
    
    @Override
    public void clearCraftingSlots(T container) {
        container.method_7657();
    }
    
    @Override
    public void populateRecipeFinder(T container, RecipeFinder var1) {
        container.method_7654(new net.minecraft.class_1662() {
            @Override
            public void method_7404(class_1799 itemStack_1) {
                var1.addNormalItem(itemStack_1);
            }
        });
    }
}
