/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.favorites;

import com.google.gson.JsonObject;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.favorites.FavoriteEntry;
import me.shedaniel.rei.api.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.impl.RenderingEntry;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1109;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3417;
import net.minecraft.class_3518;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.Supplier;

public class GameModeFavoriteEntry extends FavoriteEntry {
    public static final class_2960 ID = new class_2960("roughlyenoughitems", "gamemode");
    public static final String TRANSLATION_KEY = "favorite.section.gamemode";
    public static final String KEY = "mode";
    private class_1934 gameMode;
    
    public GameModeFavoriteEntry(class_1934 gameMode) {
        this.gameMode = Objects.requireNonNull(gameMode);
    }
    
    @Override
    public boolean isInvalid() {
        return false;
    }
    
    @Override
    public EntryStack getWidget(boolean showcase) {
        return new RenderingEntry() {
            private Animator notSetOffset = new Animator(0);
            private Rectangle notSetScissorArea = new Rectangle();
            private long nextSwitch = -1;
            
            @Override
            public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                int color = bounds.contains(mouseX, mouseY) ? 0xFFEEEEEE : 0xFFAAAAAA;
                method_25296(matrices, bounds.getX(), bounds.getY(), bounds.getMaxX(), bounds.getY() + 1, color, color);
                method_25296(matrices, bounds.getX(), bounds.getMaxY() - 1, bounds.getMaxX(), bounds.getMaxY(), color, color);
                method_25296(matrices, bounds.getX(), bounds.getY(), bounds.getX() + 1, bounds.getMaxY(), color, color);
                method_25296(matrices, bounds.getMaxX() - 1, bounds.getY(), bounds.getMaxX(), bounds.getMaxY(), color, color);
                if (bounds.width > 4 && bounds.height > 4) {
                    if (gameMode == class_1934.field_9218) {
                        updateAnimator(delta);
                        notSetScissorArea.setBounds(bounds.x + 2, bounds.y + 2, bounds.width - 4, bounds.height - 4);
                        ScissorsHandler.INSTANCE.scissor(notSetScissorArea);
                        int offset = Math.round(notSetOffset.floatValue() * bounds.getHeight());
                        for (int i = 0; i <= 3; i++) {
                            class_1934 type = class_1934.method_8384(i);
                            renderGameModeText(matrices, type, bounds.getCenterX(), bounds.getCenterY() + bounds.getHeight() * i - offset, color);
                        }
                        ScissorsHandler.INSTANCE.removeLastScissor();
                    } else {
                        renderGameModeText(matrices, gameMode, bounds.getCenterX(), bounds.getCenterY(), color);
                    }
                }
            }
            
            private void updateAnimator(float delta) {
                notSetOffset.update(delta);
                if (showcase) {
                    if (nextSwitch == -1) {
                        nextSwitch = class_156.method_658();
                    }
                    if (class_156.method_658() - nextSwitch > 1000) {
                        nextSwitch = class_156.method_658();
                        notSetOffset.setTo(((int) notSetOffset.target() + 1) % 4, 500);
                    }
                } else {
                    notSetOffset.setTo((class_310.method_1551().field_1761.method_2920().method_8379() + 1) % 4, 500);
                }
            }
            
            private void renderGameModeText(class_4587 matrices, class_1934 type, int centerX, int centerY, int color) {
                class_2561 s = new class_2588("text.rei.short_gamemode." + type.method_8381());
                class_327 font = class_310.method_1551().field_1772;
                font.method_30883(matrices, s, centerX - font.method_27525(s) / 2 + (type == class_1934.field_9218 ? 0 : 0.5f), centerY - 3.5f, color);
            }
            
            @Override
            public @Nullable Tooltip getTooltip(Point mouse) {
                if (gameMode == class_1934.field_9218)
                    return Tooltip.create(mouse, new class_2588("text.rei.gamemode_button.tooltip.all"));
                return Tooltip.create(mouse, new class_2588("text.rei.gamemode_button.tooltip.entry", gameMode.method_8383().getString()));
            }
        };
    }
    
    @Override
    public boolean doAction(int button) {
        if (button == 0) {
            class_1934 type = gameMode;
            if (type == class_1934.field_9218) {
                type = class_1934.method_8384(class_310.method_1551().field_1761.method_2920().method_8379() + 1 % 4);
            }
            class_310.method_1551().field_1724.method_3142(ConfigObject.getInstance().getGamemodeCommand().replaceAll("\\{gamemode}", type.name().toLowerCase(Locale.ROOT)));
            class_310.method_1551().method_1483().method_4873(class_1109.method_4758(class_3417.field_15015, 1.0F));
            return true;
        }
        return false;
    }
    
    @Override
    public @NotNull Optional<Supplier<Collection<@NotNull FavoriteMenuEntry>>> getMenuEntries() {
        if (gameMode == class_1934.field_9218)
            return Optional.of(this::_getMenuEntries);
        return Optional.empty();
    }
    
    private Collection<FavoriteMenuEntry> _getMenuEntries() {
        return CollectionUtils.filterAndMap(Arrays.asList(class_1934.values()), mode -> mode != class_1934.field_9218, GameModeMenuEntry::new);
    }
    
    @Override
    public int hashIgnoreAmount() {
        return gameMode.ordinal();
    }
    
    @Override
    public FavoriteEntry copy() {
        return this;
    }
    
    @Override
    public class_2960 getType() {
        return ID;
    }
    
    @Override
    public boolean isSame(FavoriteEntry other) {
        if (!(other instanceof GameModeFavoriteEntry)) return false;
        GameModeFavoriteEntry that = (GameModeFavoriteEntry) other;
        return Objects.equals(gameMode, that.gameMode);
    }
    
    public enum Type implements FavoriteEntryType<GameModeFavoriteEntry> {
        INSTANCE;
        
        @Override
        public @NotNull GameModeFavoriteEntry fromJson(@NotNull JsonObject object) {
            return new GameModeFavoriteEntry(class_1934.valueOf(class_3518.method_15265(object, KEY)));
        }
        
        @Override
        public @NotNull GameModeFavoriteEntry fromArgs(Object... args) {
            return new GameModeFavoriteEntry((class_1934) args[0]);
        }
        
        @Override
        public @NotNull JsonObject toJson(@NotNull GameModeFavoriteEntry entry, @NotNull JsonObject object) {
            object.addProperty(KEY, entry.gameMode.name());
            return object;
        }
    }
    
    public static class GameModeMenuEntry extends FavoriteMenuEntry {
        public final String text;
        public final class_1934 gameMode;
        private int x, y, width;
        private boolean selected, containsMouse, rendering;
        private int textWidth = -69;
        
        public GameModeMenuEntry(class_1934 gameMode) {
            this.text = gameMode.method_8383().getString();
            this.gameMode = gameMode;
        }
        
        private int getTextWidth() {
            if (textWidth == -69) {
                this.textWidth = Math.max(0, font.method_1727(text));
            }
            return this.textWidth;
        }
        
        @Override
        public int getEntryWidth() {
            return getTextWidth() + 4;
        }
        
        @Override
        public int getEntryHeight() {
            return 12;
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }
        
        @Override
        public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
            this.x = xPos;
            this.y = yPos;
            this.selected = selected;
            this.containsMouse = containsMouse;
            this.rendering = rendering;
            this.width = width;
        }
        
        @Override
        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            boolean disabled = this.minecraft.field_1761.method_2920() == gameMode;
            if (selected && !disabled) {
                method_25294(matrices, x, y, x + width, y + 12, -12237499);
            }
            if (!disabled && selected && containsMouse) {
                REIHelper.getInstance().queueTooltip(Tooltip.create(new class_2588("text.rei.gamemode_button.tooltip.entry", text)));
            }
            String s = text;
            if (disabled) {
                s = class_124.field_1055.toString() + s;
            }
            font.method_1729(matrices, s, x + 2, y + 2, selected && !disabled ? 16777215 : 8947848);
        }
        
        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            boolean disabled = this.minecraft.field_1761.method_2920() == gameMode;
            if (!disabled && rendering && mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + 12) {
                class_310.method_1551().field_1724.method_3142(ConfigObject.getInstance().getGamemodeCommand().replaceAll("\\{gamemode}", gameMode.name().toLowerCase(Locale.ROOT)));
                minecraft.method_1483().method_4873(class_1109.method_4758(class_3417.field_15015, 1.0F));
                closeMenu();
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }
    }
}
