/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.cooking;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntList;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.TransferRecipeCategory;
import me.shedaniel.rei.api.widgets.Widgets;
import me.shedaniel.rei.gui.entries.RecipeEntry;
import me.shedaniel.rei.gui.entries.SimpleRecipeEntry;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.plugin.cooking.DefaultCookingDisplay;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;

public class DefaultCookingCategory
implements TransferRecipeCategory<DefaultCookingDisplay> {
    private class_2960 identifier;
    private EntryStack logo;
    private String categoryName;

    public DefaultCookingCategory(class_2960 identifier, EntryStack logo, String categoryName) {
        this.identifier = identifier;
        this.logo = logo;
        this.categoryName = categoryName;
    }

    public void renderRedSlots(class_4587 matrices, List<Widget> widgets, Rectangle bounds, DefaultCookingDisplay display, IntList redSlots) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.y + 10);
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, 400.0);
        if (redSlots.contains(0)) {
            class_332.method_25294((class_4587)matrices, (int)(startPoint.x + 1), (int)(startPoint.y + 1), (int)(startPoint.x + 1 + 16), (int)(startPoint.y + 1 + 16), (int)0x40FF0000);
        }
        matrices.method_22909();
    }

    public @NotNull List<Widget> setupDisplay(DefaultCookingDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.y + 10);
        double cookingTime = display.getCookingTime();
        DecimalFormat df = new DecimalFormat("###.##");
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 61, startPoint.y + 9)));
        widgets.add(Widgets.createBurningFire((Point)new Point(startPoint.x + 1, startPoint.y + 20)).animationDurationMS(10000.0));
        widgets.add(Widgets.createLabel((Point)new Point(bounds.x + bounds.width - 5, bounds.y + 5), (class_2561)new class_2588("category.rei.cooking.time&xp", new Object[]{df.format(display.getXp()), df.format(cookingTime / 20.0)})).noShadow().rightAligned().color(-12566464, -4473925));
        widgets.add(Widgets.createArrow((Point)new Point(startPoint.x + 24, startPoint.y + 8)).animationDurationTicks(cookingTime));
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 1, startPoint.y + 1)).entries((Collection)display.getInputEntries().get(0)).markInput());
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 61, startPoint.y + 9)).entries((Collection)display.getResultingEntries().get(0)).disableBackground().markOutput());
        return widgets;
    }

    public @NotNull RecipeEntry getSimpleRenderer(DefaultCookingDisplay recipe) {
        return SimpleRecipeEntry.from(Collections.singletonList(recipe.getInputEntries().get(0)), recipe.getResultingEntries());
    }

    public int getDisplayHeight() {
        return 49;
    }

    public @NotNull class_2960 getIdentifier() {
        return this.identifier;
    }

    public @NotNull EntryStack getLogo() {
        return this.logo;
    }

    public @NotNull String getCategoryName() {
        return class_1074.method_4662((String)this.categoryName, (Object[])new Object[0]);
    }
}

