/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.crafting;

import com.google.common.collect.ImmutableList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.plugin.crafting.DefaultCraftingDisplay;
import me.shedaniel.rei.utils.CollectionUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class DefaultCustomDisplay
implements DefaultCraftingDisplay {
    private List<List<EntryStack>> input;
    private List<EntryStack> output;
    private class_1860<?> possibleRecipe;
    private int width;
    private int height;

    public DefaultCustomDisplay(List<List<class_1799>> input, List<class_1799> output, class_1860<?> possibleRecipe) {
        this(possibleRecipe, CollectionUtils.map(input, EntryStack::ofItemStacks), EntryStack.ofItemStacks(output));
    }

    public DefaultCustomDisplay(class_1860<?> possibleRecipe, List<List<EntryStack>> input, List<EntryStack> output) {
        this.input = ImmutableList.copyOf(input);
        this.output = ImmutableList.copyOf(output);
        this.possibleRecipe = possibleRecipe;
        BitSet row = new BitSet(3);
        BitSet column = new BitSet(3);
        for (int i = 0; i < 9; ++i) {
            List<EntryStack> stacks;
            if (i >= this.input.size() || !(stacks = this.input.get(i)).stream().anyMatch(stack -> !stack.isEmpty())) continue;
            row.set((i - i % 3) / 3);
            column.set(i % 3);
        }
        this.width = row.cardinality();
        this.height = column.cardinality();
    }

    public DefaultCustomDisplay(List<List<class_1799>> input, List<class_1799> output) {
        this(input, output, null);
    }

    protected Optional<class_1860<?>> getRecipe() {
        return Optional.ofNullable(this.possibleRecipe);
    }

    public @NotNull Optional<class_2960> getRecipeLocation() {
        return this.getRecipe().map(class_1860::method_8114);
    }

    public @NotNull List<List<EntryStack>> getInputEntries() {
        return this.input;
    }

    public @NotNull List<List<EntryStack>> getResultingEntries() {
        return Collections.singletonList(this.output);
    }

    public @NotNull List<List<EntryStack>> getRequiredEntries() {
        return this.input;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Optional<class_1860<?>> getOptionalRecipe() {
        return Optional.ofNullable(this.possibleRecipe);
    }
}

