/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.favorites;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.favorites.FavoriteEntry;
import me.shedaniel.rei.api.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.impl.RenderingEntry;
import me.shedaniel.rei.plugin.favorites.Animator;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3518;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GameModeFavoriteEntry
extends FavoriteEntry {
    public static final class_2960 ID = new class_2960("roughlyenoughitems", "gamemode");
    public static final String TRANSLATION_KEY = "favorite.section.gamemode";
    public static final String KEY = "mode";
    private class_1934 gameMode;

    public GameModeFavoriteEntry(class_1934 gameMode) {
        this.gameMode = Objects.requireNonNull(gameMode);
    }

    public boolean isInvalid() {
        return false;
    }

    public EntryStack getWidget(final boolean showcase) {
        return new RenderingEntry(){
            private Animator notSetOffset = new Animator(0.0);
            private Rectangle notSetScissorArea = new Rectangle();
            private long nextSwitch = -1L;

            public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                int color = bounds.contains(mouseX, mouseY) ? -1118482 : -5592406;
                this.method_25296(matrices, bounds.getX(), bounds.getY(), bounds.getMaxX(), bounds.getY() + 1, color, color);
                this.method_25296(matrices, bounds.getX(), bounds.getMaxY() - 1, bounds.getMaxX(), bounds.getMaxY(), color, color);
                this.method_25296(matrices, bounds.getX(), bounds.getY(), bounds.getX() + 1, bounds.getMaxY(), color, color);
                this.method_25296(matrices, bounds.getMaxX() - 1, bounds.getY(), bounds.getMaxX(), bounds.getMaxY(), color, color);
                if (bounds.width > 4 && bounds.height > 4) {
                    if (GameModeFavoriteEntry.this.gameMode == class_1934.field_9218) {
                        this.updateAnimator(delta);
                        this.notSetScissorArea.setBounds(bounds.x + 2, bounds.y + 2, bounds.width - 4, bounds.height - 4);
                        ScissorsHandler.INSTANCE.scissor(this.notSetScissorArea);
                        int offset = Math.round(this.notSetOffset.floatValue() * (float)bounds.getHeight());
                        for (int i = 0; i <= 3; ++i) {
                            class_1934 type = class_1934.method_8384((int)i);
                            this.renderGameModeText(matrices, type, bounds.getCenterX(), bounds.getCenterY() + bounds.getHeight() * i - offset, color);
                        }
                        ScissorsHandler.INSTANCE.removeLastScissor();
                    } else {
                        this.renderGameModeText(matrices, GameModeFavoriteEntry.this.gameMode, bounds.getCenterX(), bounds.getCenterY(), color);
                    }
                }
            }

            private void updateAnimator(float delta) {
                this.notSetOffset.update(delta);
                if (showcase) {
                    if (this.nextSwitch == -1L) {
                        this.nextSwitch = class_156.method_658();
                    }
                    if (class_156.method_658() - this.nextSwitch > 1000L) {
                        this.nextSwitch = class_156.method_658();
                        this.notSetOffset.setTo(((int)this.notSetOffset.target() + 1) % 4, 500L);
                    }
                } else {
                    this.notSetOffset.setTo((class_310.method_1551().field_1761.method_2920().method_8379() + 1) % 4, 500L);
                }
            }

            private void renderGameModeText(class_4587 matrices, class_1934 type, int centerX, int centerY, int color) {
                class_2588 s = new class_2588("text.rei.short_gamemode." + type.method_8381());
                class_327 font = class_310.method_1551().field_1772;
                font.method_30883(matrices, (class_2561)s, (float)(centerX - font.method_27525((class_5348)s) / 2) + (type == class_1934.field_9218 ? 0.0f : 0.5f), (float)centerY - 3.5f, color);
            }

            public @Nullable Tooltip getTooltip(Point mouse) {
                if (GameModeFavoriteEntry.this.gameMode == class_1934.field_9218) {
                    return Tooltip.create((Point)mouse, (class_2561[])new class_2561[]{new class_2588("text.rei.gamemode_button.tooltip.all")});
                }
                return Tooltip.create((Point)mouse, (class_2561[])new class_2561[]{new class_2588("text.rei.gamemode_button.tooltip.entry", new Object[]{GameModeFavoriteEntry.this.gameMode.method_8383().getString()})});
            }
        };
    }

    public boolean doAction(int button) {
        if (button == 0) {
            class_1934 type = this.gameMode;
            if (type == class_1934.field_9218) {
                type = class_1934.method_8384((int)(class_310.method_1551().field_1761.method_2920().method_8379() + 1));
            }
            class_310.method_1551().field_1724.method_3142(ConfigObject.getInstance().getGamemodeCommand().replaceAll("\\{gamemode}", type.name().toLowerCase(Locale.ROOT)));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            return true;
        }
        return false;
    }

    public @NotNull Optional<Supplier<Collection<@NotNull FavoriteMenuEntry>>> getMenuEntries() {
        if (this.gameMode == class_1934.field_9218) {
            return Optional.of(this::_getMenuEntries);
        }
        return Optional.empty();
    }

    private Collection<FavoriteMenuEntry> _getMenuEntries() {
        return CollectionUtils.filterAndMap(Arrays.asList(class_1934.values()), mode -> mode != class_1934.field_9218, GameModeMenuEntry::new);
    }

    public int hashIgnoreAmount() {
        return this.gameMode.ordinal();
    }

    public FavoriteEntry copy() {
        return this;
    }

    public class_2960 getType() {
        return ID;
    }

    public boolean isSame(FavoriteEntry other) {
        if (!(other instanceof GameModeFavoriteEntry)) {
            return false;
        }
        GameModeFavoriteEntry that = (GameModeFavoriteEntry)other;
        return Objects.equals(this.gameMode, that.gameMode);
    }

    public static class GameModeMenuEntry
    extends FavoriteMenuEntry {
        public final String text;
        public final class_1934 gameMode;
        private int x;
        private int y;
        private int width;
        private boolean selected;
        private boolean containsMouse;
        private boolean rendering;
        private int textWidth = -69;

        public GameModeMenuEntry(class_1934 gameMode) {
            this.text = gameMode.method_8383().getString();
            this.gameMode = gameMode;
        }

        private int getTextWidth() {
            if (this.textWidth == -69) {
                this.textWidth = Math.max(0, this.font.method_1727(this.text));
            }
            return this.textWidth;
        }

        public int getEntryWidth() {
            return this.getTextWidth() + 4;
        }

        public int getEntryHeight() {
            return 12;
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
            this.x = xPos;
            this.y = yPos;
            this.selected = selected;
            this.containsMouse = containsMouse;
            this.rendering = rendering;
            this.width = width;
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            boolean disabled;
            boolean bl = disabled = this.minecraft.field_1761.method_2920() == this.gameMode;
            if (this.selected && !disabled) {
                GameModeMenuEntry.method_25294((class_4587)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + 12), (int)-12237499);
            }
            if (!disabled && this.selected && this.containsMouse) {
                REIHelper.getInstance().queueTooltip(Tooltip.create((class_2561[])new class_2561[]{new class_2588("text.rei.gamemode_button.tooltip.entry", new Object[]{this.text})}));
            }
            String s = this.text;
            if (disabled) {
                s = class_124.field_1055.toString() + s;
            }
            this.font.method_1729(matrices, s, (float)(this.x + 2), (float)(this.y + 2), this.selected && !disabled ? 0xFFFFFF : 0x888888);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            boolean disabled;
            boolean bl = disabled = this.minecraft.field_1761.method_2920() == this.gameMode;
            if (!disabled && this.rendering && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 12)) {
                class_310.method_1551().field_1724.method_3142(ConfigObject.getInstance().getGamemodeCommand().replaceAll("\\{gamemode}", this.gameMode.name().toLowerCase(Locale.ROOT)));
                this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                this.closeMenu();
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }
    }

    public static enum Type implements FavoriteEntryType<GameModeFavoriteEntry>
    {
        INSTANCE;


        public @NotNull GameModeFavoriteEntry fromJson(@NotNull JsonObject object) {
            return new GameModeFavoriteEntry(class_1934.valueOf((String)class_3518.method_15265((JsonObject)object, (String)GameModeFavoriteEntry.KEY)));
        }

        public @NotNull GameModeFavoriteEntry fromArgs(Object ... args) {
            return new GameModeFavoriteEntry((class_1934)args[0]);
        }

        public @NotNull JsonObject toJson(@NotNull GameModeFavoriteEntry entry, @NotNull JsonObject object) {
            object.addProperty(GameModeFavoriteEntry.KEY, entry.gameMode.name());
            return object;
        }
    }
}

