/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.gui;

import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.rei.RoughlyEnoughItemsState;
import net.minecraft.class_1109;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_3528;
import net.minecraft.class_3545;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import org.jetbrains.annotations.ApiStatus;

import java.net.URI;
import java.net.URISyntaxException;

@ApiStatus.Internal
public class WarningAndErrorScreen extends class_437 {
    public static final class_3528<WarningAndErrorScreen> INSTANCE = new class_3528<>(WarningAndErrorScreen::new);
    private class_339 buttonExit;
    private StringEntryListWidget listWidget;
    private class_437 parent;
    
    private WarningAndErrorScreen() {
        super(class_333.field_18967);
    }
    
    @Override
    public boolean method_25422() {
        return false;
    }
    
    public void setParent(class_437 parent) {
        this.parent = parent;
    }
    
    private void addText(class_2561 string) {
        for (class_5481 s : field_22793.method_1728(string, field_22789 - 80)) {
            listWidget.creditsAddEntry(new TextItem(s));
        }
    }
    
    private void addLink(class_2561 string, String link) {
        for (class_5481 s : field_22793.method_1728(string, field_22789 - 80)) {
            listWidget.creditsAddEntry(new LinkItem(s, link));
        }
    }
    
    @Override
    public void method_25426() {
        field_22786.add(listWidget = new StringEntryListWidget(field_22787, field_22789, field_22790, 32, field_22790 - 32));
        listWidget.max = 80;
        listWidget.creditsClearEntries();
        listWidget.creditsAddEntry(new EmptyItem());
        if (!RoughlyEnoughItemsState.getWarnings().isEmpty())
            listWidget.creditsAddEntry(new TextItem(new class_2585("Warnings:").method_27692(class_124.field_1061).method_30937()));
        for (class_3545<String, String> pair : RoughlyEnoughItemsState.getWarnings()) {
            addText(new class_2585(pair.method_15442()));
            if (pair.method_15441() != null)
                addLink(new class_2585(pair.method_15441()), pair.method_15441());
            for (int i = 0; i < 2; i++) {
                listWidget.creditsAddEntry(new EmptyItem());
            }
        }
        if (!RoughlyEnoughItemsState.getWarnings().isEmpty() && !RoughlyEnoughItemsState.getErrors().isEmpty()) {
            listWidget.creditsAddEntry(new EmptyItem());
        }
        if (!RoughlyEnoughItemsState.getErrors().isEmpty())
            listWidget.creditsAddEntry(new TextItem(new class_2585("Errors:").method_27692(class_124.field_1061).method_30937()));
        for (class_3545<String, String> pair : RoughlyEnoughItemsState.getErrors()) {
            addText(new class_2585(pair.method_15442()));
            if (pair.method_15441() != null)
                addLink(new class_2585(pair.method_15441()), pair.method_15441());
            for (int i = 0; i < 2; i++) {
                listWidget.creditsAddEntry(new EmptyItem());
            }
        }
        for (StringItem child : listWidget.method_25396()) {
            listWidget.max = Math.max(listWidget.max, child.getWidth());
        }
        field_22786.add(buttonExit = new class_4185(field_22789 / 2 - 100, field_22790 - 26, 200, 20,
                new class_2585(RoughlyEnoughItemsState.getErrors().isEmpty() ? "Continue" : "Exit"),
                button -> {
                    if (RoughlyEnoughItemsState.getErrors().isEmpty()) {
                        RoughlyEnoughItemsState.clear();
                        RoughlyEnoughItemsState.continues();
                        class_310.method_1551().method_1507(parent);
                        setParent(null);
                    } else {
                        class_310.method_1551().method_1592();
                    }
                }));
    }
    
    @Override
    public boolean method_25401(double double_1, double double_2, double double_3) {
        return listWidget.method_25401(double_1, double_2, double_3) || super.method_25401(double_1, double_2, double_3);
    }
    
    @Override
    public void method_25394(class_4587 matrices, int int_1, int int_2, float float_1) {
        this.method_25434(0);
        this.listWidget.method_25394(matrices, int_1, int_2, float_1);
        if (RoughlyEnoughItemsState.getErrors().isEmpty()) {
            this.method_25300(matrices, this.field_22793, "Warnings during Roughly Enough Items' initialization", this.field_22789 / 2, 16, 16777215);
        } else {
            this.method_25300(matrices, this.field_22793, "Errors during Roughly Enough Items' initialization", this.field_22789 / 2, 16, 16777215);
        }
        super.method_25394(matrices, int_1, int_2, float_1);
        this.buttonExit.method_25394(matrices, int_1, int_2, float_1);
    }
    
    private static class StringEntryListWidget extends DynamicNewSmoothScrollingEntryListWidget<StringItem> {
        private boolean inFocus;
        private int max = 80;
        
        public StringEntryListWidget(class_310 client, int width, int height, int startY, int endY) {
            super(client, width, height, startY, endY, class_332.field_22735);
        }
        
        @Override
        public boolean method_25407(boolean boolean_1) {
            if (!this.inFocus && this.getItemCount() == 0) {
                return false;
            } else {
                this.inFocus = !this.inFocus;
                if (this.inFocus && this.getFocused() == null && this.getItemCount() > 0) {
                    this.moveSelection(1);
                } else if (this.inFocus && this.getFocused() != null) {
                    this.moveSelection(0);
                }
                
                return this.inFocus;
            }
        }
        
        public void creditsClearEntries() {
            clearItems();
        }
        
        private StringItem rei_getEntry(int int_1) {
            return this.method_25396().get(int_1);
        }
        
        public void creditsAddEntry(StringItem entry) {
            addItem(entry);
        }
        
        @Override
        public int getItemWidth() {
            return max;
        }
        
        @Override
        protected int getScrollbarPosition() {
            return width - 40;
        }
    }
    
    private abstract static class StringItem extends DynamicNewSmoothScrollingEntryListWidget.Entry<StringItem> {
        public abstract int getWidth();
    }
    
    private static class EmptyItem extends StringItem {
        @Override
        public void render(class_4587 matrixStack, int i, int i1, int i2, int i3, int i4, int i5, int i6, boolean b, float v) {
            
        }
        
        @Override
        public int getItemHeight() {
            return 5;
        }
        
        @Override
        public int getWidth() {
            return 0;
        }
    }
    
    private static class TextItem extends StringItem {
        private class_5481 text;
        
        public TextItem(class_5481 text) {
            this.text = text;
        }
        
        @Override
        public void render(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            class_310.method_1551().field_1772.method_27517(matrices, text, x + 5, y, -1);
        }
        
        @Override
        public int getItemHeight() {
            return 12;
        }
        
        @Override
        public boolean method_25407(boolean boolean_1) {
            return false;
        }
        
        @Override
        public int getWidth() {
            return class_310.method_1551().field_1772.method_30880(text) + 10;
        }
    }
    
    private class LinkItem extends StringItem {
        private class_5481 text;
        private String link;
        private boolean contains;
        
        public LinkItem(class_5481 text, String link) {
            this.text = text;
            this.link = link;
        }
        
        @Override
        public void render(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            contains = mouseX >= x && mouseX <= x + entryWidth && mouseY >= y && mouseY <= y + entryHeight;
            if (contains) {
                WarningAndErrorScreen.this.method_25424(matrices, new class_2585("Click to open link."), mouseX, mouseY);
                class_310.method_1551().field_1772.method_27517(matrices, characterVisitor -> {
                    return text.accept((charIndex, style, codePoint) -> characterVisitor.accept(charIndex, style.method_27706(class_124.field_1073), codePoint));
                }, x + 5, y, 0xff1fc3ff);
            } else {
                class_310.method_1551().field_1772.method_27517(matrices, text, x + 5, y, 0xff1fc3ff);
            }
        }
        
        @Override
        public int getItemHeight() {
            return 12;
        }
        
        @Override
        public boolean method_25407(boolean boolean_1) {
            return false;
        }
        
        @Override
        public int getWidth() {
            return class_310.method_1551().field_1772.method_30880(text) + 10;
        }
        
        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (contains && button == 0) {
                class_310.method_1551().method_1483().method_4873(class_1109.method_4758(class_3417.field_15015, 1.0F));
                try {
                    class_156.method_668().method_673(new URI(link));
                    return true;
                } catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }
}
