/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.gui.config.entry;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.ScrollingContainer;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.gui.OverlaySearchField;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.SearchArgument;
import net.minecraft.class_1159;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;
import java.util.Set;

import static me.shedaniel.rei.gui.widget.EntryListWidget.entrySize;

@ApiStatus.Internal
public class FilteringScreen extends class_437 {
    protected List<EntryStack> selected = Lists.newArrayList();
    protected final ScrollingContainer scrolling = new ScrollingContainer() {
        @Override
        public int getMaxScrollHeight() {
            return class_3532.method_15386(entryStacks.size() / (innerBounds.width / (float) entrySize())) * entrySize() + 28;
        }
        
        @Override
        public Rectangle getBounds() {
            return FilteringScreen.this.getBounds();
        }
        
        @Override
        public int getScrollBarX() {
            return field_22789 - 7;
        }
    };
    
    class_437 parent;
    private FilteringEntry filteringEntry;
    private Tooltip tooltip = null;
    private List<EntryStack> entryStacks = null;
    private Rectangle innerBounds;
    private List<EntryListEntry> entries = Collections.emptyList();
    private List<class_364> elements = Collections.emptyList();
    
    private Point selectionPoint = null;
    private Point secondPoint = null;
    
    private OverlaySearchField searchField;
    private class_4185 selectAllButton;
    private class_4185 selectNoneButton;
    private class_4185 hideButton;
    private class_4185 showButton;
    private class_4185 backButton;
    private Rectangle selectionCache;
    
    private List<SearchArgument.SearchArguments> lastSearchArguments = Collections.emptyList();
    
    public FilteringScreen(FilteringEntry filteringEntry) {
        super(new class_2588("config.roughlyenoughitems.filteringScreen"));
        this.filteringEntry = filteringEntry;
        this.searchField = new OverlaySearchField(0, 0, 0, 0);
        {
            class_2561 selectAllText = new class_2588("config.roughlyenoughitems.filteredEntries.selectAll");
            this.selectAllButton = new class_4185(0, 0, class_310.method_1551().field_1772.method_27525(selectAllText) + 10, 20, selectAllText, button -> {
                this.selectionPoint = new Point(-Integer.MAX_VALUE / 2, -Integer.MAX_VALUE / 2);
                this.secondPoint = new Point(Integer.MAX_VALUE / 2, Integer.MAX_VALUE / 2);
            });
        }
        {
            class_2561 selectNoneText = new class_2588("config.roughlyenoughitems.filteredEntries.selectNone");
            this.selectNoneButton = new class_4185(0, 0, class_310.method_1551().field_1772.method_27525(selectNoneText) + 10, 20, selectNoneText, button -> {
                this.selectionPoint = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
                this.secondPoint = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
            });
        }
        {
            class_2561 hideText = new class_2588("config.roughlyenoughitems.filteredEntries.hide");
            this.hideButton = new class_4185(0, 0, class_310.method_1551().field_1772.method_27525(hideText) + 10, 20, hideText, button -> {
                for (int i = 0; i < entryStacks.size(); i++) {
                    EntryStack stack = entryStacks.get(i);
                    EntryListEntry entry = entries.get(i);
                    entry.getBounds().y = (int) (entry.backupY - scrolling.scrollAmount);
                    if (entry.isSelected() && !entry.isFiltered()) {
                        filteringEntry.configFiltered.add(stack);
                        filteringEntry.edited = true;
                        entry.dirty = true;
                    }
                }
            });
        }
        {
            class_2561 showText = new class_2588("config.roughlyenoughitems.filteredEntries.show");
            this.showButton = new class_4185(0, 0, class_310.method_1551().field_1772.method_27525(showText) + 10, 20, showText, button -> {
                for (int i = 0; i < entryStacks.size(); i++) {
                    EntryStack stack = entryStacks.get(i);
                    EntryListEntry entry = entries.get(i);
                    entry.getBounds().y = (int) (entry.backupY - scrolling.scrollAmount);
                    if (entry.isSelected() && filteringEntry.configFiltered.remove(stack)) {
                        filteringEntry.edited = true;
                        entry.dirty = true;
                    }
                }
            });
        }
        {
            class_2561 backText = new class_2585("↩ ").method_10852(new class_2588("gui.back"));
            this.backButton = new class_4185(0, 0, class_310.method_1551().field_1772.method_27525(backText) + 10, 20, backText, button -> {
                field_22787.method_1507(parent);
                this.parent = null;
            });
        }
        this.searchField.isMain = false;
    }
    
    private static Rectangle updateInnerBounds(Rectangle bounds) {
        int width = Math.max(class_3532.method_15375((bounds.width - 2 - 6) / (float) entrySize()), 1);
        return new Rectangle((int) (bounds.getCenterX() - width * entrySize() / 2f), bounds.y + 5, width * entrySize(), bounds.height);
    }
    
    public Rectangle getBounds() {
        return new Rectangle(0, 30, field_22789, this.field_22790 - 30);
    }
    
    @Override
    protected void method_25426() {
        super.method_25426();
        Rectangle bounds = getBounds();
        updateSearch(this.searchField.getText());
        this.searchField.getBounds().setBounds(bounds.getCenterX() - 75, bounds.getMaxY() - 22, 150, 18);
        this.selectAllButton.field_22760 = 2;
        this.selectAllButton.field_22761 = bounds.getMaxY() - 22;
        this.selectNoneButton.field_22760 = 4 + selectAllButton.method_25368();
        this.selectNoneButton.field_22761 = bounds.getMaxY() - 22;
        this.hideButton.field_22760 = bounds.getMaxX() - hideButton.method_25368() - showButton.method_25368() - 4;
        this.hideButton.field_22761 = bounds.getMaxY() - 22;
        this.showButton.field_22760 = bounds.getMaxX() - showButton.method_25368() - 2;
        this.showButton.field_22761 = bounds.getMaxY() - 22;
        this.backButton.field_22760 = 4;
        this.backButton.field_22761 = 4;
        this.searchField.setChangedListener(this::updateSearch);
    }
    
    protected void renderHoleBackground(class_4587 matrices, int y1, int y2, int tint, int alpha1, int alpha2) {
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        this.field_22787.method_1531().method_22813(field_22735);
        class_1159 matrix = matrices.method_23760().method_23761();
        RenderSystem.color4f(1.0F, 1.0F, 1.0F, 1.0F);
        float float_1 = 32.0F;
        buffer.method_1328(7, class_290.field_1575);
        buffer.method_22918(matrix, 0, y2, 0.0F).method_22913(0.0F, y2 / 32.0F).method_1336(tint, tint, tint, alpha2).method_1344();
        buffer.method_22918(matrix, this.field_22789, y2, 0.0F).method_22913(this.field_22789 / 32.0F, y2 / 32.0F).method_1336(tint, tint, tint, alpha2).method_1344();
        buffer.method_22918(matrix, this.field_22789, y1, 0.0F).method_22913(this.field_22789 / 32.0F, y1 / 32.0F).method_1336(tint, tint, tint, alpha1).method_1344();
        buffer.method_22918(matrix, 0, y1, 0.0F).method_22913(0.0F, y1 / 32.0F).method_1336(tint, tint, tint, alpha1).method_1344();
        tessellator.method_1350();
    }
    
    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        renderHoleBackground(matrices, 0, field_22790, 32, 255, 255);
        updateSelectionCache();
        Rectangle bounds = getBounds();
        tooltip = null;
        if (bounds.isEmpty())
            return;
        ScissorsHandler.INSTANCE.scissor(bounds);
        for (EntryListEntry entry : entries)
            entry.clearStacks();
        int skip = Math.max(0, class_3532.method_15357(scrolling.scrollAmount / (float) entrySize()));
        int nextIndex = skip * innerBounds.width / entrySize();
        int i = nextIndex;
        for (; i < entryStacks.size(); i++) {
            EntryStack stack = entryStacks.get(i);
            EntryListEntry entry = entries.get(nextIndex);
            entry.getBounds().y = (int) (entry.backupY - scrolling.scrollAmount);
            if (entry.getBounds().y > bounds.getMaxY())
                break;
            entry.entry(stack);
            entry.method_25394(matrices, mouseX, mouseY, delta);
            nextIndex++;
        }
        updatePosition(delta);
        scrolling.renderScrollBar(0xff000000, 1, REIHelper.getInstance().isDarkThemeEnabled() ? 0.8f : 1f);
        matrices.method_22903();
        matrices.method_22904(0, 0, 300);
        this.searchField.laterRender(matrices, mouseX, mouseY, delta);
        this.selectAllButton.method_25394(matrices, mouseX, mouseY, delta);
        this.selectNoneButton.method_25394(matrices, mouseX, mouseY, delta);
        this.hideButton.method_25394(matrices, mouseX, mouseY, delta);
        this.showButton.method_25394(matrices, mouseX, mouseY, delta);
        matrices.method_22909();
        
        ScissorsHandler.INSTANCE.removeLastScissor();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate(770, 771, 0, 1);
        RenderSystem.disableAlphaTest();
        RenderSystem.shadeModel(7425);
        RenderSystem.disableTexture();
        class_1159 matrix = matrices.method_23760().method_23761();
        buffer.method_1328(7, class_290.field_1575);
        buffer.method_22918(matrix, 0, bounds.y + 4, 0.0F).method_22913(0.0F, 1.0F).method_1336(0, 0, 0, 0).method_1344();
        buffer.method_22918(matrix, field_22789, bounds.y + 4, 0.0F).method_22913(1.0F, 1.0F).method_1336(0, 0, 0, 0).method_1344();
        buffer.method_22918(matrix, field_22789, bounds.y, 0.0F).method_22913(1.0F, 0.0F).method_1336(0, 0, 0, 255).method_1344();
        buffer.method_22918(matrix, 0, bounds.y, 0.0F).method_22913(0.0F, 0.0F).method_1336(0, 0, 0, 255).method_1344();
        tessellator.method_1350();
        RenderSystem.enableTexture();
        RenderSystem.shadeModel(7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        renderHoleBackground(matrices, 0, bounds.y, 64, 255, 255);
        
        this.backButton.method_25394(matrices, mouseX, mouseY, delta);
        
        if (tooltip != null) {
            ScreenHelper.getLastOverlay().renderTooltip(matrices, tooltip);
        }
        
        this.field_22793.method_27517(matrices, this.field_22785.method_30937(), this.field_22789 / 2.0F - this.field_22793.method_27525(this.field_22785) / 2.0F, 12.0F, -1);
    }
    
    private Rectangle getSelection() {
        return selectionCache;
    }
    
    private void updateSelectionCache() {
        if (selectionPoint != null) {
            Point p = secondPoint;
            if (p == null) {
                p = PointHelper.ofMouse();
                p.translate(0, (int) scrolling.scrollAmount);
            }
            int left = Math.min(p.x, selectionPoint.x);
            int top = Math.min(p.y, selectionPoint.y);
            int right = Math.max(p.x, selectionPoint.x);
            int bottom = Math.max(p.y, selectionPoint.y);
            selectionCache = new Rectangle(left, (int) (top - scrolling.scrollAmount), right - left, bottom - top);
            return;
        }
        selectionCache = new Rectangle(0, 0, 0, 0);
    }
    
    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        if (scrolling.mouseDragged(mouseX, mouseY, button, dx, dy, ConfigObject.getInstance().doesSnapToRows(), entrySize()))
            return true;
        return super.method_25403(mouseX, mouseY, button, dx, dy);
    }
    
    private void updatePosition(float delta) {
        if (ConfigObject.getInstance().doesSnapToRows() && scrolling.scrollTarget >= 0 && scrolling.scrollTarget <= scrolling.getMaxScroll()) {
            double nearestRow = Math.round(scrolling.scrollTarget / (double) entrySize()) * (double) entrySize();
            if (!DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals(scrolling.scrollTarget, nearestRow, DynamicNewSmoothScrollingEntryListWidget.Precision.FLOAT_EPSILON))
                scrolling.scrollTarget += (nearestRow - scrolling.scrollTarget) * Math.min(delta / 2.0, 1.0);
            else
                scrolling.scrollTarget = nearestRow;
        }
        scrolling.updatePosition(delta);
    }
    
    public void updateSearch(String searchTerm) {
        lastSearchArguments = SearchArgument.processSearchTerm(searchTerm);
        Set<EntryStack> list = Sets.newLinkedHashSet();
        for (EntryStack stack : EntryRegistry.getInstance().getStacksList()) {
            if (canLastSearchTermsBeAppliedTo(stack)) {
                list.add(stack.copy().setting(EntryStack.Settings.CHECK_AMOUNT, EntryStack.Settings.FALSE).setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.CHECK_TAGS, EntryStack.Settings.TRUE));
            }
        }
        
        entryStacks = Lists.newArrayList(list);
        updateEntriesPosition();
    }
    
    public boolean canLastSearchTermsBeAppliedTo(EntryStack stack) {
        return lastSearchArguments.isEmpty() || SearchArgument.canSearchTermsBeAppliedTo(stack, lastSearchArguments);
    }
    
    public void updateEntriesPosition() {
        this.innerBounds = updateInnerBounds(getBounds());
        int width = innerBounds.width / entrySize();
        int pageHeight = innerBounds.height / entrySize();
        int slotsToPrepare = Math.max(entryStacks.size() * 3, width * pageHeight * 3);
        int currentX = 0;
        int currentY = 0;
        List<EntryListEntry> entries = Lists.newArrayList();
        for (int i = 0; i < slotsToPrepare; i++) {
            int xPos = currentX * entrySize() + innerBounds.x;
            int yPos = currentY * entrySize() + innerBounds.y;
            entries.add(new EntryListEntry(xPos, yPos));
            currentX++;
            if (currentX >= width) {
                currentX = 0;
                currentY++;
            }
        }
        this.entries = entries;
        this.elements = Lists.newArrayList(entries);
        this.elements.add(searchField);
    }
    
    @Override
    public List<? extends class_364> method_25396() {
        return elements;
    }
    
    @Override
    public boolean method_25402(double double_1, double double_2, int int_1) {
        if (scrolling.updateDraggingState(double_1, double_2, int_1))
            return true;
        
        if (getBounds().contains(double_1, double_2)) {
            if (searchField.method_25402(double_1, double_2, int_1)) {
                this.selectionPoint = null;
                this.secondPoint = null;
                return true;
            } else if (selectAllButton.method_25402(double_1, double_2, int_1)) {
                return true;
            } else if (selectNoneButton.method_25402(double_1, double_2, int_1)) {
                return true;
            } else if (hideButton.method_25402(double_1, double_2, int_1)) {
                return true;
            } else if (showButton.method_25402(double_1, double_2, int_1)) {
                return true;
            }
            if (int_1 == 0) {
                this.selectionPoint = new Point(double_1, double_2 + scrolling.scrollAmount);
                this.secondPoint = null;
                return true;
            }
        }
        if (backButton.method_25402(double_1, double_2, int_1)) {
            return true;
        }
        return false;
    }
    
    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (selectionPoint != null && button == 0 && secondPoint == null) {
            this.secondPoint = new Point(mouseX, mouseY + scrolling.scrollAmount);
            if (secondPoint.equals(selectionPoint)) {
                secondPoint.translate(1, 1);
            }
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }
    
    @Override
    public boolean method_25400(char chr, int keyCode) {
        for (class_364 element : method_25396())
            if (element.method_25400(chr, keyCode))
                return true;
        return super.method_25400(chr, keyCode);
    }
    
    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        for (class_364 element : method_25396())
            if (element.method_25404(keyCode, scanCode, modifiers))
                return true;
        if (class_437.method_25439(keyCode)) {
            this.selectionPoint = new Point(0, 0);
            this.secondPoint = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
            return true;
        }
        if (keyCode == 256 && this.method_25422()) {
            this.backButton.method_25306();
            return true;
        } else if (keyCode == 258) {
            boolean bl = !method_25442();
            if (!this.method_25407(bl)) {
                this.method_25407(bl);
            }
            
            return true;
        }
        return false;
    }
    
    public void updateArea(@Nullable String searchTerm) {
        if (searchTerm != null)
            updateSearch(searchTerm);
        else if (entryStacks == null)
            updateSearch("");
        else
            updateEntriesPosition();
    }
    
    @Override
    public boolean method_25401(double double_1, double double_2, double double_3) {
        if (getBounds().contains(double_1, double_2)) {
            scrolling.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
            return true;
        }
        super.method_25401(double_1, double_2, double_3);
        return true;
    }
    
    private class EntryListEntry extends EntryWidget {
        private int backupY;
        private boolean filtered = false;
        private boolean dirty = true;
        
        private EntryListEntry(int x, int y) {
            super(new Point(x, y));
            this.backupY = y;
            getBounds().width = getBounds().height = entrySize();
            interactableFavorites(false);
            interactable(false);
            noHighlight();
        }
        
        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && FilteringScreen.this.getBounds().contains(mouseX, mouseY);
        }
        
        @Override
        protected void drawHighlighted(class_4587 matrices, int mouseX, int mouseY, float delta) {
            
        }
        
        @Override
        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            super.method_25394(matrices, mouseX, mouseY, delta);
            if (isSelected()) {
                Rectangle bounds = getBounds();
                RenderSystem.disableDepthTest();
                method_25296(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), 0x896b70fa, 0x896b70fa);
                RenderSystem.enableDepthTest();
            }
        }
        
        @Override
        public EntryStack getCurrentEntry() {
            return super.getCurrentEntry();
        }
        
        public boolean isSelected() {
            return getSelection().intersects(getBounds());
        }
        
        public boolean isFiltered() {
            if (dirty) {
                filtered = filteringEntry.configFiltered.contains(getCurrentEntry());
                dirty = false;
            }
            return filtered;
        }
        
        @Override
        protected void drawBackground(class_4587 matrices, int mouseX, int mouseY, float delta) {
            if (isFiltered()) {
                Rectangle bounds = getBounds();
                RenderSystem.disableDepthTest();
                method_25296(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), 0xffff0000, 0xffff0000);
                RenderSystem.enableDepthTest();
            }
        }
        
        @Override
        protected void queueTooltip(class_4587 matrices, int mouseX, int mouseY, float delta) {
            if (searchField.containsMouse(mouseX, mouseY))
                return;
            Tooltip tooltip = getCurrentTooltip(new Point(mouseX, mouseY));
            if (tooltip != null) {
                FilteringScreen.this.tooltip = tooltip;
            }
        }
    }
}
