/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.gui.credits;

import com.google.common.collect.Lists;
import me.shedaniel.rei.gui.credits.CreditsEntryListWidget.TextCreditsItem;
import me.shedaniel.rei.gui.credits.CreditsEntryListWidget.TranslationCreditsItem;
import me.shedaniel.rei.impl.ScreenHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.minecraft.class_1074;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_333;
import net.minecraft.class_3545;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import org.jetbrains.annotations.ApiStatus;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

@ApiStatus.Internal
public class CreditsScreen extends class_437 {
    
    private class_437 parent;
    private class_4264 buttonDone;
    private CreditsEntryListWidget entryListWidget;
    
    public CreditsScreen(class_437 parent) {
        super(new class_2585(""));
        this.parent = parent;
    }
    
    @Override
    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (int_1 == 256 && this.method_25422()) {
            this.field_22787.method_1507(parent);
            if (parent instanceof class_465)
                ScreenHelper.getLastOverlay().init();
            return true;
        }
        return super.method_25404(int_1, int_2, int_3);
    }
    
    @Override
    public void method_25426() {
        field_22786.add(entryListWidget = new CreditsEntryListWidget(field_22787, field_22789, field_22790, 32, field_22790 - 32));
        entryListWidget.creditsClearEntries();
        List<class_3545<String, String>> translators = Lists.newArrayList();
        Exception[] exception = {null};
        FabricLoader.getInstance().getModContainer("roughlyenoughitems-runtime").ifPresent(rei -> {
            try {
                if (rei.getMetadata().containsCustomValue("rei:translators")) {
                    CustomValue.CvObject jsonObject = rei.getMetadata().getCustomValue("rei:translators").getAsObject();
                    jsonObject.forEach(entry -> {
                        CustomValue value = entry.getValue();
                        String behind = value.getType() == CustomValue.CvType.ARRAY ? Lists.newArrayList(value.getAsArray().iterator()).stream().map(CustomValue::getAsString).sorted(String::compareToIgnoreCase).collect(Collectors.joining(", ")) : value.getAsString();
                        translators.add(new class_3545<>(entry.getKey(), behind));
                    });
                }
                translators.sort(Comparator.comparing(class_3545::method_15442, String::compareToIgnoreCase));
            } catch (Exception e) {
                exception[0] = e;
                e.printStackTrace();
            }
        });
        List<class_3545<String, String>> translatorsMapped = translators.stream().map(pair -> {
            return new class_3545<>(
                    "  " + (class_1074.method_4663("language.roughlyenoughitems." + pair.method_15442().toLowerCase(Locale.ROOT).replace(' ', '_')) ? class_1074.method_4662("language.roughlyenoughitems." + pair.method_15442().toLowerCase(Locale.ROOT).replace(' ', '_')) : pair.method_15442()),
                    pair.method_15441()
            );
        }).collect(Collectors.toList());
        int i = field_22789 - 80 - 6;
        for (String line : String.format("§lRoughly Enough Items (v%s)\n§7Originally a fork for Almost Enough Items.\n\n§lLanguage Translation\n%s\n\n§lLicense\n§7Roughly Enough Items is licensed under MIT.", FabricLoader.getInstance().getModContainer("roughlyenoughitems").map(mod -> mod.getMetadata().getVersion().getFriendlyString()).orElse("Unknown"), "%translators%").split("\n"))
            if (line.equalsIgnoreCase("%translators%")) {
                if (exception[0] != null) {
                    entryListWidget.creditsAddEntry(new TextCreditsItem(new class_2585("Failed to get translators: " + exception[0].toString())));
                    for (StackTraceElement traceElement : exception[0].getStackTrace())
                        entryListWidget.creditsAddEntry(new TextCreditsItem(new class_2585("  at " + traceElement)));
                } else {
                    int maxWidth = translatorsMapped.stream().mapToInt(pair -> field_22793.method_1727(pair.method_15442())).max().orElse(0) + 5;
                    for (class_3545<String, String> pair : translatorsMapped) {
                        entryListWidget.creditsAddEntry(new TranslationCreditsItem(new class_2588(pair.method_15442()), new class_2588(pair.method_15441()), i - maxWidth - 10, maxWidth));
                    }
                }
            } else entryListWidget.creditsAddEntry(new TextCreditsItem(new class_2585(line)));
        entryListWidget.creditsAddEntry(new TextCreditsItem(class_333.field_18967));
        field_22786.add(buttonDone = new class_4264(field_22789 / 2 - 100, field_22790 - 26, 200, 20, new class_2588("gui.done")) {
            @Override
            public void method_25306() {
                CreditsScreen.this.field_22787.method_1507(parent);
                if (parent instanceof class_465)
                    ScreenHelper.getLastOverlay().init();
            }
        });
    }
    
    @Override
    public boolean method_25401(double double_1, double double_2, double double_3) {
        if (entryListWidget.method_25401(double_1, double_2, double_3))
            return true;
        return super.method_25401(double_1, double_2, double_3);
    }
    
    @Override
    public void method_25394(class_4587 matrices, int int_1, int int_2, float float_1) {
        this.method_25434(0);
        this.entryListWidget.method_25394(matrices, int_1, int_2, float_1);
        this.method_25300(matrices, this.field_22793, class_1074.method_4662("text.rei.credits"), this.field_22789 / 2, 16, 16777215);
        super.method_25394(matrices, int_1, int_2, float_1);
        buttonDone.method_25394(matrices, int_1, int_2, float_1);
    }
    
}
