/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.filtering;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.impl.AmountIgnoredEntryStackWrapper;
import me.shedaniel.rei.impl.filtering.FilteringContext;
import me.shedaniel.rei.impl.filtering.FilteringContextType;
import me.shedaniel.rei.impl.filtering.FilteringResult;
import me.shedaniel.rei.utils.CollectionUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class FilteringContextImpl
implements FilteringContext {
    private final Map<FilteringContextType, Set<AmountIgnoredEntryStackWrapper>> stacks;
    private final Map<FilteringContextType, Collection<EntryStack>> cachedStacks;

    public FilteringContextImpl(List<EntryStack> allStacks) {
        this.stacks = Maps.newHashMap();
        this.cachedStacks = Maps.newHashMap();
        for (FilteringContextType type : FilteringContextType.values()) {
            this.stacks.computeIfAbsent(type, t -> Sets.newHashSet());
        }
        this.stacks.get((Object)FilteringContextType.DEFAULT).addAll(CollectionUtils.mapParallel(allStacks, AmountIgnoredEntryStackWrapper::new));
        this.fillCache();
    }

    public FilteringContextImpl(Map<FilteringContextType, Set<AmountIgnoredEntryStackWrapper>> stacks) {
        this.stacks = stacks;
        this.cachedStacks = Maps.newHashMap();
        for (FilteringContextType type : FilteringContextType.values()) {
            this.stacks.computeIfAbsent(type, t -> Sets.newHashSet());
        }
        this.fillCache();
    }

    private void fillCache() {
        this.cachedStacks.clear();
        for (FilteringContextType type : FilteringContextType.values()) {
            this.cachedStacks.put(type, CollectionUtils.map((Collection)this.stacks.get((Object)type), AmountIgnoredEntryStackWrapper::unwrap));
        }
    }

    @Override
    public Collection<EntryStack> getStacks(FilteringContextType type) {
        return this.cachedStacks.get((Object)type);
    }

    public void handleResult(FilteringResult result) {
        Set<AmountIgnoredEntryStackWrapper> hiddenStacks = result.getHiddenStacks();
        Set<AmountIgnoredEntryStackWrapper> shownStacks = result.getShownStacks();
        ArrayList completableFutures = Lists.newArrayList();
        completableFutures.add(CompletableFuture.runAsync(() -> {
            this.stacks.get((Object)FilteringContextType.DEFAULT).removeAll(hiddenStacks);
            this.stacks.get((Object)FilteringContextType.DEFAULT).removeAll(shownStacks);
        }));
        completableFutures.add(CompletableFuture.runAsync(() -> {
            this.stacks.get((Object)FilteringContextType.SHOWN).removeAll(hiddenStacks);
            this.stacks.get((Object)FilteringContextType.SHOWN).addAll(shownStacks);
        }));
        completableFutures.add(CompletableFuture.runAsync(() -> {
            this.stacks.get((Object)FilteringContextType.HIDDEN).addAll(hiddenStacks);
            this.stacks.get((Object)FilteringContextType.HIDDEN).removeAll(shownStacks);
        }));
        try {
            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
        this.fillCache();
    }
}

