/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.widgets;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.api.LazyResettable;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.widgets.Label;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.api.widgets.Widgets;
import net.minecraft.class_2477;
import net.minecraft.class_2585;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LabelWidget
extends Label {
    private boolean focused = false;
    private boolean clickable = false;
    private int horizontalAlignment = 0;
    private boolean hasShadow = true;
    private boolean focusable = true;
    private int color = REIHelper.getInstance().isDarkThemeEnabled() ? -4473925 : -1;
    private int hoveredColor = REIHelper.getInstance().isDarkThemeEnabled() ? -1 : -10027060;
    private @NotNull Point point;
    private @Nullable Function<Label, @Nullable String> tooltip;
    private @Nullable Consumer<Label> onClick;
    private @Nullable BiConsumer<class_4587, Label> onRender;
    private @NotNull class_5348 text;
    private final @NotNull LazyResettable<class_5481> class_5481 = new LazyResettable(() -> class_2477.method_10517().method_30934(this.getMessage()));

    public LabelWidget(@NotNull Point point, @NotNull class_5348 text) {
        this.point = point;
        Objects.requireNonNull(this.point);
        this.text = text;
        Objects.requireNonNull(this.text);
    }

    public final boolean isClickable() {
        return this.clickable;
    }

    public final void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    public final @Nullable Consumer<Label> getOnClick() {
        return this.onClick;
    }

    public final void setOnClick(@Nullable Consumer<Label> onClick) {
        this.onClick = onClick;
    }

    public final @Nullable BiConsumer<class_4587, Label> getOnRender() {
        return this.onRender;
    }

    public final void setOnRender(@Nullable BiConsumer<class_4587, Label> onRender) {
        this.onRender = onRender;
    }

    public final boolean isFocusable() {
        return this.focusable;
    }

    public final void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    public final @Nullable String getTooltip() {
        if (this.tooltip == null) {
            return null;
        }
        return this.tooltip.apply(this);
    }

    public final void setTooltip(@Nullable @Nullable Function<Label, @Nullable String> tooltip) {
        this.tooltip = tooltip;
    }

    public final int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public final void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public final boolean hasShadow() {
        return this.hasShadow;
    }

    public final void setShadow(boolean hasShadow) {
        this.hasShadow = hasShadow;
    }

    public final int getColor() {
        return this.color;
    }

    public final void setColor(int color) {
        this.color = color;
    }

    public final int getHoveredColor() {
        return this.hoveredColor;
    }

    public final void setHoveredColor(int hoveredColor) {
        this.hoveredColor = hoveredColor;
    }

    public final @NotNull Point getPoint() {
        return this.point;
    }

    public final void setPoint(@NotNull Point point) {
        this.point = Objects.requireNonNull(point);
    }

    public class_5348 getMessage() {
        return this.text;
    }

    public void setMessage(@NotNull class_5348 message) {
        this.text = Objects.requireNonNull(message);
        this.class_5481.reset();
    }

    public final @NotNull Rectangle getBounds() {
        int width = this.font.method_27525(this.text);
        Point point = this.getPoint();
        if (this.getHorizontalAlignment() == -1) {
            return new Rectangle(point.x - 1, point.y - 5, width + 2, 14);
        }
        if (this.getHorizontalAlignment() == 1) {
            return new Rectangle(point.x - width - 1, point.y - 5, width + 2, 14);
        }
        return new Rectangle(point.x - width / 2 - 1, point.y - 5, width + 2, 14);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        String tooltip;
        if (this.getOnRender() != null) {
            this.getOnRender().accept(matrices, this);
        }
        int color = this.getColor();
        if (this.isClickable() && this.isHovered(mouseX, mouseY)) {
            color = this.getHoveredColor();
        }
        Point pos = this.getPoint();
        int width = this.font.method_30880((class_5481)this.class_5481.get());
        switch (this.getHorizontalAlignment()) {
            case -1: {
                if (this.hasShadow()) {
                    this.font.method_27517(matrices, (class_5481)this.class_5481.get(), (float)pos.x, (float)pos.y, color);
                    break;
                }
                this.font.method_27528(matrices, (class_5481)this.class_5481.get(), (float)pos.x, (float)pos.y, color);
                break;
            }
            case 1: {
                if (this.hasShadow()) {
                    this.font.method_27517(matrices, (class_5481)this.class_5481.get(), (float)(pos.x - width), (float)pos.y, color);
                    break;
                }
                this.font.method_27528(matrices, (class_5481)this.class_5481.get(), (float)(pos.x - width), (float)pos.y, color);
                break;
            }
            default: {
                if (this.hasShadow()) {
                    this.font.method_27517(matrices, (class_5481)this.class_5481.get(), (float)pos.x - (float)width / 2.0f, (float)pos.y, color);
                    break;
                }
                this.font.method_27528(matrices, (class_5481)this.class_5481.get(), (float)pos.x - (float)width / 2.0f, (float)pos.y, color);
            }
        }
        if (this.isHovered(mouseX, mouseY) && (tooltip = this.getTooltip()) != null) {
            if (!this.focused && this.containsMouse(mouseX, mouseY)) {
                Tooltip.create((Collection)Stream.of(tooltip.split("\n")).map(class_2585::new).collect(Collectors.toList())).queue();
            } else if (this.focused) {
                Tooltip.create((Point)this.point, (Collection)Stream.of(tooltip.split("\n")).map(class_2585::new).collect(Collectors.toList())).queue();
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isClickable() && this.containsMouse(mouseX, mouseY)) {
            Widgets.produceClickSound();
            if (this.onClick != null) {
                this.onClick.accept(this);
            }
            return true;
        }
        return false;
    }

    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (!(this.isClickable() && this.isFocusable() && this.focused)) {
            return false;
        }
        if (int_1 != 257 && int_1 != 32 && int_1 != 335) {
            return false;
        }
        Widgets.produceClickSound();
        if (this.onClick != null) {
            this.onClick.accept(this);
        }
        return true;
    }

    public boolean method_25407(boolean boolean_1) {
        if (!this.isClickable() || !this.isFocusable()) {
            return false;
        }
        this.focused = !this.focused;
        return true;
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return this.containsMouse(mouseX, mouseY) || this.focused;
    }

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }
}

