/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.modules.entries;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.modules.Menu;
import me.shedaniel.rei.gui.modules.MenuEntry;
import me.shedaniel.rei.gui.modules.entries.EntryStackSubsetsMenuEntry;
import me.shedaniel.rei.gui.widget.TabWidget;
import me.shedaniel.rei.impl.EntryRegistryImpl;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4587;

public class SubSubsetsMenuEntry
extends MenuEntry {
    public final String text;
    private int textWidth = -69;
    private int x;
    private int y;
    private int width;
    private boolean selected;
    private boolean containsMouse;
    private boolean rendering;
    private List<MenuEntry> entries;
    private Menu subsetsMenu;
    private class_3545<Integer, Integer> filteredRatio = null;
    private long lastListHash = -1L;
    private boolean clickedBefore = false;

    public SubSubsetsMenuEntry(String text) {
        this(text, Collections.emptyList());
    }

    public SubSubsetsMenuEntry(String text, Supplier<List<MenuEntry>> entries) {
        this(text, entries.get());
    }

    public SubSubsetsMenuEntry(String text, List<MenuEntry> entries) {
        this.text = text;
        this.entries = entries;
    }

    private int getTextWidth() {
        if (this.textWidth == -69) {
            this.textWidth = Math.max(0, this.font.method_1727(this.text));
        }
        return this.textWidth;
    }

    public Menu getSubsetsMenu() {
        if (this.subsetsMenu == null) {
            this.subsetsMenu = new Menu(new Point(this.getParent().getBounds().getMaxX() - 1, this.y - 1), this.entries);
        }
        return this.subsetsMenu;
    }

    @Override
    public int getEntryWidth() {
        return 12 + this.getTextWidth() + 4;
    }

    @Override
    public int getEntryHeight() {
        return 12;
    }

    @Override
    public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
        this.x = xPos;
        this.y = yPos;
        this.selected = selected;
        this.containsMouse = containsMouse;
        this.rendering = rendering;
        this.width = width;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        double filteredRatio = this.getFilteredRatio();
        if (filteredRatio > 0.0) {
            filteredRatio = filteredRatio * 0.85 + 0.15;
            SubSubsetsMenuEntry.method_25294((class_4587)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + 12), (int)((0xFF0000 | class_3532.method_15384((double)(filteredRatio * 255.0)) << 24) + (this.selected ? 39321 : 0)));
        } else if (this.selected) {
            SubSubsetsMenuEntry.method_25294((class_4587)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + 12), (int)-12237499);
        }
        if (this.selected) {
            if (!this.entries.isEmpty()) {
                Menu menu = this.getSubsetsMenu();
                menu.menuStartPoint.x = this.getParent().getBounds().getMaxX() - 1;
                menu.menuStartPoint.y = this.y - 1;
                ArrayList areas = Lists.newArrayList((Iterable)ScissorsHandler.INSTANCE.getScissorsAreas());
                ScissorsHandler.INSTANCE.clearScissors();
                menu.method_25394(matrices, mouseX, mouseY, delta);
                for (Rectangle area : areas) {
                    ScissorsHandler.INSTANCE.scissor(area);
                }
            } else {
                this.clickedBefore = false;
            }
            if (this.clickedBefore) {
                if (this.rendering && mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + 12 && !this.entries.isEmpty()) {
                    REIHelper.getInstance().queueTooltip(Tooltip.create((class_2561[])new class_2561[]{new class_2585("Click again to filter everything in this group.")}));
                } else {
                    this.clickedBefore = false;
                }
            }
        } else {
            this.clickedBefore = false;
        }
        this.font.method_1729(matrices, this.text, (float)(this.x + 2), (float)(this.y + 2), this.selected ? 0xFFFFFF : 0x888888);
        if (!this.entries.isEmpty()) {
            class_310.method_1551().method_1531().method_22813(TabWidget.CHEST_GUI_TEXTURE);
            this.method_25302(matrices, this.x + this.width - 15, this.y - 2, 0, 28, 18, 18);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.rendering && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 12) && !this.entries.isEmpty()) {
            if (this.clickedBefore) {
                this.clickedBefore = false;
                List filteredStacks = ConfigObject.getInstance().getFilteredStacks();
                Menu subsetsMenu = ScreenHelper.getLastOverlay().getSubsetsMenu();
                this.setFiltered(filteredStacks, subsetsMenu, this, !(this.getFilteredRatio() > 0.0));
                ConfigManager.getInstance().saveConfig();
                ((EntryRegistryImpl)EntryRegistry.getInstance()).refilter();
                if (ScreenHelper.getSearchField() != null) {
                    ContainerScreenOverlay.getEntryListWidget().updateSearch(ScreenHelper.getSearchField().getText(), true);
                }
            } else {
                this.clickedBefore = true;
            }
            this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void setFiltered(List<EntryStack> filteredStacks, Menu subsetsMenu, SubSubsetsMenuEntry subSubsetsMenuEntry, boolean filtered) {
        for (MenuEntry entry : subSubsetsMenuEntry.entries) {
            if (entry instanceof EntryStackSubsetsMenuEntry) {
                if (((EntryStackSubsetsMenuEntry)entry).isFiltered() != filtered) {
                    if (!filtered) {
                        filteredStacks.removeIf(next -> next.equalsIgnoreAmount(((EntryStackSubsetsMenuEntry)entry).stack));
                    } else {
                        filteredStacks.add(((EntryStackSubsetsMenuEntry)entry).stack.copy());
                    }
                }
                if (subsetsMenu == null) continue;
                ((EntryStackSubsetsMenuEntry)entry).recalculateFilter(subsetsMenu);
                continue;
            }
            if (!(entry instanceof SubSubsetsMenuEntry)) continue;
            this.setFiltered(filteredStacks, subsetsMenu, (SubSubsetsMenuEntry)entry, filtered);
        }
    }

    public double getFilteredRatio() {
        class_3545<Integer, Integer> pair = this.getFilteredRatioPair();
        return (Integer)pair.method_15441() == 0 ? 0.0 : (double)((Integer)pair.method_15442()).intValue() / (double)((Integer)pair.method_15441()).intValue();
    }

    public class_3545<Integer, Integer> getFilteredRatioPair() {
        List filteredStacks = ConfigObject.getInstance().getFilteredStacks();
        if (this.lastListHash != (long)filteredStacks.hashCode()) {
            int size = 0;
            int filtered = 0;
            for (MenuEntry entry : this.entries) {
                if (entry instanceof EntryStackSubsetsMenuEntry) {
                    ++size;
                    if (!((EntryStackSubsetsMenuEntry)entry).isFiltered()) continue;
                    ++filtered;
                    continue;
                }
                if (!(entry instanceof SubSubsetsMenuEntry)) continue;
                class_3545<Integer, Integer> pair = ((SubSubsetsMenuEntry)entry).getFilteredRatioPair();
                filtered += ((Integer)pair.method_15442()).intValue();
                size += ((Integer)pair.method_15441()).intValue();
            }
            this.filteredRatio = new class_3545((Object)filtered, (Object)size);
            this.lastListHash = filteredStacks.hashCode();
        }
        return this.filteredRatio;
    }

    public boolean containsMouse(double mouseX, double mouseY) {
        if (super.containsMouse(mouseX, mouseY)) {
            return true;
        }
        if (this.subsetsMenu != null && !this.subsetsMenu.method_25396().isEmpty() && this.selected) {
            return this.subsetsMenu.containsMouse(mouseX, mouseY);
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        return this.subsetsMenu != null && !this.subsetsMenu.method_25396().isEmpty() && this.selected && this.subsetsMenu.method_25401(mouseX, mouseY, amount);
    }

    public List<? extends class_364> method_25396() {
        if (this.subsetsMenu != null && !this.subsetsMenu.method_25396().isEmpty() && this.selected) {
            return Collections.singletonList(this.subsetsMenu);
        }
        return Collections.emptyList();
    }
}

