/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.ScrollingContainer;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.OverlayDecider;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.config.EntryPanelOrdering;
import me.shedaniel.rei.gui.widget.EntryListEntryWidget;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.FavoritesListWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.OptimalEntryStack;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.SearchArgument;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1159;
import net.minecraft.class_1269;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntryListWidget
extends WidgetWithBounds {
    static final Supplier<Boolean> RENDER_ENCHANTMENT_GLINT = () -> ((ConfigObject)ConfigObject.getInstance()).doesRenderEntryEnchantmentGlint();
    static final Comparator<? super EntryStack> ENTRY_NAME_COMPARER = Comparator.comparing(stack -> stack.asFormatStrippedText().getString());
    static final Comparator<? super EntryStack> ENTRY_GROUP_COMPARER = Comparator.comparingInt(stack -> {
        class_1761 group;
        if (stack.getType() == EntryStack.Type.ITEM && (group = stack.getItem().method_7859()) != null) {
            return group.method_7741();
        }
        return Integer.MAX_VALUE;
    });
    private static final int SIZE = 18;
    private static final boolean LAZY = true;
    private static int page;
    protected final ScrollingContainer scrolling = new ScrollingContainer(){

        public Rectangle getBounds() {
            return EntryListWidget.this.getBounds();
        }

        public int getMaxScrollHeight() {
            return class_3532.method_15386((float)((float)(EntryListWidget.this.allStacks.size() + EntryListWidget.this.blockedCount) / ((float)((EntryListWidget)EntryListWidget.this).innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize();
        }
    };
    protected int blockedCount;
    private boolean debugTime;
    private double lastAverageDebugTime;
    private double averageDebugTime;
    private double lastTotalDebugTime;
    private double totalDebugTime;
    private float totalDebugTimeDelta;
    private Rectangle bounds;
    private Rectangle innerBounds;
    private List<EntryStack> allStacks = null;
    private List<EntryListEntry> entries = Collections.emptyList();
    private List<Widget> renders = Collections.emptyList();
    private List<Widget> widgets = Collections.emptyList();
    private List<SearchArgument.SearchArguments> lastSearchArguments = Collections.emptyList();
    private String lastSearchTerm = null;

    public static int entrySize() {
        return class_3532.method_15384((double)(18.0 * ConfigObject.getInstance().getEntrySize()));
    }

    static boolean notSteppingOnExclusionZones(int left, int top, Rectangle listArea) {
        class_310 instance = class_310.method_1551();
        for (OverlayDecider decider : DisplayHelper.getInstance().getSortedOverlayDeciders(instance.field_1755.getClass())) {
            class_1269 fit = decider.isInZone((double)left, (double)top);
            if (fit == class_1269.field_5814) {
                return false;
            }
            class_1269 fit2 = decider.isInZone((double)(left + 18), (double)(top + 18));
            if (fit2 == class_1269.field_5814) {
                return false;
            }
            if (fit != class_1269.field_5812 || fit2 != class_1269.field_5812) continue;
            return true;
        }
        return true;
    }

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2 - 6) / (float)EntryListWidget.entrySize())), 1);
            if (ConfigObject.getInstance().isLeftHandSidePanel()) {
                return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)EntryListWidget.entrySize() / 2.0f) + 3.0f), bounds.y, width * EntryListWidget.entrySize(), bounds.height);
            }
            return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)EntryListWidget.entrySize() / 2.0f) - 3.0f), bounds.y, width * EntryListWidget.entrySize(), bounds.height);
        }
        int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2) / (float)EntryListWidget.entrySize())), 1);
        int height = Math.max(class_3532.method_15375((float)((float)(bounds.height - 2) / (float)EntryListWidget.entrySize())), 1);
        return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)EntryListWidget.entrySize() / 2.0f)), (int)((float)bounds.getCenterY() - (float)height * ((float)EntryListWidget.entrySize() / 2.0f)), width * EntryListWidget.entrySize(), height * EntryListWidget.entrySize());
    }

    public boolean method_25401(double double_1, double double_2, double double_3) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled() && this.bounds.contains(double_1, double_2)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
            return true;
        }
        return super.method_25401(double_1, double_2, double_3);
    }

    public @NotNull Rectangle getBounds() {
        return this.bounds;
    }

    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        EntryListWidget.page = page;
    }

    public void previousPage() {
        --page;
    }

    public void nextPage() {
        ++page;
    }

    public int getTotalPages() {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            return 1;
        }
        return class_3532.method_15386((float)((float)this.allStacks.size() / (float)this.entries.size()));
    }

    public static void renderEntries(boolean debugTime, int[] size, long[] time, boolean fastEntryRendering, class_4587 matrices, int mouseX, int mouseY, float delta, List<EntryListEntryWidget> entries) {
        if (entries.isEmpty()) {
            return;
        }
        EntryListEntryWidget firstWidget = entries.get(0);
        EntryStack first = firstWidget.getCurrentEntry();
        if (fastEntryRendering && first instanceof OptimalEntryStack) {
            EntryStack currentEntry;
            OptimalEntryStack firstStack = (OptimalEntryStack)first;
            firstStack.optimisedRenderStart(matrices, delta);
            long l = debugTime ? System.nanoTime() : 0L;
            class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
            for (EntryListEntryWidget listEntry : entries) {
                currentEntry = listEntry.getCurrentEntry();
                currentEntry.setZ(100);
                listEntry.drawBackground(matrices, mouseX, mouseY, delta);
                ((OptimalEntryStack)currentEntry).optimisedRenderBase(matrices, immediate, listEntry.getInnerBounds(), mouseX, mouseY, delta);
                if (!debugTime || currentEntry.isEmpty()) continue;
                size[0] = size[0] + 1;
            }
            immediate.method_22993();
            for (EntryListEntryWidget listEntry : entries) {
                currentEntry = listEntry.getCurrentEntry();
                ((OptimalEntryStack)currentEntry).optimisedRenderOverlay(matrices, listEntry.getInnerBounds(), mouseX, mouseY, delta);
                if (!listEntry.containsMouse(mouseX, mouseY)) continue;
                listEntry.queueTooltip(matrices, mouseX, mouseY, delta);
                listEntry.drawHighlighted(matrices, mouseX, mouseY, delta);
            }
            if (debugTime) {
                time[0] = time[0] + (System.nanoTime() - l);
            }
            firstStack.optimisedRenderEnd(matrices, delta);
        } else {
            for (EntryListEntryWidget entry : entries) {
                if (entry.getCurrentEntry().isEmpty()) continue;
                if (debugTime) {
                    size[0] = size[0] + 1;
                    long l = System.nanoTime();
                    entry.method_25394(matrices, mouseX, mouseY, delta);
                    time[0] = time[0] + (System.nanoTime() - l);
                    continue;
                }
                entry.method_25394(matrices, mouseX, mouseY, delta);
            }
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        int[] size = new int[]{0};
        long[] time = new long[]{0L};
        long totalTimeStart = this.debugTime ? System.nanoTime() : 0L;
        boolean fastEntryRendering = ConfigObject.getInstance().doesFastEntryRendering();
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            for (EntryListEntry entry2 : this.entries) {
                entry2.clearStacks();
            }
            ScissorsHandler.INSTANCE.scissor(this.bounds);
            int skip = Math.max(0, class_3532.method_15357((double)(this.scrolling.scrollAmount / (double)EntryListWidget.entrySize())));
            int nextIndex = skip * this.innerBounds.width / EntryListWidget.entrySize();
            int[] nArray = new int[]{nextIndex};
            this.blockedCount = 0;
            Stream<EntryListEntry> entryStream = this.entries.stream().skip(nextIndex).filter(entry -> {
                entry.getBounds().y = (int)((double)entry.backupY - this.scrolling.scrollAmount);
                if (entry.getBounds().y > this.bounds.getMaxY()) {
                    return false;
                }
                if (EntryListWidget.notSteppingOnExclusionZones(entry.getBounds().x, entry.getBounds().y, this.innerBounds)) {
                    int n = i[0];
                    i[0] = n + 1;
                    EntryStack stack = this.allStacks.get(n);
                    if (!stack.isEmpty()) {
                        entry.entry(stack);
                        return true;
                    }
                } else {
                    ++this.blockedCount;
                }
                return false;
            }).limit(Math.max(0, this.allStacks.size() - nArray[0]));
            if (fastEntryRendering) {
                entryStream.collect(Collectors.groupingBy(entryListEntry -> OptimalEntryStack.groupingHashFrom(entryListEntry.getCurrentEntry()))).forEach((integer, entries) -> EntryListWidget.renderEntries(this.debugTime, size, time, fastEntryRendering, matrices, mouseX, mouseY, delta, entries));
            } else {
                EntryListWidget.renderEntries(this.debugTime, size, time, fastEntryRendering, matrices, mouseX, mouseY, delta, entryStream.collect(Collectors.toList()));
            }
            this.updatePosition(delta);
            ScissorsHandler.INSTANCE.removeLastScissor();
            this.scrolling.renderScrollBar(0, 1.0f, REIHelper.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        } else {
            for (Widget widget : this.renders) {
                widget.method_25394(matrices, mouseX, mouseY, delta);
            }
            if (fastEntryRendering) {
                this.entries.stream().collect(Collectors.groupingBy(entryListEntry -> OptimalEntryStack.groupingHashFrom(entryListEntry.getCurrentEntry()))).forEach((integer, entries) -> EntryListWidget.renderEntries(this.debugTime, size, time, fastEntryRendering, matrices, mouseX, mouseY, delta, entries));
            } else {
                EntryListWidget.renderEntries(this.debugTime, size, time, fastEntryRendering, matrices, mouseX, mouseY, delta, this.entries);
            }
        }
        if (this.debugTime) {
            long totalTime = System.nanoTime() - totalTimeStart;
            this.averageDebugTime += (double)time[0] / (double)size[0] * (double)delta;
            this.totalDebugTime += (double)totalTime / 1000000.0 * (double)delta;
            this.totalDebugTimeDelta += delta;
            if (this.totalDebugTimeDelta >= 20.0f) {
                this.lastAverageDebugTime = this.averageDebugTime / (double)this.totalDebugTimeDelta;
                this.lastTotalDebugTime = this.totalDebugTime / (double)this.totalDebugTimeDelta;
                this.averageDebugTime = 0.0;
                this.totalDebugTime = 0.0;
                this.totalDebugTimeDelta = 0.0f;
            } else if (this.lastAverageDebugTime == 0.0) {
                this.lastAverageDebugTime = (double)time[0] / (double)size[0];
                this.totalDebugTime = (double)totalTime / 1000000.0;
            }
            int n = this.getZ();
            this.setZ(500);
            class_2585 debugText = new class_2585(String.format("%d entries, avg. %.0fns, ttl. %.2fms, %s fps", size[0], this.lastAverageDebugTime, this.lastTotalDebugTime, this.minecraft.field_1770.split(" ")[0]));
            int stringWidth = this.font.method_27525((class_5348)debugText);
            int n2 = Math.min(this.bounds.x, this.minecraft.field_1755.field_22789 - stringWidth - 2);
            int n3 = this.bounds.y;
            int n4 = this.bounds.x + stringWidth + 2;
            int n5 = this.bounds.y;
            this.font.getClass();
            this.method_25296(matrices, n2, n3, n4, n5 + 9 + 2, -16777216, -16777216);
            class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, (double)this.getZ());
            class_1159 matrix = matrices.method_23760().method_23761();
            this.font.method_22942(debugText.method_30937(), (float)Math.min(this.bounds.x + 2, this.minecraft.field_1755.field_22789 - stringWidth), (float)(this.bounds.y + 2), -1, false, matrix, (class_4597)immediate, false, 0, 0xF000F0);
            immediate.method_22993();
            this.setZ(n);
            matrices.method_22909();
        }
        if (this.containsMouse(mouseX, mouseY) && ClientHelper.getInstance().isCheating() && !this.minecraft.field_1724.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.canDeleteItems()) {
            class_1792 bucketItem;
            EntryStack stack = EntryStack.create((class_1799)this.minecraft.field_1724.field_7514.method_7399().method_7972());
            if (stack.getType() == EntryStack.Type.FLUID && (bucketItem = stack.getFluid().method_15774()) != null) {
                stack = EntryStack.create((class_1935)bucketItem);
            }
            for (Widget widget : this.method_25396()) {
                if (!widget.containsMouse(mouseX, mouseY) || !(widget instanceof EntryWidget) || !((EntryWidget)widget).cancelDeleteItems(stack)) continue;
                return;
            }
            Tooltip.create((class_2561[])new class_2561[]{new class_2588("text.rei.delete_items")}).queue();
        }
    }

    private int getScrollbarMinX() {
        if (ConfigObject.getInstance().isLeftHandSidePanel()) {
            return this.bounds.x + 1;
        }
        return this.bounds.getMaxX() - 7;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, dx, dy, ConfigObject.getInstance().doesSnapToRows(), (double)EntryListWidget.entrySize())) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dx, dy);
    }

    private void updatePosition(float delta) {
        if (ConfigObject.getInstance().doesSnapToRows() && this.scrolling.scrollTarget >= 0.0 && this.scrolling.scrollTarget <= (double)this.scrolling.getMaxScroll()) {
            double nearestRow = (double)Math.round(this.scrolling.scrollTarget / (double)EntryListWidget.entrySize()) * (double)EntryListWidget.entrySize();
            this.scrolling.scrollTarget = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.scrolling.scrollTarget, (double)nearestRow, (double)0.001f) ? (this.scrolling.scrollTarget += (nearestRow - this.scrolling.scrollTarget) * Math.min((double)delta / 2.0, 1.0)) : nearestRow;
        }
        this.scrolling.updatePosition(delta);
    }

    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (this.containsMouse(PointHelper.ofMouse())) {
            for (Widget widget : this.widgets) {
                if (!widget.method_25404(int_1, int_2, int_3)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateArea(@Nullable String searchTerm) {
        this.bounds = ScreenHelper.getItemListArea(ScreenHelper.getLastOverlay().getBounds());
        FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateFavoritesBounds(searchTerm);
        }
        if (searchTerm != null) {
            this.updateSearch(searchTerm, true);
        } else if (this.allStacks == null || favoritesListWidget != null && favoritesListWidget.favorites == null) {
            this.updateSearch("", true);
        } else {
            this.updateEntriesPosition();
        }
    }

    public void updateEntriesPosition() {
        this.innerBounds = EntryListWidget.updateInnerBounds(this.bounds);
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            this.renders = Lists.newArrayList();
            page = Math.max(page, 0);
            ArrayList entries = Lists.newArrayList();
            int width = this.innerBounds.width / EntryListWidget.entrySize();
            int height = this.innerBounds.height / EntryListWidget.entrySize();
            for (int currentY = 0; currentY < height; ++currentY) {
                for (int currentX = 0; currentX < width; ++currentX) {
                    if (!EntryListWidget.notSteppingOnExclusionZones(currentX * EntryListWidget.entrySize() + this.innerBounds.x, currentY * EntryListWidget.entrySize() + this.innerBounds.y, this.innerBounds)) continue;
                    entries.add((EntryListEntry)new EntryListEntry(currentX * EntryListWidget.entrySize() + this.innerBounds.x, currentY * EntryListWidget.entrySize() + this.innerBounds.y).noBackground());
                }
            }
            page = Math.max(Math.min(page, this.getTotalPages() - 1), 0);
            List subList = this.allStacks.stream().skip(Math.max(0, page * entries.size())).limit(Math.max(0, entries.size() - Math.max(0, -page * entries.size()))).collect(Collectors.toList());
            for (int i = 0; i < subList.size(); ++i) {
                EntryStack stack = (EntryStack)subList.get(i);
                ((EntryListEntry)((Object)entries.get(i + Math.max(0, -page * entries.size())))).clearStacks().entry(stack);
            }
            this.entries = entries;
            this.widgets = Lists.newArrayList(this.renders);
            this.widgets.addAll(entries);
        } else {
            page = 0;
            int width = this.innerBounds.width / EntryListWidget.entrySize();
            int pageHeight = this.innerBounds.height / EntryListWidget.entrySize();
            int slotsToPrepare = Math.max(this.allStacks.size() * 3, width * pageHeight * 3);
            int currentX = 0;
            int currentY = 0;
            ArrayList entries = Lists.newArrayList();
            for (int i = 0; i < slotsToPrepare; ++i) {
                int xPos = currentX * EntryListWidget.entrySize() + this.innerBounds.x;
                int yPos = currentY * EntryListWidget.entrySize() + this.innerBounds.y;
                entries.add((EntryListEntry)new EntryListEntry(xPos, yPos).noBackground());
                if (++currentX < width) continue;
                currentX = 0;
                ++currentY;
            }
            this.entries = entries;
            this.widgets = Lists.newArrayList(this.renders);
            this.widgets.addAll(entries);
        }
        FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateEntriesPosition();
        }
    }

    public List<EntryStack> getAllStacks() {
        return this.allStacks;
    }

    public void updateSearch(String searchTerm) {
        this.updateSearch(searchTerm, true);
    }

    public void updateSearch(String searchTerm, boolean ignoreLastSearch) {
        long started = System.nanoTime();
        if (ignoreLastSearch || this.lastSearchTerm == null || !this.lastSearchTerm.equals(searchTerm)) {
            EntryPanelOrdering ordering;
            List stacks;
            HashSet workingItems;
            this.lastSearchTerm = searchTerm;
            this.lastSearchArguments = SearchArgument.processSearchTerm(searchTerm);
            ArrayList list = Lists.newArrayList();
            boolean checkCraftable = ConfigManager.getInstance().isCraftableOnlyEnabled() && !ScreenHelper.inventoryStacks.isEmpty();
            HashSet hashSet = workingItems = checkCraftable ? Sets.newHashSet() : null;
            if (checkCraftable) {
                workingItems.addAll(CollectionUtils.map((List)RecipeHelper.getInstance().findCraftableEntriesByItems(CollectionUtils.map(ScreenHelper.inventoryStacks, EntryStack::create)), EntryStack::hashIgnoreAmount));
            }
            if ((stacks = EntryRegistry.getInstance().getPreFilteredList()) instanceof CopyOnWriteArrayList && !stacks.isEmpty()) {
                if (ConfigObject.getInstance().shouldAsyncSearch()) {
                    int size = ConfigObject.getInstance().getNumberAsyncSearch();
                    ArrayList completableFutures = Lists.newArrayList();
                    for (int i = 0; i < stacks.size(); i += size) {
                        int[] start = new int[]{i};
                        completableFutures.add(CompletableFuture.supplyAsync(() -> {
                            int end = Math.min(stacks.size(), start[0] + size);
                            ArrayList filtered = Lists.newArrayList();
                            while (start[0] < end) {
                                EntryStack stack = (EntryStack)stacks.get(start[0]);
                                if (this.canLastSearchTermsBeAppliedTo(stack) && (workingItems == null || workingItems.contains(stack.hashIgnoreAmount()))) {
                                    filtered.add(stack.copy().setting(EntryStack.Settings.RENDER_COUNTS, (Object)EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT, RENDER_ENCHANTMENT_GLINT));
                                }
                                start[0] = start[0] + 1;
                            }
                            return filtered;
                        }));
                    }
                    try {
                        CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get(10L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        e.printStackTrace();
                    }
                    for (CompletableFuture future : completableFutures) {
                        List now = future.getNow(null);
                        if (now == null) continue;
                        list.addAll(now);
                    }
                } else {
                    for (EntryStack stack : stacks) {
                        if (!this.canLastSearchTermsBeAppliedTo(stack) || workingItems != null && !workingItems.contains(stack.hashIgnoreAmount())) continue;
                        list.add(stack.copy().setting(EntryStack.Settings.RENDER_COUNTS, (Object)EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT, RENDER_ENCHANTMENT_GLINT));
                    }
                }
            }
            if ((ordering = ConfigObject.getInstance().getItemListOrdering()) == EntryPanelOrdering.NAME) {
                list.sort(ENTRY_NAME_COMPARER);
            }
            if (ordering == EntryPanelOrdering.GROUPS) {
                list.sort(ENTRY_GROUP_COMPARER);
            }
            if (!ConfigObject.getInstance().isItemListAscending()) {
                Collections.reverse(list);
            }
            this.allStacks = list;
        }
        this.debugTime = ConfigObject.getInstance().doDebugRenderTimeRequired();
        FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateSearch(this, searchTerm);
        }
        long ended = System.nanoTime();
        long time = ended - started;
        if (ConfigObject.getInstance().doDebugSearchTimeRequired()) {
            RoughlyEnoughItemsCore.LOGGER.info("Search Used: %.2fms", (Object)((double)time * 1.0E-6));
        }
        this.updateEntriesPosition();
    }

    public boolean canLastSearchTermsBeAppliedTo(EntryStack stack) {
        return this.lastSearchArguments.isEmpty() || SearchArgument.canSearchTermsBeAppliedTo(stack, this.lastSearchArguments);
    }

    public List<? extends Widget> method_25396() {
        return this.widgets;
    }

    public boolean method_25402(double double_1, double double_2, int int_1) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled() && this.scrolling.updateDraggingState(double_1, double_2, int_1)) {
            return true;
        }
        for (Widget widget : this.method_25396()) {
            if (!widget.method_25402(double_1, double_2, int_1)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.containsMouse(mouseX, mouseY)) {
            for (Widget widget : this.method_25396()) {
                if (!widget.method_25406(mouseX, mouseY, button)) continue;
                return true;
            }
            class_746 player = this.minecraft.field_1724;
            if (ClientHelper.getInstance().isCheating() && player != null && player.field_7514 != null && !player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.canDeleteItems()) {
                ClientHelper.getInstance().sendDeletePacket();
                return true;
            }
            if (player != null && player.field_7514 != null && !player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                return false;
            }
        }
        return false;
    }

    private class EntryListEntry
    extends EntryListEntryWidget {
        private EntryListEntry(int x, int y) {
            super(new Point(x, y));
        }

        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && EntryListWidget.this.bounds.contains(mouseX, mouseY);
        }
    }
}

