/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.sargunvohra.mcmods.autoconfig1u.AutoConfig;
import me.sargunvohra.mcmods.autoconfig1u.ConfigManager;
import me.sargunvohra.mcmods.autoconfig1u.annotation.ConfigEntry;
import me.sargunvohra.mcmods.autoconfig1u.gui.ConfigScreenProvider;
import me.sargunvohra.mcmods.autoconfig1u.gui.registry.GuiRegistry;
import me.sargunvohra.mcmods.autoconfig1u.serializer.JanksonConfigSerializer;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.Jankson;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.JsonObject;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.JsonPrimitive;
import me.sargunvohra.mcmods.autoconfig1u.util.Utils;
import me.shedaniel.cloth.api.client.events.v0.ScreenHooks;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.clothconfig2.gui.entries.KeyCodeEntry;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.config.RecipeScreenType;
import me.shedaniel.rei.gui.config.entry.FilteringEntry;
import me.shedaniel.rei.gui.config.entry.NoFilteringEntry;
import me.shedaniel.rei.gui.config.entry.RecipeScreenTypeEntry;
import me.shedaniel.rei.gui.config.entry.ReloadPluginsEntry;
import me.shedaniel.rei.gui.credits.CreditsScreen;
import me.shedaniel.rei.impl.ConfigObjectImpl;
import me.shedaniel.rei.impl.EntryRegistryImpl;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.filtering.FilteringRule;
import me.shedaniel.rei.impl.filtering.rules.ManualFilteringRule;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;

@Environment(value=EnvType.CLIENT)
public class ConfigManagerImpl
implements me.shedaniel.rei.api.ConfigManager {
    private boolean craftableOnly = false;
    private final Gson gson = new GsonBuilder().create();

    public ConfigManagerImpl() {
        AutoConfig.register(ConfigObjectImpl.class, (definition, configClass) -> new JanksonConfigSerializer(definition, configClass, Jankson.builder().registerPrimitiveTypeAdapter(class_3675.class_306.class, it -> it instanceof String ? class_3675.method_15981((String)((String)it)) : null).registerSerializer(class_3675.class_306.class, (it, marshaller) -> new JsonPrimitive((Object)it.method_1441())).registerTypeAdapter(ModifierKeyCode.class, o -> {
            String code = ((JsonPrimitive)o.get((Object)"keyCode")).asString();
            if (code.endsWith(".unknown")) {
                return ModifierKeyCode.unknown();
            }
            class_3675.class_306 keyCode = class_3675.method_15981((String)code);
            Modifier modifier = Modifier.of((short)((Number)((JsonPrimitive)o.get((Object)"modifier")).getValue()).shortValue());
            return ModifierKeyCode.of((class_3675.class_306)keyCode, (Modifier)modifier);
        }).registerSerializer(ModifierKeyCode.class, (keyCode, marshaller) -> {
            JsonObject object = new JsonObject();
            object.put("keyCode", (me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.JsonElement)new JsonPrimitive((Object)keyCode.getKeyCode().method_1441()));
            object.put("modifier", (me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.JsonElement)new JsonPrimitive((Object)keyCode.getModifier().getValue()));
            return object;
        }).registerSerializer(EntryStack.class, (stack, marshaller) -> new JsonPrimitive((Object)this.gson.toJson(stack.toJson()))).registerPrimitiveTypeAdapter(EntryStack.class, it -> it instanceof String ? EntryStack.readFromJson((JsonElement)((JsonElement)this.gson.fromJson((String)it, JsonElement.class))) : null).registerSerializer(FilteringRule.class, (rule, marshaller) -> new JsonPrimitive((Object)FilteringRule.toTag(rule, new class_2487()).toString())).registerPrimitiveTypeAdapter(FilteringRule.class, it -> {
            try {
                return it instanceof String ? FilteringRule.fromTag(class_2522.method_10718((String)((String)it))) : null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }).build()));
        GuiRegistry guiRegistry = AutoConfig.getGuiRegistry(ConfigObjectImpl.class);
        guiRegistry.registerPredicateProvider((i13n, field, config, defaults, guiProvider) -> {
            if (field.isAnnotationPresent(ConfigEntry.Gui.Excluded.class)) {
                return Collections.emptyList();
            }
            KeyCodeEntry entry = ConfigEntryBuilder.create().startModifierKeyCodeField((class_2561)new class_2588(i13n), (ModifierKeyCode)Utils.getUnsafely((Field)field, (Object)config, (Object)ModifierKeyCode.unknown())).setModifierDefaultValue(() -> (ModifierKeyCode)Utils.getUnsafely((Field)field, (Object)defaults)).setModifierSaveConsumer(newValue -> Utils.setUnsafely((Field)field, (Object)config, (Object)newValue)).build();
            return Collections.singletonList(entry);
        }, field -> field.getType() == ModifierKeyCode.class);
        guiRegistry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> {
            ConfigObjectImpl.UsePercentage bounds = field.getAnnotation(ConfigObjectImpl.UsePercentage.class);
            return Collections.singletonList(ConfigEntryBuilder.create().startIntSlider((class_2561)new class_2588(i13n), class_3532.method_15384((double)((Double)Utils.getUnsafely((Field)field, (Object)config, (Object)0.0) * 100.0)), class_3532.method_15384((double)(bounds.min() * 100.0)), class_3532.method_15384((double)(bounds.max() * 100.0))).setDefaultValue(() -> class_3532.method_15384((double)((Double)Utils.getUnsafely((Field)field, (Object)defaults) * 100.0))).setSaveConsumer(newValue -> Utils.setUnsafely((Field)field, (Object)config, (Object)((double)newValue.intValue() / 100.0))).setTextGetter(integer -> new class_2585(String.format("Size: %d%%", integer))).build());
        }, field -> field.getType() == Double.TYPE || field.getType() == Double.class, new Class[]{ConfigObjectImpl.UsePercentage.class});
        guiRegistry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> Collections.singletonList(new RecipeScreenTypeEntry(220, (class_2561)new class_2588(i13n), (RecipeScreenType)Utils.getUnsafely((Field)field, (Object)config, (Object)RecipeScreenType.UNSET), (RecipeScreenType)Utils.getUnsafely((Field)field, (Object)defaults), type -> Utils.setUnsafely((Field)field, (Object)config, (Object)type))), field -> field.getType() == RecipeScreenType.class, new Class[]{ConfigObjectImpl.UseSpecialRecipeTypeScreen.class});
        guiRegistry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> REIHelper.getInstance().getPreviousContainerScreen() == null || class_310.method_1551().method_1562() == null || class_310.method_1551().method_1562().method_2877() == null ? Collections.singletonList(new NoFilteringEntry(220, (List)Utils.getUnsafely((Field)field, (Object)config, new ArrayList()), (List)Utils.getUnsafely((Field)field, (Object)defaults), list -> Utils.setUnsafely((Field)field, (Object)config, (Object)list))) : Collections.singletonList(new FilteringEntry(220, (List)Utils.getUnsafely((Field)field, (Object)config, new ArrayList()), ((ConfigObjectImpl.Advanced.Filtering)config).filteringRules, (List)Utils.getUnsafely((Field)field, (Object)defaults), list -> Utils.setUnsafely((Field)field, (Object)config, (Object)list), list -> {
            ((ConfigObjectImpl.Advanced.Filtering)config).filteringRules = Lists.newArrayList((Iterable)list);
        })), field -> field.getType() == List.class, new Class[]{ConfigObjectImpl.UseFilteringScreen.class});
        this.saveConfig();
        RoughlyEnoughItemsCore.LOGGER.info("Config loaded.");
    }

    public void saveConfig() {
        if (this.getConfig().getFavorites() != null) {
            this.getConfig().getFavorites().removeIf(EntryStack::isEmpty);
        }
        if (this.getConfig().getFilteredStacks() != null) {
            this.getConfig().getFilteredStacks().removeIf(EntryStack::isEmpty);
            for (EntryStack stack : this.getConfig().getFilteredStacks()) {
                stack.setting(EntryStack.Settings.CHECK_AMOUNT, (Object)EntryStack.Settings.FALSE).setting(EntryStack.Settings.RENDER_COUNTS, (Object)EntryStack.Settings.FALSE).setting(EntryStack.Settings.CHECK_TAGS, (Object)EntryStack.Settings.TRUE);
            }
        }
        if (this.getConfig().getFilteringRules().stream().noneMatch(filteringRule -> filteringRule instanceof ManualFilteringRule)) {
            this.getConfig().getFilteringRules().add(new ManualFilteringRule());
        }
        ((ConfigManager)AutoConfig.getConfigHolder(ConfigObjectImpl.class)).save();
    }

    public ConfigObjectImpl getConfig() {
        return (ConfigObjectImpl)AutoConfig.getConfigHolder(ConfigObjectImpl.class).getConfig();
    }

    public boolean isCraftableOnlyEnabled() {
        return this.craftableOnly;
    }

    public void toggleCraftableOnly() {
        this.craftableOnly = !this.craftableOnly;
    }

    public class_437 getConfigScreen(class_437 parent) {
        try {
            if (FabricLoader.getInstance().isModLoaded("optifabric")) {
                return new ConfigErrorScreen(parent, (class_2561)new class_2588("text.rei.config.optifine.title"), (class_2561)new class_2588("text.rei.config.optifine.description"));
            }
            ConfigScreenProvider provider = (ConfigScreenProvider)AutoConfig.getConfigScreen(ConfigObjectImpl.class, (class_437)parent);
            provider.setI13nFunction(manager -> "config.roughlyenoughitems");
            provider.setOptionFunction((baseI13n, field) -> field.isAnnotationPresent(ConfigObjectImpl.DontApplyFieldName.class) ? baseI13n : String.format("%s.%s", baseI13n, field.getName()));
            provider.setCategoryFunction((baseI13n, categoryName) -> String.format("%s.%s", baseI13n, categoryName));
            provider.setBuildFunction(builder -> {
                builder.setGlobalized(true);
                builder.setGlobalizedExpanded(true);
                if (class_310.method_1551().method_1562() != null && class_310.method_1551().method_1562().method_2877() != null) {
                    builder.getOrCreateCategory((class_2561)new class_2588("config.roughlyenoughitems.advanced")).getEntries().add(0, new ReloadPluginsEntry(220));
                }
                return builder.setAfterInitConsumer(screen -> ((ScreenHooks)screen).cloth$addButtonWidget((class_339)new class_4185(screen.field_22789 - 104, 4, 100, 20, (class_2561)new class_2588("text.rei.credits"), button -> class_310.method_1551().method_1507((class_437)new CreditsScreen((class_437)screen))))).setSavingRunnable(() -> {
                    this.saveConfig();
                    ((EntryRegistryImpl)EntryRegistry.getInstance()).refilter();
                    if (ScreenHelper.getSearchField() != null) {
                        ContainerScreenOverlay.getEntryListWidget().updateSearch(ScreenHelper.getSearchField().getText(), true);
                    }
                }).build();
            });
            return provider.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class ConfigErrorScreen
    extends class_437 {
        private final class_2561 message;
        private final class_437 parent;

        public ConfigErrorScreen(class_437 parent, class_2561 title, class_2561 message) {
            super(title);
            this.parent = parent;
            this.message = message;
        }

        protected void method_25426() {
            super.method_25426();
            this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 100, 140, 200, 20, class_5244.field_24335, button -> this.field_22787.method_1507(this.parent)));
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            this.method_25420(matrices);
            ConfigErrorScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)90, (int)0xFFFFFF);
            ConfigErrorScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.message, (int)(this.field_22789 / 2), (int)110, (int)0xFFFFFF);
            super.method_25394(matrices, mouseX, mouseY, delta);
        }

        public boolean method_25422() {
            return false;
        }
    }
}

