/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.BaseBoundsHandler;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.OverlayDecider;
import me.shedaniel.rei.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.utils.CollectionUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class DisplayHelperImpl
implements DisplayHelper {
    private static final Comparator<OverlayDecider> BOUNDS_HANDLER_COMPARATOR = Comparator.comparingDouble(OverlayDecider::getPriority).reversed();
    private static final DisplayHelper.DisplayBoundsHandler<Object> EMPTY = new DisplayHelper.DisplayBoundsHandler<Object>(){

        public Class<Object> getBaseSupportedClass() {
            return null;
        }

        public Rectangle getLeftBounds(Object screen) {
            return new Rectangle();
        }

        public Rectangle getRightBounds(Object screen) {
            return new Rectangle();
        }

        public float getPriority() {
            return -10.0f;
        }
    };
    private List<OverlayDecider> screenDisplayBoundsHandlers = Lists.newArrayList();
    private Map<Class<?>, DisplayHelper.DisplayBoundsHandler<?>> handlerCache = Maps.newHashMap();
    private Map<Class<?>, List<OverlayDecider>> deciderSortedCache = Maps.newHashMap();
    private Map<Class<?>, List<DisplayHelper.DisplayBoundsHandler<?>>> handlerSortedCache = Maps.newHashMap();
    private BaseBoundsHandler baseBoundsHandler;
    private Class<?> tempScreen;

    public List<DisplayHelper.DisplayBoundsHandler<?>> getSortedBoundsHandlers(Class<?> screenClass) {
        List<DisplayHelper.DisplayBoundsHandler<?>> possibleCached = this.handlerSortedCache.get(screenClass);
        if (possibleCached != null) {
            return possibleCached;
        }
        this.tempScreen = screenClass;
        this.handlerSortedCache.put(screenClass, CollectionUtils.castAndMap((List)CollectionUtils.filter(this.screenDisplayBoundsHandlers, this::filterResponsible), DisplayHelper.DisplayBoundsHandler.class));
        return this.handlerSortedCache.get(screenClass);
    }

    public List<OverlayDecider> getSortedOverlayDeciders(Class<?> screenClass) {
        List<OverlayDecider> possibleCached = this.deciderSortedCache.get(screenClass);
        if (possibleCached != null) {
            return possibleCached;
        }
        this.tempScreen = screenClass;
        this.deciderSortedCache.put(screenClass, CollectionUtils.filter(this.screenDisplayBoundsHandlers, this::filterResponsible));
        return this.deciderSortedCache.get(screenClass);
    }

    public List<OverlayDecider> getAllOverlayDeciders() {
        return Collections.unmodifiableList(this.screenDisplayBoundsHandlers);
    }

    public DisplayHelper.DisplayBoundsHandler<?> getResponsibleBoundsHandler(Class<?> screenClass) {
        DisplayHelper.DisplayBoundsHandler<?> possibleCached = this.handlerCache.get(screenClass);
        if (possibleCached != null) {
            return possibleCached;
        }
        List<DisplayHelper.DisplayBoundsHandler<?>> handlers = this.getSortedBoundsHandlers(screenClass);
        this.handlerCache.put(screenClass, (DisplayHelper.DisplayBoundsHandler<?>)(handlers.isEmpty() ? EMPTY : handlers.get(0)));
        return this.handlerCache.get(screenClass);
    }

    public <T> Rectangle getOverlayBounds(DisplayPanelLocation location, T screen) {
        class_1041 window = class_310.method_1551().method_22683();
        int scaledWidth = window.method_4486();
        int scaledHeight = window.method_4502();
        for (OverlayDecider decider : this.getSortedOverlayDeciders(screen.getClass())) {
            if (decider instanceof DisplayHelper.DisplayBoundsProvider) {
                Rectangle containerBounds = ((DisplayHelper.DisplayBoundsProvider)decider).getScreenBounds(screen);
                if (location == DisplayPanelLocation.LEFT) {
                    if (containerBounds.x < 10) continue;
                    return new Rectangle(2, 0, containerBounds.x - 2, scaledHeight);
                }
                if (scaledWidth - containerBounds.getMaxX() < 10) continue;
                return new Rectangle(containerBounds.getMaxX() + 2, 0, scaledWidth - containerBounds.getMaxX() - 4, scaledHeight);
            }
            if (!(decider instanceof DisplayHelper.DisplayBoundsHandler)) continue;
            return location == DisplayPanelLocation.LEFT ? ((DisplayHelper.DisplayBoundsHandler)decider).getLeftBounds(screen) : ((DisplayHelper.DisplayBoundsHandler)decider).getRightBounds(screen);
        }
        return new Rectangle();
    }

    private boolean filterResponsible(OverlayDecider handler) {
        return handler.isHandingScreen(this.tempScreen);
    }

    public void registerHandler(OverlayDecider decider) {
        this.screenDisplayBoundsHandlers.add(decider);
        this.screenDisplayBoundsHandlers.sort(BOUNDS_HANDLER_COMPARATOR);
    }

    public BaseBoundsHandler getBaseBoundsHandler() {
        return this.baseBoundsHandler;
    }

    public void setBaseBoundsHandler(BaseBoundsHandler baseBoundsHandler) {
        this.baseBoundsHandler = baseBoundsHandler;
    }

    public void resetData() {
        this.screenDisplayBoundsHandlers.clear();
    }

    public void resetCache() {
        this.handlerCache.clear();
        this.deciderSortedCache.clear();
        this.handlerSortedCache.clear();
    }
}

