/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.AutoTransferHandler;
import me.shedaniel.rei.api.BaseBoundsHandler;
import me.shedaniel.rei.api.ButtonAreaSupplier;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.DisplayVisibilityHandler;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.FocusedStackProvider;
import me.shedaniel.rei.api.LiveRecipeGenerator;
import me.shedaniel.rei.api.OverlayDecider;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.REIOverlay;
import me.shedaniel.rei.api.REIPluginEntry;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.plugins.REIPluginV0;
import me.shedaniel.rei.api.subsets.SubsetsRegistry;
import me.shedaniel.rei.impl.BaseBoundsHandlerImpl;
import me.shedaniel.rei.impl.DisplayHelperImpl;
import me.shedaniel.rei.impl.EntryRegistryImpl;
import me.shedaniel.rei.impl.FluidSupportProviderImpl;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.subsets.SubsetsRegistryImpl;
import me.shedaniel.rei.utils.CollectionUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class RecipeHelperImpl
implements RecipeHelper {
    private static final Comparator<FocusedStackProvider> FOCUSED_STACK_PROVIDER_COMPARATOR = Comparator.comparingDouble(FocusedStackProvider::getPriority).reversed();
    private static final Comparator<DisplayVisibilityHandler> VISIBILITY_HANDLER_COMPARATOR = Comparator.comparingDouble(DisplayVisibilityHandler::getPriority).reversed();
    private static final Comparator<class_1860> RECIPE_COMPARATOR = Comparator.comparing(o -> o.method_8114().method_12836()).thenComparing(o -> o.method_8114().method_12832());
    private final List<FocusedStackProvider> focusedStackProviders = Lists.newArrayList();
    private final List<AutoTransferHandler> autoTransferHandlers = Lists.newArrayList();
    private final List<RecipeFunction> recipeFunctions = Lists.newArrayList();
    private final List<RecipeHelper.ScreenClickArea> screenClickAreas = Lists.newArrayList();
    private final int[] recipeCount = new int[]{0};
    private final Map<class_2960, List<RecipeDisplay>> recipeDisplays = Maps.newHashMap();
    private final BiMap<RecipeCategory<?>, class_2960> categories = HashBiMap.create();
    private final Map<class_2960, ButtonAreaSupplier> autoCraftAreaSupplierMap = Maps.newHashMap();
    private final Map<class_2960, List<List<EntryStack>>> categoryWorkingStations = Maps.newHashMap();
    private final List<DisplayVisibilityHandler> displayVisibilityHandlers = Lists.newArrayList();
    private final List<LiveRecipeGenerator<RecipeDisplay>> liveRecipeGenerators = Lists.newArrayList();
    private class_1863 recipeManager;
    private boolean arePluginsLoading = false;

    public List<EntryStack> findCraftableEntriesByItems(List<EntryStack> inventoryItems) {
        ArrayList craftables = new ArrayList();
        for (List<RecipeDisplay> value : this.recipeDisplays.values()) {
            for (RecipeDisplay recipeDisplay : Lists.newArrayList(value)) {
                int slotsCraftable = 0;
                List requiredInput = recipeDisplay.getRequiredEntries();
                block2: for (List slot : requiredInput) {
                    if (slot.isEmpty()) {
                        ++slotsCraftable;
                        continue;
                    }
                    for (EntryStack possibleType : inventoryItems) {
                        for (EntryStack slotPossible : slot) {
                            if (!possibleType.equals(slotPossible)) continue;
                            ++slotsCraftable;
                            continue block2;
                        }
                    }
                }
                if (slotsCraftable != recipeDisplay.getRequiredEntries().size()) continue;
                craftables.addAll(recipeDisplay.getOutputEntries());
            }
        }
        return craftables.stream().distinct().collect(Collectors.toList());
    }

    public boolean arePluginsLoading() {
        return this.arePluginsLoading;
    }

    public void registerCategory(RecipeCategory<?> category) {
        this.categories.put(category, (Object)category.getIdentifier());
        this.recipeDisplays.put(category.getIdentifier(), Lists.newArrayList());
        this.categoryWorkingStations.put(category.getIdentifier(), Lists.newArrayList());
    }

    @SafeVarargs
    public final void registerWorkingStations(class_2960 category, List<EntryStack> ... workingStations) {
        this.categoryWorkingStations.get(category).addAll(Arrays.asList(workingStations));
    }

    public void registerWorkingStations(class_2960 category, EntryStack ... workingStations) {
        this.categoryWorkingStations.get(category).addAll(Stream.of(workingStations).map(Collections::singletonList).collect(Collectors.toList()));
    }

    public List<List<EntryStack>> getWorkingStations(class_2960 category) {
        return this.categoryWorkingStations.get(category);
    }

    public void registerDisplay(RecipeDisplay display) {
        class_2960 identifier = Objects.requireNonNull(display.getRecipeCategory());
        if (!this.recipeDisplays.containsKey(identifier)) {
            return;
        }
        this.recipeCount[0] = this.recipeCount[0] + 1;
        this.recipeDisplays.get(identifier).add(display);
    }

    private void registerDisplay(class_2960 categoryIdentifier, RecipeDisplay display, int index) {
        if (!this.recipeDisplays.containsKey(categoryIdentifier)) {
            return;
        }
        this.recipeCount[0] = this.recipeCount[0] + 1;
        this.recipeDisplays.get(categoryIdentifier).add(index, display);
    }

    public Map<RecipeCategory<?>, List<RecipeDisplay>> buildMapFor(ClientHelper.ViewSearchBuilder builder) {
        long start = class_156.method_648();
        Set categories = builder.getCategories();
        List recipesFor = builder.getRecipesFor();
        List usagesFor = builder.getUsagesFor();
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry entry : this.categories.entrySet()) {
            RecipeCategory category = (RecipeCategory)entry.getKey();
            class_2960 categoryId = (class_2960)entry.getValue();
            List<RecipeDisplay> allRecipesFromCategory = this.getAllRecipesFromCategory(category);
            LinkedHashSet set = Sets.newLinkedHashSet();
            if (categories.contains(categoryId)) {
                for (RecipeDisplay display : allRecipesFromCategory) {
                    if (!this.isDisplayVisible(display)) continue;
                    set.add(display);
                }
                if (set.isEmpty()) continue;
                CollectionUtils.getOrPutEmptyList((Map)result, (Object)category).addAll(set);
                continue;
            }
            block2: for (RecipeDisplay display : allRecipesFromCategory) {
                if (!this.isDisplayVisible(display)) continue;
                if (!recipesFor.isEmpty()) {
                    block3: for (EntryStack outputStack : display.getOutputEntries()) {
                        for (EntryStack stack : recipesFor) {
                            if (!stack.equals(outputStack)) continue;
                            set.add(display);
                            break block3;
                        }
                    }
                }
                if (usagesFor.isEmpty()) continue;
                for (List input : display.getInputEntries()) {
                    for (EntryStack otherEntry : input) {
                        for (EntryStack stack : usagesFor) {
                            if (!otherEntry.equals(stack)) continue;
                            set.add(display);
                            continue block2;
                        }
                    }
                }
            }
            for (EntryStack stack : usagesFor) {
                if (!this.isStackWorkStationOfCategory(categoryId, stack)) continue;
                set.addAll(allRecipesFromCategory);
                break;
            }
            if (set.isEmpty()) continue;
            CollectionUtils.getOrPutEmptyList((Map)result, (Object)category).addAll(set);
        }
        for (LiveRecipeGenerator liveRecipeGenerator : this.liveRecipeGenerators) {
            LinkedHashSet set = Sets.newLinkedHashSet();
            for (EntryStack stack : recipesFor) {
                Optional recipeForDisplays = liveRecipeGenerator.getRecipeFor(stack);
                if (!recipeForDisplays.isPresent()) continue;
                for (RecipeDisplay display : (List)recipeForDisplays.get()) {
                    if (!this.isDisplayVisible(display)) continue;
                    set.add(display);
                }
            }
            for (EntryStack stack : usagesFor) {
                Optional usageForDisplays = liveRecipeGenerator.getUsageFor(stack);
                if (!usageForDisplays.isPresent()) continue;
                for (RecipeDisplay display : (List)usageForDisplays.get()) {
                    if (!this.isDisplayVisible(display)) continue;
                    set.add(display);
                }
            }
            Optional displaysGenerated = liveRecipeGenerator.getDisplaysGenerated(builder);
            if (displaysGenerated.isPresent()) {
                for (RecipeDisplay display : (List)displaysGenerated.get()) {
                    if (!this.isDisplayVisible(display)) continue;
                    set.add(display);
                }
            }
            if (set.isEmpty()) continue;
            CollectionUtils.getOrPutEmptyList((Map)result, this.getCategory(liveRecipeGenerator.getCategoryIdentifier())).addAll(set);
        }
        long end = class_156.method_648();
        String message = String.format("Built Recipe View in %d\u03bcs for %d categories, %d recipes for, %d usages for and %d live recipe generators.", (end - start) / 1000L, categories.size(), recipesFor.size(), usagesFor.size(), this.liveRecipeGenerators.size());
        if (ConfigObject.getInstance().doDebugSearchTimeRequired()) {
            RoughlyEnoughItemsCore.LOGGER.info(message);
        } else {
            RoughlyEnoughItemsCore.LOGGER.trace(message);
        }
        return result;
    }

    public Map<RecipeCategory<?>, List<RecipeDisplay>> getRecipesFor(EntryStack stack) {
        return this.buildMapFor(ClientHelper.ViewSearchBuilder.builder().addRecipesFor(stack));
    }

    public RecipeCategory<?> getCategory(class_2960 identifier) {
        return (RecipeCategory)this.categories.inverse().get((Object)identifier);
    }

    public class_1863 getRecipeManager() {
        return this.recipeManager;
    }

    private boolean isStackWorkStationOfCategory(class_2960 category, EntryStack stack) {
        for (List<EntryStack> stacks : this.getWorkingStations(category)) {
            for (EntryStack entryStack : stacks) {
                if (!entryStack.equalsIgnoreTagsAndAmount(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public Map<RecipeCategory<?>, List<RecipeDisplay>> getUsagesFor(EntryStack stack) {
        return this.buildMapFor(ClientHelper.ViewSearchBuilder.builder().addUsagesFor(stack));
    }

    public List<RecipeCategory<?>> getAllCategories() {
        return Lists.newArrayList((Iterable)this.categories.keySet());
    }

    public Optional<ButtonAreaSupplier> getAutoCraftButtonArea(RecipeCategory<?> category) {
        if (!this.autoCraftAreaSupplierMap.containsKey(category.getIdentifier())) {
            return Optional.ofNullable(bounds -> new Rectangle(bounds.getMaxX() - 16, bounds.getMaxY() - 16, 10, 10));
        }
        return Optional.ofNullable(this.autoCraftAreaSupplierMap.get(category.getIdentifier()));
    }

    public void registerAutoCraftButtonArea(class_2960 category, ButtonAreaSupplier rectangle) {
        if (rectangle == null) {
            this.autoCraftAreaSupplierMap.remove(category);
        } else {
            this.autoCraftAreaSupplierMap.put(category, rectangle);
        }
    }

    private void startSection(Object[] sectionData, String section) {
        sectionData[0] = class_156.method_648();
        sectionData[2] = section;
        RoughlyEnoughItemsCore.LOGGER.debug("Reloading Section: \"%s\"", (Object)section);
    }

    private void endSection(Object[] sectionData) {
        sectionData[1] = class_156.method_648();
        long time = (Long)sectionData[1] - (Long)sectionData[0];
        String section = (String)sectionData[2];
        if (time >= 1000000L) {
            RoughlyEnoughItemsCore.LOGGER.debug("Reloading Section: \"%s\" done in %.2fms", (Object)section, (Object)Float.valueOf((float)time / 1000000.0f));
        } else {
            RoughlyEnoughItemsCore.LOGGER.debug("Reloading Section: \"%s\" done in %.2f\u03bcs", (Object)section, (Object)Float.valueOf((float)time / 1000.0f));
        }
    }

    private void pluginSection(Object[] sectionData, String sectionName, List<REIPluginV0> list, Consumer<REIPluginV0> consumer) {
        for (REIPluginV0 plugin : list) {
            try {
                this.startSection(sectionData, sectionName + " for " + plugin.getPluginIdentifier().toString());
                consumer.accept(plugin);
                this.endSection(sectionData);
            }
            catch (Throwable e) {
                RoughlyEnoughItemsCore.LOGGER.error(plugin.getPluginIdentifier().toString() + " plugin failed to " + sectionName + "!", e);
            }
        }
    }

    public void tryRecipesLoaded(class_1863 recipeManager) {
        try {
            this.recipesLoaded(recipeManager);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.arePluginsLoading = false;
    }

    public void recipesLoaded(class_1863 recipeManager) {
        long startTime = class_156.method_658();
        Object[] sectionData = new Object[]{0L, 0L, ""};
        this.startSection(sectionData, "reset-data");
        this.arePluginsLoading = true;
        ScreenHelper.clearLastRecipeScreenData();
        this.recipeCount[0] = 0;
        this.recipeManager = recipeManager;
        this.recipeDisplays.clear();
        this.categories.clear();
        this.autoCraftAreaSupplierMap.clear();
        this.screenClickAreas.clear();
        this.categoryWorkingStations.clear();
        this.recipeFunctions.clear();
        this.displayVisibilityHandlers.clear();
        this.liveRecipeGenerators.clear();
        this.autoTransferHandlers.clear();
        this.focusedStackProviders.clear();
        DisplayHelperImpl displayHelper = (DisplayHelperImpl)DisplayHelper.getInstance();
        EntryRegistryImpl entryRegistry = (EntryRegistryImpl)EntryRegistry.getInstance();
        ((SubsetsRegistryImpl)SubsetsRegistry.getInstance()).reset();
        ((FluidSupportProviderImpl)FluidSupportProvider.getInstance()).reset();
        displayHelper.resetData();
        displayHelper.resetCache();
        BaseBoundsHandlerImpl baseBoundsHandler = new BaseBoundsHandlerImpl();
        displayHelper.registerHandler((OverlayDecider)baseBoundsHandler);
        displayHelper.setBaseBoundsHandler(baseBoundsHandler);
        List<REIPluginEntry> plugins = RoughlyEnoughItemsCore.getPlugins();
        plugins.sort(Comparator.comparingInt(REIPluginEntry::getPriority).reversed());
        RoughlyEnoughItemsCore.LOGGER.info("Reloading REI, registered %d plugins: %s", (Object)plugins.size(), (Object)plugins.stream().map(REIPluginEntry::getPluginIdentifier).map(class_2960::toString).collect(Collectors.joining(", ")));
        Collections.reverse(plugins);
        entryRegistry.reset();
        ArrayList<REIPluginV0> reiPluginV0s = new ArrayList<REIPluginV0>();
        this.endSection(sectionData);
        for (REIPluginEntry plugin2 : plugins) {
            try {
                if (!(plugin2 instanceof REIPluginV0)) continue;
                this.startSection(sectionData, "pre-register for " + plugin2.getPluginIdentifier().toString());
                ((REIPluginV0)plugin2).preRegister();
                reiPluginV0s.add((REIPluginV0)plugin2);
                this.endSection(sectionData);
            }
            catch (Throwable e) {
                RoughlyEnoughItemsCore.LOGGER.error(plugin2.getPluginIdentifier().toString() + " plugin failed to pre register!", e);
            }
        }
        this.pluginSection(sectionData, "register-bounds", reiPluginV0s, plugin -> plugin.registerBounds((DisplayHelper)displayHelper));
        this.pluginSection(sectionData, "register-entries", reiPluginV0s, plugin -> plugin.registerEntries((EntryRegistry)entryRegistry));
        this.pluginSection(sectionData, "register-categories", reiPluginV0s, plugin -> plugin.registerPluginCategories((RecipeHelper)this));
        this.pluginSection(sectionData, "register-displays", reiPluginV0s, plugin -> plugin.registerRecipeDisplays((RecipeHelper)this));
        this.pluginSection(sectionData, "register-others", reiPluginV0s, plugin -> plugin.registerOthers((RecipeHelper)this));
        this.pluginSection(sectionData, "post-register", reiPluginV0s, REIPluginV0::postRegister);
        this.startSection(sectionData, "recipe-functions");
        if (!this.recipeFunctions.isEmpty()) {
            List<class_1860> allSortedRecipes = this.getAllSortedRecipes();
            Collections.reverse(allSortedRecipes);
            for (RecipeFunction recipeFunction : this.recipeFunctions) {
                try {
                    for (class_1860 recipe2 : CollectionUtils.filter(allSortedRecipes, recipe -> recipeFunction.recipeFilter.test(recipe))) {
                        this.registerDisplay(recipeFunction.category, (RecipeDisplay)recipeFunction.mappingFunction.apply(recipe2), 0);
                    }
                }
                catch (Throwable e) {
                    RoughlyEnoughItemsCore.LOGGER.error("Failed to add recipes!", e);
                }
            }
        }
        this.endSection(sectionData);
        this.startSection(sectionData, "fill-handlers");
        if (this.getDisplayVisibilityHandlers().isEmpty()) {
            this.registerRecipeVisibilityHandler(new DisplayVisibilityHandler(){

                public class_1269 handleDisplay(RecipeCategory<?> category, RecipeDisplay display) {
                    return class_1269.field_5812;
                }

                public float getPriority() {
                    return -1.0f;
                }
            });
        }
        this.registerFocusedStackProvider(new FocusedStackProvider(){

            public @NotNull class_1271<EntryStack> provide(class_437 screen) {
                if (screen instanceof class_465) {
                    class_465 containerScreen = (class_465)screen;
                    if (containerScreen.field_2787 != null && !containerScreen.field_2787.method_7677().method_7960()) {
                        return class_1271.method_22427((Object)EntryStack.create((class_1799)containerScreen.field_2787.method_7677()));
                    }
                }
                return class_1271.method_22430((Object)EntryStack.empty());
            }

            public double getPriority() {
                return -1.0;
            }
        });
        displayHelper.registerHandler(new OverlayDecider(){

            public boolean isHandingScreen(Class<?> screen) {
                return true;
            }

            public class_1269 shouldScreenBeOverlayed(Class<?> screen) {
                return class_465.class.isAssignableFrom(screen) ? class_1269.field_5812 : class_1269.field_5811;
            }

            public float getPriority() {
                return -10.0f;
            }
        });
        this.endSection(sectionData);
        displayHelper.resetCache();
        REIHelper.getInstance().getOverlay().ifPresent(REIOverlay::queueReloadOverlay);
        this.startSection(sectionData, "entry-registry-finalise");
        entryRegistry.finishReload();
        this.endSection(sectionData);
        this.startSection(sectionData, "entry-registry-refilter");
        this.arePluginsLoading = false;
        entryRegistry.refilter();
        this.endSection(sectionData);
        this.startSection(sectionData, "finalizing");
        displayHelper.resetCache();
        REIHelper.getInstance().getOverlay().ifPresent(REIOverlay::queueReloadOverlay);
        this.displayVisibilityHandlers.sort(VISIBILITY_HANDLER_COMPARATOR);
        this.endSection(sectionData);
        long usedTime = class_156.method_658() - startTime;
        RoughlyEnoughItemsCore.LOGGER.info("Reloaded %d stack entries, %d recipes displays, %d exclusion zones suppliers, %d overlay deciders, %d visibility handlers and %d categories (%s) in %dms.", (Object)entryRegistry.getEntryStacks().count(), (Object)this.recipeCount[0], (Object)BaseBoundsHandler.getInstance().supplierSize(), (Object)displayHelper.getAllOverlayDeciders().size(), (Object)this.getDisplayVisibilityHandlers().size(), (Object)this.categories.size(), (Object)this.categories.keySet().stream().map(RecipeCategory::getCategoryName).collect(Collectors.joining(", ")), (Object)usedTime);
    }

    public AutoTransferHandler registerAutoCraftingHandler(AutoTransferHandler handler) {
        this.autoTransferHandlers.add(handler);
        this.autoTransferHandlers.sort(Comparator.comparingDouble(AutoTransferHandler::getPriority).reversed());
        return handler;
    }

    public void registerFocusedStackProvider(FocusedStackProvider provider) {
        this.focusedStackProviders.add(provider);
        this.focusedStackProviders.sort(FOCUSED_STACK_PROVIDER_COMPARATOR);
    }

    public @Nullable EntryStack getScreenFocusedStack(class_437 screen) {
        for (FocusedStackProvider provider : this.focusedStackProviders) {
            class_1271 result = Objects.requireNonNull(provider.provide(screen));
            if (result.method_5467() == class_1269.field_5812) {
                if (!((EntryStack)result.method_5466()).isEmpty()) {
                    return (EntryStack)result.method_5466();
                }
                return null;
            }
            if (result.method_5467() != class_1269.field_5814) continue;
            return null;
        }
        return null;
    }

    public List<AutoTransferHandler> getSortedAutoCraftingHandler() {
        return this.autoTransferHandlers;
    }

    public int getRecipeCount() {
        return this.recipeCount[0];
    }

    public List<class_1860> getAllSortedRecipes() {
        return this.getRecipeManager().method_8126().parallelStream().sorted(RECIPE_COMPARATOR).collect(Collectors.toList());
    }

    public Map<RecipeCategory<?>, List<RecipeDisplay>> getAllRecipes() {
        return this.buildMapFor(ClientHelper.ViewSearchBuilder.builder().addAllCategories());
    }

    public Map<RecipeCategory<?>, List<RecipeDisplay>> getAllRecipesNoHandlers() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry entry : this.categories.entrySet()) {
            RecipeCategory category = (RecipeCategory)entry.getKey();
            class_2960 categoryId = (class_2960)entry.getValue();
            List<RecipeDisplay> displays = this.recipeDisplays.get(categoryId);
            if (displays == null || displays.isEmpty()) continue;
            result.put(category, displays);
        }
        return result;
    }

    public List<RecipeDisplay> getAllRecipesFromCategory(RecipeCategory<?> category) {
        return this.recipeDisplays.get(category.getIdentifier());
    }

    public void registerRecipeVisibilityHandler(DisplayVisibilityHandler visibilityHandler) {
        this.displayVisibilityHandlers.add(visibilityHandler);
    }

    public void unregisterRecipeVisibilityHandler(DisplayVisibilityHandler visibilityHandler) {
        this.displayVisibilityHandlers.remove(visibilityHandler);
    }

    public List<DisplayVisibilityHandler> getDisplayVisibilityHandlers() {
        return Collections.unmodifiableList(this.displayVisibilityHandlers);
    }

    public boolean isDisplayNotVisible(RecipeDisplay display) {
        return !this.isDisplayVisible(display);
    }

    public boolean isDisplayVisible(RecipeDisplay display) {
        RecipeCategory<?> category = this.getCategory(display.getRecipeCategory());
        try {
            for (DisplayVisibilityHandler displayVisibilityHandler : this.displayVisibilityHandlers) {
                class_1269 visibility = displayVisibilityHandler.handleDisplay(category, display);
                if (visibility == class_1269.field_5811) continue;
                return visibility == class_1269.field_5812;
            }
        }
        catch (Throwable throwable) {
            RoughlyEnoughItemsCore.LOGGER.error("Failed to check if the recipe is visible!", throwable);
        }
        return true;
    }

    public void registerScreenClickArea(Rectangle rectangle, Class<? extends class_465<?>> screenClass, class_2960 ... categories) {
        this.screenClickAreas.add(new ScreenClickAreaImpl(screenClass, rectangle, categories));
    }

    public <T extends class_1860<?>> void registerRecipes(class_2960 category, Class<T> recipeClass, Function<T, RecipeDisplay> mappingFunction) {
        this.recipeFunctions.add(new RecipeFunction(category, recipe -> recipeClass.isAssignableFrom(recipe.getClass()), mappingFunction));
    }

    public <T extends class_1860<?>> void registerRecipes(class_2960 category, Function<class_1860, Boolean> recipeFilter, Function<T, RecipeDisplay> mappingFunction) {
        this.recipeFunctions.add(new RecipeFunction(category, recipeFilter::apply, mappingFunction));
    }

    public <T extends class_1860<?>> void registerRecipes(class_2960 category, Predicate<class_1860> recipeFilter, Function<T, RecipeDisplay> mappingFunction) {
        this.recipeFunctions.add(new RecipeFunction(category, recipeFilter, mappingFunction));
    }

    public void registerLiveRecipeGenerator(LiveRecipeGenerator<?> liveRecipeGenerator) {
        this.liveRecipeGenerators.add(liveRecipeGenerator);
    }

    public List<RecipeHelper.ScreenClickArea> getScreenClickAreas() {
        return this.screenClickAreas;
    }

    private static class RecipeFunction {
        private class_2960 category;
        private Predicate<class_1860> recipeFilter;
        private Function mappingFunction;

        public RecipeFunction(class_2960 category, Predicate<class_1860> recipeFilter, Function<?, RecipeDisplay> mappingFunction) {
            this.category = category;
            this.recipeFilter = recipeFilter;
            this.mappingFunction = mappingFunction;
        }
    }

    private static class ScreenClickAreaImpl
    implements RecipeHelper.ScreenClickArea {
        private Class<? extends class_465<?>> screenClass;
        private Rectangle rectangle;
        private class_2960[] categories;

        private ScreenClickAreaImpl(Class<? extends class_465<?>> screenClass, Rectangle rectangle, class_2960[] categories) {
            this.screenClass = screenClass;
            this.rectangle = rectangle;
            this.categories = categories;
        }

        public Class<? extends class_465<?>> getScreenClass() {
            return this.screenClass;
        }

        public Rectangle getRectangle() {
            return this.rectangle;
        }

        public class_2960[] getCategories() {
            return this.categories;
        }
    }
}

