/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.BaseBoundsHandler;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.gui.config.DisplayPanelLocation;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;

import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;

@ApiStatus.Internal
@Environment(EnvType.CLIENT)
public class BaseBoundsHandlerImpl implements BaseBoundsHandler {
    
    private static final Comparator<? super Rectangle> RECTANGLE_COMPARER = Comparator.comparingLong(Rectangle::hashCode);
    
    private long lastArea = -1;
    private List<class_3545<class_3545<Class<?>, Float>, Supplier<List<Rectangle>>>> list = Lists.newArrayList();
    
    @Override
    public boolean isHandingScreen(Class<?> screen) {
        return class_437.class.isAssignableFrom(screen);
    }
    
    @Override
    public float getPriority() {
        return -5f;
    }
    
    @Override
    public class_1269 isInZone(double mouseX, double mouseY) {
        Class<? extends class_437> screenClass = class_310.method_1551().field_1755.getClass();
        for (class_3545<class_3545<Class<?>, Float>, Supplier<List<Rectangle>>> pair : list) {
            if (pair.method_15442().method_15442().isAssignableFrom(screenClass))
                for (Rectangle zone : pair.method_15441().get())
                    if (zone.contains(mouseX, mouseY))
                        return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }
    
    @Override
    public boolean shouldRecalculateArea(DisplayPanelLocation location, Rectangle rectangle) {
        long current = currentHashCode(location);
        if (lastArea == current)
            return false;
        lastArea = current;
        return true;
    }
    
    private long currentHashCode(DisplayPanelLocation location) {
        return areasHashCode(DisplayHelper.getInstance().getOverlayBounds(location, class_310.method_1551().field_1755), getExclusionZones(class_310.method_1551().field_1755.getClass(), false));
    }
    
    @Override
    public List<Rectangle> getExclusionZones(Class<?> currentScreenClass, boolean sort) {
        List<Rectangle> rectangles = Lists.newArrayList();
        for (class_3545<class_3545<Class<?>, Float>, Supplier<List<Rectangle>>> pair : list) {
            if (pair.method_15442().method_15442().isAssignableFrom(currentScreenClass))
                rectangles.addAll(pair.method_15441().get());
        }
        if (sort)
            rectangles.sort(RECTANGLE_COMPARER);
        return rectangles;
    }
    
    @Override
    public int supplierSize() {
        return list.size();
    }
    
    @Override
    public void registerExclusionZones(Class<?> screenClass, Supplier<List<Rectangle>> supplier) {
        list.add(new class_3545<>(new class_3545<>(screenClass, 0f), supplier));
    }
    
    private long areasHashCode(Rectangle rectangle, List<Rectangle> exclusionZones) {
        int hashCode = 31 + (rectangle == null ? 0 : rectangle.hashCode());
        for (Rectangle e : exclusionZones)
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        return hashCode;
    }
    
}
