/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3545;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RoughlyEnoughItemsState {
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"REI");
    private static List<class_3545<String, String>> errors = new ArrayList<class_3545<String, String>>();
    private static List<class_3545<String, String>> warnings = new ArrayList<class_3545<String, String>>();
    private static Set<String> errorSet = new LinkedHashSet<String>();
    private static Set<String> warningSet = new LinkedHashSet<String>();
    private static List<Runnable> continueCallbacks = new ArrayList<Runnable>();

    private RoughlyEnoughItemsState() {
    }

    public static void error(String reason) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER || FabricLoader.getInstance().isDevelopmentEnvironment()) {
            throw new RuntimeException(reason);
        }
        if (errorSet.add(reason + " " + null)) {
            errors.add((class_3545<String, String>)new class_3545((Object)reason, null));
            LOGGER.error(reason);
        }
    }

    public static void error(String reason, String link) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER || FabricLoader.getInstance().isDevelopmentEnvironment()) {
            throw new RuntimeException(reason + " " + link);
        }
        if (errorSet.add(reason + " " + link)) {
            errors.add((class_3545<String, String>)new class_3545((Object)reason, (Object)link));
            LOGGER.error(reason + " " + link);
        }
    }

    public static void warn(String reason) {
        if (warningSet.add(reason + " " + null)) {
            warnings.add((class_3545<String, String>)new class_3545((Object)reason, null));
            LOGGER.warn(reason);
        }
    }

    public static void warn(String reason, String link) {
        if (warningSet.add(reason + " " + link)) {
            warnings.add((class_3545<String, String>)new class_3545((Object)reason, (Object)link));
            LOGGER.warn(reason + " " + link);
        }
    }

    public static void onContinue(Runnable runnable) {
        continueCallbacks.add(runnable);
    }

    public static List<class_3545<String, String>> getErrors() {
        return errors;
    }

    public static List<class_3545<String, String>> getWarnings() {
        return warnings;
    }

    public static void clear() {
        errors.clear();
        errorSet.clear();
        warnings.clear();
        warningSet.clear();
    }

    public static void continues() {
        for (Runnable callback : continueCallbacks) {
            try {
                callback.run();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        continueCallbacks.clear();
    }
}

