/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.impl.AmountIgnoredEntryStackWrapper;
import me.shedaniel.rei.impl.ConfigObjectImpl;
import me.shedaniel.rei.impl.filtering.FilteringContextImpl;
import me.shedaniel.rei.impl.filtering.FilteringRule;
import me.shedaniel.rei.utils.CollectionUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EntryRegistryImpl
implements EntryRegistry {
    private final List<EntryStack> preFilteredList = Lists.newCopyOnWriteArrayList();
    private final List<EntryStack> entries = Lists.newCopyOnWriteArrayList();
    private final List<AmountIgnoredEntryStackWrapper> reloadingRegistry = Lists.newArrayList();
    private boolean reloading;

    private static EntryStack findFirstOrNullEqualsEntryIgnoreAmount(Collection<EntryStack> list, EntryStack obj) {
        for (EntryStack t : list) {
            if (!t.equalsIgnoreAmount(obj)) continue;
            return t;
        }
        return null;
    }

    public void finishReload() {
        this.reloading = false;
        this.preFilteredList.clear();
        this.reloadingRegistry.removeIf(AmountIgnoredEntryStackWrapper::isEmpty);
        this.entries.clear();
        this.entries.addAll(CollectionUtils.map(this.reloadingRegistry, AmountIgnoredEntryStackWrapper::unwrap));
        this.reloadingRegistry.clear();
    }

    public @NotNull Stream<EntryStack> getEntryStacks() {
        return this.entries.stream();
    }

    public @NotNull List<EntryStack> getPreFilteredList() {
        return this.preFilteredList;
    }

    public void refilter() {
        long started = System.currentTimeMillis();
        FilteringContextImpl context = new FilteringContextImpl(this.entries);
        List<FilteringRule<?>> rules = ((ConfigObjectImpl)ConfigObject.getInstance()).getFilteringRules();
        for (int i = rules.size() - 1; i >= 0; --i) {
            context.handleResult(rules.get(i).processFilteredStacks(context));
        }
        Set set = (Set)CollectionUtils.mapParallel(this.entries, AmountIgnoredEntryStackWrapper::new, Sets::newLinkedHashSet);
        set.removeAll(CollectionUtils.mapParallel(context.getHiddenStacks(), AmountIgnoredEntryStackWrapper::new, Sets::newHashSet));
        this.preFilteredList.clear();
        this.preFilteredList.addAll(CollectionUtils.mapParallel((Collection)set, AmountIgnoredEntryStackWrapper::unwrap));
        long time = System.currentTimeMillis() - started;
        RoughlyEnoughItemsCore.LOGGER.info("Refiltered %d entries with %d rules in %dms.", (Object)(this.entries.size() - this.preFilteredList.size()), (Object)rules.size(), (Object)time);
    }

    public void reset() {
        this.entries.clear();
        this.reloadingRegistry.clear();
        this.preFilteredList.clear();
        this.reloading = true;
    }

    public @NotNull List<class_1799> appendStacksForItem(@NotNull class_1792 item) {
        class_2371 list = class_2371.method_10211();
        item.method_7850(item.method_7859(), list);
        if (list.isEmpty()) {
            return Collections.singletonList(item.method_7854());
        }
        return list;
    }

    public @NotNull class_1799[] getAllStacksFromItem(@NotNull class_1792 item) {
        List<class_1799> list = this.appendStacksForItem(item);
        class_1799[] array = list.toArray(new class_1799[0]);
        Arrays.sort(array, (a, b) -> class_1799.method_7973((class_1799)a, (class_1799)b) ? 0 : 1);
        return array;
    }

    public void registerEntryAfter(@Nullable EntryStack afterEntry, @NotNull EntryStack stack) {
        if (this.reloading) {
            int index;
            int n = index = afterEntry != null ? this.reloadingRegistry.lastIndexOf(new AmountIgnoredEntryStackWrapper(afterEntry)) : -1;
            if (index >= 0) {
                this.reloadingRegistry.add(index, new AmountIgnoredEntryStackWrapper(stack));
            } else {
                this.reloadingRegistry.add(new AmountIgnoredEntryStackWrapper(stack));
            }
        } else if (afterEntry != null) {
            int index = this.entries.lastIndexOf(afterEntry);
            this.entries.add(index, stack);
        } else {
            this.entries.add(stack);
        }
    }

    public void registerEntriesAfter(@Nullable EntryStack afterEntry, @NotNull @NotNull Collection<@NotNull ? extends EntryStack> stacks) {
        if (this.reloading) {
            int index;
            int n = index = afterEntry != null ? this.reloadingRegistry.lastIndexOf(new AmountIgnoredEntryStackWrapper(afterEntry)) : -1;
            if (index >= 0) {
                this.reloadingRegistry.addAll(index, CollectionUtils.map(stacks, AmountIgnoredEntryStackWrapper::new));
            } else {
                this.reloadingRegistry.addAll(CollectionUtils.map(stacks, AmountIgnoredEntryStackWrapper::new));
            }
        } else if (afterEntry != null) {
            int index = this.entries.lastIndexOf(afterEntry);
            this.entries.addAll(index, stacks);
        } else {
            this.entries.addAll(stacks);
        }
    }

    public boolean alreadyContain(EntryStack stack) {
        if (this.reloading) {
            return this.reloadingRegistry.parallelStream().anyMatch(s -> s.unwrap().equalsAll(stack));
        }
        return this.entries.parallelStream().anyMatch(s -> s.equalsAll(stack));
    }

    public void removeEntry(EntryStack stack) {
        if (this.reloading) {
            this.reloadingRegistry.remove(new AmountIgnoredEntryStackWrapper(stack));
        } else {
            this.entries.remove(stack);
        }
    }

    public void removeEntryIf(Predicate<EntryStack> stackPredicate) {
        if (this.reloading) {
            this.reloadingRegistry.removeIf(wrapper -> stackPredicate.test(wrapper.unwrap()));
        } else {
            this.entries.removeIf(stackPredicate);
        }
    }
}

