/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.search;

import java.util.Objects;
import me.shedaniel.rei.impl.search.MatchType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MatchStatus {
    private static final MatchStatus UNMATCHED = new MatchStatus(MatchType.UNMATCHED, null, false);
    private final MatchType type;
    private final @Nullable String text;
    private final boolean preserveCasing;

    private MatchStatus(MatchType type, @Nullable String text, boolean preserveCasing) {
        this.type = type;
        this.text = text;
        this.preserveCasing = preserveCasing;
    }

    public static MatchStatus unmatched() {
        return UNMATCHED;
    }

    public static MatchStatus invertMatched(@NotNull String text) {
        return MatchStatus.invertMatched(text, false);
    }

    public static MatchStatus invertMatched(@NotNull String text, boolean preserveCasing) {
        return new MatchStatus(MatchType.INVERT_MATCHED, Objects.requireNonNull(text), preserveCasing);
    }

    public static MatchStatus matched(@NotNull String text) {
        return MatchStatus.matched(text, false);
    }

    public static MatchStatus matched(@NotNull String text, boolean preserveCasing) {
        return new MatchStatus(MatchType.MATCHED, Objects.requireNonNull(text), preserveCasing);
    }

    public boolean isMatched() {
        return this.type != MatchType.UNMATCHED;
    }

    public boolean isInverted() {
        return this.type == MatchType.INVERT_MATCHED;
    }

    public boolean shouldPreserveCasing() {
        return this.preserveCasing;
    }

    public @Nullable String getText() {
        return this.text;
    }

    public MatchType getType() {
        return this.type;
    }
}

