/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.filtering;

import com.mojang.serialization.Lifecycle;
import me.shedaniel.rei.gui.config.entry.FilteringEntry;
import me.shedaniel.rei.impl.filtering.rules.ManualFilteringRule;
import me.shedaniel.rei.impl.filtering.rules.SearchFilteringRule;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

import java.util.Optional;
import java.util.function.BiFunction;

@ApiStatus.Internal
@ApiStatus.Experimental
@Environment(EnvType.CLIENT)
public interface FilteringRule<T extends FilteringRule<?>> {
    class_5321<class_2378<FilteringRule<?>>> REGISTRY_KEY = class_5321.method_29180(new class_2960("roughlyenoughitems", "filtering_rule"));
    class_2378<FilteringRule<?>> REGISTRY = createRegistry();
    
    @ApiStatus.Internal
    static class_2378<FilteringRule<?>> createRegistry() {
        class_2370<FilteringRule<?>> registry = new class_2370<>(REGISTRY_KEY, Lifecycle.stable());
        class_2378.method_10230(registry, new class_2960("roughlyenoughitems", "search"), new SearchFilteringRule());
        class_2378.method_10230(registry, new class_2960("roughlyenoughitems", "manual"), new ManualFilteringRule());
        return registry;
    }
    
    static class_2487 toTag(FilteringRule<?> rule, class_2487 tag) {
        tag.method_10582("id", REGISTRY.method_10221(rule).toString());
        tag.method_10566("rule", rule.toTag(new class_2487()));
        return tag;
    }
    
    static FilteringRule<?> fromTag(class_2487 tag) {
        return REGISTRY.method_10223(class_2960.method_12829(tag.method_10558("id"))).createFromTag(tag.method_10562("rule"));
    }
    
    class_2487 toTag(class_2487 tag);
    
    T createFromTag(class_2487 tag);
    
    @NotNull
    FilteringResult processFilteredStacks(@NotNull FilteringContext context);
    
    @ApiStatus.Internal
    default Optional<BiFunction<FilteringEntry, class_437, class_437>> createEntryScreen() {
        return Optional.empty();
    }
    
    default class_2561 getTitle() {
        return class_2561.method_30163(FilteringRule.REGISTRY.method_10221(this).toString());
    }
    
    default class_2561 getSubtitle() {
        return class_2561.method_30163(null);
    }
    
    T createNew();
}
