/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.server;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.*;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class InputSlotCrafter<C extends class_1263> implements RecipeGridAligner<Integer>, ContainerContext {
    
    protected class_1703 container;
    protected ContainerInfo containerInfo;
    private List<StackAccessor> gridStacks;
    private List<StackAccessor> inventoryStacks;
    private class_3222 player;
    
    private InputSlotCrafter(class_1703 container, ContainerInfo<? extends class_1703> containerInfo) {
        this.container = container;
        this.containerInfo = containerInfo;
    }
    
    public static <C extends class_1263> void start(class_2960 category, class_1703 craftingContainer_1, class_3222 player, Map<Integer, List<class_1799>> map, boolean hasShift) {
        ContainerInfo<? extends class_1703> containerInfo = Objects.requireNonNull(ContainerInfoHandler.getContainerInfo(category, craftingContainer_1.getClass()), "Container Info does not exist on the server!");
        new InputSlotCrafter<C>(craftingContainer_1, containerInfo).fillInputSlots(player, map, hasShift);
    }
    
    private void fillInputSlots(class_3222 player, Map<Integer, List<class_1799>> map, boolean hasShift) {
        this.player = player;
        this.inventoryStacks = this.containerInfo.getInventoryStacks(this);
        this.gridStacks = this.containerInfo.getGridStacks(this);
        
        player.field_13991 = true;
        // Return the already placed items on the grid
        this.returnInputs();
        
        RecipeFinder recipeFinder = new RecipeFinder();
        this.containerInfo.getRecipeFinderPopulator().populate(this).accept(recipeFinder);
        class_2371<class_1856> ingredients = class_2371.method_10211();
        map.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).forEach(entry -> {
            ingredients.add(class_1856.method_8091(entry.getValue().stream().map(class_1799::method_7909).toArray(class_1792[]::new)));
        });
        
        if (recipeFinder.findRecipe(ingredients, null)) {
            this.fillInputSlots(recipeFinder, ingredients, hasShift);
        } else {
            this.returnInputs();
            player.field_13991 = false;
            this.containerInfo.markDirty(this);
            throw new NotEnoughMaterialsException();
        }
        
        player.field_13991 = false;
        this.containerInfo.markDirty(this);
    }
    
    @Override
    public void acceptAlignedInput(Iterator<Integer> iterator_1, StackAccessor gridSlot, int craftsAmount) {
        class_1799 toBeTakenStack = RecipeFinder.getStackFromId(iterator_1.next());
        if (!toBeTakenStack.method_7960()) {
            for (int i = 0; i < craftsAmount; ++i) {
                this.fillInputSlot(gridSlot, toBeTakenStack);
            }
        }
    }
    
    protected void fillInputSlot(StackAccessor slot, class_1799 toBeTakenStack) {
        int takenSlotIndex = this.method_7371(toBeTakenStack);
        if (takenSlotIndex != -1) {
            class_1799 takenStack = this.inventoryStacks.get(takenSlotIndex).getItemStack().method_7972();
            if (!takenStack.method_7960()) {
                if (takenStack.method_7947() > 1) {
                    this.inventoryStacks.get(takenSlotIndex).takeStack(1);
                } else {
                    this.inventoryStacks.get(takenSlotIndex).setItemStack(class_1799.field_8037);
                }
                
                takenStack.method_7939(1);
                if (slot.getItemStack().method_7960()) {
                    slot.setItemStack(takenStack);
                } else {
                    slot.getItemStack().method_7933(1);
                }
            }
        }
    }
    
    protected void fillInputSlots(RecipeFinder recipeFinder, class_2371<class_1856> ingredients, boolean hasShift) {
        int recipeCrafts = recipeFinder.countRecipeCrafts(ingredients, null);
        int amountToFill = this.getAmountToFill(hasShift, recipeCrafts, false);
        IntList intList_1 = new IntArrayList();
        if (recipeFinder.findRecipe(ingredients, intList_1, amountToFill)) {
            int finalCraftsAmount = amountToFill;
            
            for (int itemId : intList_1) {
                finalCraftsAmount = Math.min(finalCraftsAmount, RecipeFinder.getStackFromId(itemId).method_7914());
            }
            
            if (recipeFinder.findRecipe(ingredients, intList_1, finalCraftsAmount)) {
                this.returnInputs();
                this.alignRecipeToGrid(gridStacks, intList_1.iterator(), finalCraftsAmount);
            }
        }
        
    }
    
    protected int getAmountToFill(boolean hasShift, int recipeCrafts, boolean boolean_2) {
        int amountToFill = 1;
        if (hasShift) {
            amountToFill = recipeCrafts;
        } else if (boolean_2) {
            amountToFill = 64;
            for (StackAccessor stackAccessor : gridStacks) {
                class_1799 itemStack = stackAccessor.getItemStack();
                if (!itemStack.method_7960() && amountToFill > itemStack.method_7947()) {
                    amountToFill = itemStack.method_7947();
                }
            }
            if (amountToFill < 64) {
                ++amountToFill;
            }
        }
        return amountToFill;
    }
    
    protected void returnInputs() {
        this.containerInfo.getGridCleanHandler().clean(this);
    }
    
    public int method_7371(class_1799 itemStack) {
        for (int i = 0; i < inventoryStacks.size(); i++) {
            class_1799 itemStack1 = this.inventoryStacks.get(i).getItemStack();
            if (!itemStack1.method_7960() && areItemsEqual(itemStack, itemStack1) && !itemStack1.method_7986() && !itemStack1.method_7942() && !itemStack1.method_7938()) {
                return i;
            }
        }
        
        return -1;
    }
    
    private static boolean areItemsEqual(class_1799 stack1, class_1799 stack2) {
        return stack1.method_7909() == stack2.method_7909() && class_1799.method_7975(stack1, stack2);
    }
    
    private int getFreeInventorySlots() {
        int int_1 = 0;
        for (StackAccessor inventoryStack : inventoryStacks) {
            if (inventoryStack.getItemStack().method_7960()) {
                ++int_1;
            }
        }
        return int_1;
    }
    
    @Override
    public class_1703 getContainer() {
        return container;
    }
    
    @Override
    public class_1657 getPlayerEntity() {
        return player;
    }
    
    @Override
    public ContainerInfo getContainerInfo() {
        return containerInfo;
    }
    
    public static class NotEnoughMaterialsException extends RuntimeException {}
    
}
