/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.widgets.Slot;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.widget.FavoritesListWidget;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntryWidget
extends Slot {
    protected static final class_2960 RECIPE_GUI = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    protected static final class_2960 RECIPE_GUI_DARK = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer_dark.png");
    private byte noticeMark = 0;
    protected boolean highlight = true;
    protected boolean tooltips = true;
    protected boolean background = true;
    protected boolean interactable = true;
    protected boolean interactableFavorites = true;
    protected boolean wasClicked = false;
    private Rectangle bounds;
    private List<EntryStack> entryStacks;

    protected EntryWidget(int x, int y) {
        this(new Point(x, y));
    }

    protected EntryWidget(Point point) {
        this.bounds = new Rectangle(point.x - 1, point.y - 1, 18, 18);
        this.entryStacks = new ArrayList<EntryStack>();
    }

    @Deprecated
    public static @NotNull EntryWidget create(int x, int y) {
        return EntryWidget.create(new Point(x, y));
    }

    @Deprecated
    public static @NotNull EntryWidget create(Point point) {
        return new EntryWidget(point);
    }

    public @NotNull EntryWidget unmarkInputOrOutput() {
        this.noticeMark = 0;
        return this;
    }

    public EntryWidget markIsInput() {
        this.noticeMark = 1;
        return this;
    }

    public EntryWidget markIsOutput() {
        this.noticeMark = (byte)2;
        return this;
    }

    public byte getNoticeMark() {
        return this.noticeMark;
    }

    public void setNoticeMark(byte noticeMark) {
        this.noticeMark = noticeMark;
    }

    public void setInteractable(boolean interactable) {
        this.interactable(interactable);
    }

    public boolean isInteractable() {
        return this.interactable;
    }

    public void setInteractableFavorites(boolean interactableFavorites) {
        this.interactableFavorites(interactableFavorites);
    }

    public boolean isInteractableFavorites() {
        return this.interactableFavorites;
    }

    public EntryWidget disableInteractions() {
        return this.interactable(false);
    }

    public @NotNull EntryWidget interactable(boolean b) {
        this.interactable = b;
        this.interactableFavorites = this.interactableFavorites && this.interactable;
        return this;
    }

    public EntryWidget disableFavoritesInteractions() {
        return this.interactableFavorites(false);
    }

    public @NotNull EntryWidget interactableFavorites(boolean b) {
        this.interactableFavorites = b && this.interactable;
        return this;
    }

    public EntryWidget noHighlight() {
        return this.highlight(false);
    }

    public EntryWidget highlight(boolean b) {
        this.highlight = b;
        return this;
    }

    public boolean isHighlightEnabled() {
        return this.highlight;
    }

    public void setHighlightEnabled(boolean highlights) {
        this.highlight(highlights);
    }

    public EntryWidget noTooltips() {
        return this.tooltips(false);
    }

    public EntryWidget tooltips(boolean b) {
        this.tooltips = b;
        return this;
    }

    public void setTooltipsEnabled(boolean tooltipsEnabled) {
        this.tooltips(tooltipsEnabled);
    }

    public boolean isTooltipsEnabled() {
        return this.tooltips;
    }

    public EntryWidget noBackground() {
        return this.background(false);
    }

    public EntryWidget background(boolean b) {
        this.background = b;
        return this;
    }

    public void setBackgroundEnabled(boolean backgroundEnabled) {
        this.background(backgroundEnabled);
    }

    public boolean isBackgroundEnabled() {
        return this.background;
    }

    public EntryWidget clearStacks() {
        this.entryStacks.clear();
        return this;
    }

    public @NotNull Slot clearEntries() {
        return this.clearStacks();
    }

    public @NotNull EntryWidget entry(EntryStack stack) {
        this.entryStacks.add(stack);
        return this;
    }

    public @NotNull EntryWidget entries(Collection<EntryStack> stacks) {
        this.entryStacks.addAll(stacks);
        return this;
    }

    protected EntryStack getCurrentEntry() {
        if (this.entryStacks.isEmpty()) {
            return EntryStack.empty();
        }
        if (this.entryStacks.size() == 1) {
            return this.entryStacks.get(0);
        }
        return this.entryStacks.get(class_3532.method_15357((double)((double)(System.currentTimeMillis() / 500L) % (double)this.entryStacks.size() / 1.0)));
    }

    public @NotNull List<EntryStack> getEntries() {
        return this.entryStacks;
    }

    public List<EntryStack> entries() {
        return this.entryStacks;
    }

    public @NotNull Rectangle getBounds() {
        return this.bounds;
    }

    protected Rectangle getInnerBounds() {
        return new Rectangle(this.bounds.x + 1, this.bounds.y + 1, this.bounds.width - 2, this.bounds.height - 2);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.drawBackground(matrices, mouseX, mouseY, delta);
        this.drawCurrentEntry(matrices, mouseX, mouseY, delta);
        boolean highlighted = this.containsMouse(mouseX, mouseY);
        if (this.hasTooltips() && highlighted) {
            this.queueTooltip(matrices, mouseX, mouseY, delta);
        }
        if (this.hasHighlight() && highlighted) {
            this.drawHighlighted(matrices, mouseX, mouseY, delta);
        }
    }

    public final boolean hasTooltips() {
        return this.tooltips;
    }

    public final boolean hasHighlight() {
        return this.highlight;
    }

    protected void drawBackground(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.background) {
            this.minecraft.method_1531().method_22813(REIHelper.getInstance().isDarkThemeEnabled() ? RECIPE_GUI_DARK : RECIPE_GUI);
            this.method_25302(matrices, this.bounds.x, this.bounds.y, 0, 222, this.bounds.width, this.bounds.height);
        }
    }

    protected void drawCurrentEntry(class_4587 matrices, int mouseX, int mouseY, float delta) {
        EntryStack entry = this.getCurrentEntry();
        entry.setZ(100);
        entry.render(matrices, this.getInnerBounds(), mouseX, mouseY, delta);
    }

    protected void queueTooltip(class_4587 matrices, int mouseX, int mouseY, float delta) {
        Tooltip tooltip = this.getCurrentTooltip(new Point(mouseX, mouseY));
        if (tooltip != null) {
            if (this.interactableFavorites && ConfigObject.getInstance().doDisplayFavoritesTooltip() && !ConfigObject.getInstance().getFavoriteKeyCode().isUnknown()) {
                String name = ConfigObject.getInstance().getFavoriteKeyCode().getLocalizedName().getString();
                if (this.reverseFavoritesAction()) {
                    tooltip.getText().addAll(Stream.of(class_1074.method_4662((String)"text.rei.remove_favorites_tooltip", (Object[])new Object[]{name}).split("\n")).map(class_2585::new).collect(Collectors.toList()));
                } else {
                    tooltip.getText().addAll(Stream.of(class_1074.method_4662((String)"text.rei.favorites_tooltip", (Object[])new Object[]{name}).split("\n")).map(class_2585::new).collect(Collectors.toList()));
                }
            }
            tooltip.queue();
        }
    }

    public @Nullable Tooltip getCurrentTooltip(Point point) {
        return this.getCurrentEntry().getTooltip(point);
    }

    protected void drawHighlighted(class_4587 matrices, int mouseX, int mouseY, float delta) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        int color = REIHelper.getInstance().isDarkThemeEnabled() ? -1877929711 : -2130706433;
        this.setZ(300);
        Rectangle bounds = this.getInnerBounds();
        this.method_25296(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), color, color);
        this.setZ(0);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }

    protected boolean wasClicked() {
        boolean b = this.wasClicked;
        this.wasClicked = false;
        return b;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.containsMouse(mouseX, mouseY)) {
            this.wasClicked = true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (!this.interactable) {
            return false;
        }
        if (this.wasClicked() && this.containsMouse(mouseX, mouseY)) {
            if (this.interactableFavorites && ConfigObject.getInstance().isFavoritesEnabled() && this.containsMouse(PointHelper.ofMouse()) && !this.getCurrentEntry().isEmpty()) {
                ModifierKeyCode keyCode = ConfigObject.getInstance().getFavoriteKeyCode();
                EntryStack entry = this.getCurrentEntry().copy();
                entry.setAmount(127);
                if (keyCode.matchesMouse(button)) {
                    if (this.reverseFavoritesAction()) {
                        ConfigObject.getInstance().getFavorites().removeIf(arg_0 -> ((EntryStack)entry).equalsIgnoreAmount(arg_0));
                    } else if (!CollectionUtils.anyMatchEqualsEntryIgnoreAmount((List)ConfigObject.getInstance().getFavorites(), (EntryStack)entry)) {
                        ConfigObject.getInstance().getFavorites().add(entry);
                    }
                    ConfigManager.getInstance().saveConfig();
                    FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
                    if (favoritesListWidget != null) {
                        favoritesListWidget.updateSearch(ContainerScreenOverlay.getEntryListWidget(), ScreenHelper.getSearchField().getText());
                    }
                    return true;
                }
            }
            if (ConfigObject.getInstance().getRecipeKeybind().getType() != class_3675.class_307.field_1672 && button == 0 || ConfigObject.getInstance().getRecipeKeybind().matchesMouse(button)) {
                return ClientHelper.getInstance().openView(ClientHelper.ViewSearchBuilder.builder().addRecipesFor(this.getCurrentEntry()).setOutputNotice(this.getCurrentEntry()).fillPreferredOpenedCategory());
            }
            if (ConfigObject.getInstance().getUsageKeybind().getType() != class_3675.class_307.field_1672 && button == 1 || ConfigObject.getInstance().getUsageKeybind().matchesMouse(button)) {
                return ClientHelper.getInstance().openView(ClientHelper.ViewSearchBuilder.builder().addUsagesFor(this.getCurrentEntry()).setInputNotice(this.getCurrentEntry()).fillPreferredOpenedCategory());
            }
        }
        return false;
    }

    protected boolean cancelDeleteItems(EntryStack stack) {
        return false;
    }

    protected boolean reverseFavoritesAction() {
        return false;
    }

    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (!this.interactable) {
            return false;
        }
        if (this.containsMouse(PointHelper.ofMouse())) {
            if (this.interactableFavorites && ConfigObject.getInstance().isFavoritesEnabled() && this.containsMouse(PointHelper.ofMouse()) && !this.getCurrentEntry().isEmpty()) {
                ModifierKeyCode keyCode = ConfigObject.getInstance().getFavoriteKeyCode();
                EntryStack entry = this.getCurrentEntry().copy();
                entry.setAmount(127);
                if (keyCode.matchesKey(int_1, int_2)) {
                    if (this.reverseFavoritesAction()) {
                        ConfigObject.getInstance().getFavorites().removeIf(arg_0 -> ((EntryStack)entry).equalsIgnoreAmount(arg_0));
                    } else if (!CollectionUtils.anyMatchEqualsEntryIgnoreAmount((List)ConfigObject.getInstance().getFavorites(), (EntryStack)entry)) {
                        ConfigObject.getInstance().getFavorites().add(entry);
                    }
                    ConfigManager.getInstance().saveConfig();
                    FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
                    if (favoritesListWidget != null) {
                        favoritesListWidget.updateSearch(ContainerScreenOverlay.getEntryListWidget(), ScreenHelper.getSearchField().getText());
                    }
                    return true;
                }
            }
            if (ConfigObject.getInstance().getRecipeKeybind().matchesKey(int_1, int_2)) {
                return ClientHelper.getInstance().openView(ClientHelper.ViewSearchBuilder.builder().addRecipesFor(this.getCurrentEntry()).setOutputNotice(this.getCurrentEntry()).fillPreferredOpenedCategory());
            }
            if (ConfigObject.getInstance().getUsageKeybind().matchesKey(int_1, int_2)) {
                return ClientHelper.getInstance().openView(ClientHelper.ViewSearchBuilder.builder().addUsagesFor(this.getCurrentEntry()).setInputNotice(this.getCurrentEntry()).fillPreferredOpenedCategory());
            }
        }
        return false;
    }
}

