/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.fractions.Fraction;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.impl.AbstractEntryStack;
import me.shedaniel.rei.impl.SimpleFluidRenderer;
import me.shedaniel.rei.utils.CollectionUtils;
import me.shedaniel.rei.utils.FormattingUtils;
import me.shedaniel.rei.utils.ImmutableLiteralText;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1074;
import net.minecraft.class_1159;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidEntryStack
extends AbstractEntryStack {
    private static final Fraction IGNORE_AMOUNT = Fraction.of((long)ThreadLocalRandom.current().nextLong(), (long)ThreadLocalRandom.current().nextLong(Long.MAX_VALUE)).simplify();
    private class_3611 fluid;
    private Fraction amount;
    private int hashIgnoreAmount;
    private int hash;

    public FluidEntryStack(class_3611 fluid) {
        this(fluid, IGNORE_AMOUNT);
    }

    public FluidEntryStack(class_3611 fluid, Fraction amount) {
        this.fluid = fluid;
        this.amount = amount;
        this.rehash();
    }

    private void rehash() {
        this.hashIgnoreAmount = 31 + this.getType().ordinal();
        this.hashIgnoreAmount = 31 * this.hashIgnoreAmount + this.fluid.hashCode();
        this.hash = 31 * this.hashIgnoreAmount + this.amount.hashCode();
    }

    public Optional<class_2960> getIdentifier() {
        return Optional.ofNullable(class_2378.field_11154.method_10221((Object)this.getFluid()));
    }

    public EntryStack.Type getType() {
        return EntryStack.Type.FLUID;
    }

    public Fraction getAccurateAmount() {
        return this.amount;
    }

    public void setAmount(Fraction amount) {
        Fraction fraction = this.amount = amount.equals((Object)IGNORE_AMOUNT) ? IGNORE_AMOUNT : this.max(amount, Fraction.empty());
        if (this.isEmpty()) {
            this.fluid = class_3612.field_15906;
        }
        this.rehash();
    }

    private <T extends Comparable<T>> T max(T o1, T o2) {
        return o1.compareTo(o2) > 0 ? o1 : o2;
    }

    public boolean isEmpty() {
        return !this.amount.equals((Object)IGNORE_AMOUNT) && !this.amount.isGreaterThan(Fraction.empty()) || this.fluid == class_3612.field_15906;
    }

    public EntryStack copy() {
        EntryStack stack = EntryStack.create((class_3611)this.fluid, (Fraction)this.amount);
        for (Map.Entry<EntryStack.Settings<?>, Object> entry : this.getSettings().entrySet()) {
            stack.setting(entry.getKey(), entry.getValue());
        }
        return stack;
    }

    public Object getObject() {
        return this.fluid;
    }

    public boolean equalsIgnoreTagsAndAmount(EntryStack stack) {
        if (stack.getType() == EntryStack.Type.ITEM) {
            return this.equalsIgnoreTagsAndAmount(EntryStack.copyItemToFluid((EntryStack)stack));
        }
        if (stack.getType() != EntryStack.Type.FLUID) {
            return false;
        }
        return this.fluid == stack.getFluid();
    }

    public boolean equalsIgnoreTags(EntryStack stack) {
        if (stack.getType() == EntryStack.Type.ITEM) {
            return this.equalsIgnoreTags(EntryStack.copyItemToFluid((EntryStack)stack));
        }
        if (stack.getType() != EntryStack.Type.FLUID) {
            return false;
        }
        return this.fluid == stack.getFluid() && (this.amount.equals((Object)IGNORE_AMOUNT) || stack.getAccurateAmount().equals((Object)IGNORE_AMOUNT) || this.amount.equals((Object)stack.getAccurateAmount()));
    }

    public boolean equalsIgnoreAmount(EntryStack stack) {
        if (stack.getType() == EntryStack.Type.ITEM) {
            return this.equalsIgnoreAmount(EntryStack.copyItemToFluid((EntryStack)stack));
        }
        if (stack.getType() != EntryStack.Type.FLUID) {
            return false;
        }
        return this.fluid == stack.getFluid();
    }

    public boolean equalsAll(EntryStack stack) {
        if (stack.getType() != EntryStack.Type.FLUID) {
            return false;
        }
        return this.fluid == stack.getFluid() && (this.amount.equals((Object)IGNORE_AMOUNT) || stack.getAccurateAmount().equals((Object)IGNORE_AMOUNT) || this.amount.equals((Object)stack.getAccurateAmount()));
    }

    public int hashOfAll() {
        return this.hash;
    }

    public int hashIgnoreAmountAndTags() {
        return this.hashIgnoreAmount;
    }

    public int hashIgnoreTags() {
        return this.hash;
    }

    public int hashIgnoreAmount() {
        return this.hashIgnoreAmount;
    }

    public @Nullable Tooltip getTooltip(Point point) {
        String amountTooltip;
        if (!((Boolean)((Supplier)this.get(EntryStack.Settings.TOOLTIP_ENABLED)).get()).booleanValue() || this.isEmpty()) {
            return null;
        }
        ArrayList toolTip = Lists.newArrayList((Object[])new class_2561[]{this.asFormattedText()});
        if (!this.amount.isLessThan(Fraction.empty()) && (amountTooltip = (String)((Function)this.get(EntryStack.Settings.Fluid.AMOUNT_TOOLTIP)).apply(this)) != null) {
            toolTip.addAll(Stream.of(amountTooltip.split("\n")).map(class_2585::new).collect(Collectors.toList()));
        }
        toolTip.addAll((Collection)((Function)this.get(EntryStack.Settings.TOOLTIP_APPEND_EXTRA)).apply(this));
        if (((Boolean)((Supplier)this.get(EntryStack.Settings.TOOLTIP_APPEND_MOD)).get()).booleanValue() && ConfigObject.getInstance().shouldAppendModNames()) {
            class_2960 id = class_2378.field_11154.method_10221((Object)this.fluid);
            String modId = ClientHelper.getInstance().getModFromIdentifier(id);
            boolean alreadyHasMod = false;
            for (class_2561 s : toolTip) {
                if (!FormattingUtils.stripFormatting((String)s.getString()).equalsIgnoreCase(modId)) continue;
                alreadyHasMod = true;
                break;
            }
            if (!alreadyHasMod) {
                toolTip.add(ClientHelper.getInstance().getFormattedModFromIdentifier(id));
            }
        }
        return Tooltip.create((Collection)toolTip);
    }

    public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
        SimpleFluidRenderer.FluidRenderingData renderingData;
        if (((Boolean)((Supplier)this.get(EntryStack.Settings.RENDER)).get()).booleanValue() && (renderingData = SimpleFluidRenderer.fromFluid(this.fluid)) != null) {
            class_1058 sprite = renderingData.getSprite();
            int color = renderingData.getColor();
            int a = 255;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            class_310.method_1551().method_1531().method_22813(class_1059.field_5275);
            class_289 tess = class_289.method_1348();
            class_287 bb = tess.method_1349();
            class_1159 matrix = matrices.method_23760().method_23761();
            bb.method_1328(7, class_290.field_1575);
            bb.method_22918(matrix, (float)bounds.getMaxX(), (float)bounds.y, (float)this.getZ()).method_22913(sprite.method_4577(), sprite.method_4593()).method_1336(r, g, b, a).method_1344();
            bb.method_22918(matrix, (float)bounds.x, (float)bounds.y, (float)this.getZ()).method_22913(sprite.method_4594(), sprite.method_4593()).method_1336(r, g, b, a).method_1344();
            bb.method_22918(matrix, (float)bounds.x, (float)bounds.getMaxY(), (float)this.getZ()).method_22913(sprite.method_4594(), sprite.method_4575()).method_1336(r, g, b, a).method_1344();
            bb.method_22918(matrix, (float)bounds.getMaxX(), (float)bounds.getMaxY(), (float)this.getZ()).method_22913(sprite.method_4577(), sprite.method_4575()).method_1336(r, g, b, a).method_1344();
            tess.method_1350();
        }
    }

    public @NotNull class_2561 asFormattedText() {
        class_2960 id = class_2378.field_11154.method_10221((Object)this.fluid);
        if (class_1074.method_4663((String)("block." + id.toString().replaceFirst(":", ".")))) {
            return new ImmutableLiteralText(class_1074.method_4662((String)("block." + id.toString().replaceFirst(":", ".")), (Object[])new Object[0]));
        }
        return new ImmutableLiteralText(CollectionUtils.mapAndJoinToString((Object[])id.method_12832().split("_"), StringUtils::capitalize, (String)" "));
    }
}

