/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.fractions.Fraction;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.impl.AbstractEntryStack;
import me.shedaniel.rei.impl.ItemStackHook;
import me.shedaniel.rei.impl.OptimalEntryStack;
import me.shedaniel.rei.utils.FormattingUtils;
import me.shedaniel.rei.utils.ImmutableLiteralText;
import net.minecraft.class_1059;
import net.minecraft.class_1074;
import net.minecraft.class_1087;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemEntryStack
extends AbstractEntryStack
implements OptimalEntryStack {
    private class_1799 itemStack;
    private static final ReferenceSet<class_1792> SEARCH_BLACKLISTED = new ReferenceOpenHashSet();

    public ItemEntryStack(class_1799 itemStack) {
        this.itemStack = itemStack;
    }

    public Optional<class_2960> getIdentifier() {
        return Optional.ofNullable(class_2378.field_11142.method_10221((Object)this.getItem()));
    }

    public EntryStack.Type getType() {
        return EntryStack.Type.ITEM;
    }

    public int getAmount() {
        return this.itemStack.method_7947();
    }

    public Fraction getAccurateAmount() {
        return Fraction.ofWhole((long)this.itemStack.method_7947());
    }

    public void setAmount(Fraction amount) {
        this.itemStack.method_7939(amount.intValue());
    }

    public void setFloatingAmount(double amount) {
        this.itemStack.method_7939(class_3532.method_15357((double)amount));
    }

    public boolean isEmpty() {
        return this.itemStack.method_7960();
    }

    public EntryStack copy() {
        EntryStack stack = EntryStack.create((class_1799)this.getItemStack().method_7972());
        for (Map.Entry<EntryStack.Settings<?>, Object> entry : this.getSettings().entrySet()) {
            stack.setting(entry.getKey(), entry.getValue());
        }
        return stack;
    }

    public Object getObject() {
        return this.itemStack;
    }

    private Boolean compareIfFluid(EntryStack stack, int type) {
        EntryStack fluid = EntryStack.copyItemToFluid((EntryStack)this);
        if (fluid.isEmpty()) {
            return null;
        }
        if (stack.getType() == EntryStack.Type.ITEM) {
            stack = EntryStack.copyItemToFluid((EntryStack)stack);
        }
        if (stack.isEmpty()) {
            return null;
        }
        switch (type) {
            case 0: {
                return fluid.equalsIgnoreTagsAndAmount(stack);
            }
            case 1: {
                return fluid.equalsIgnoreTags(stack);
            }
            case 2: {
                return fluid.equalsIgnoreAmount(stack);
            }
            case 3: {
                return fluid.equalsAll(stack);
            }
        }
        return null;
    }

    public boolean equalsIgnoreTagsAndAmount(EntryStack stack) {
        Boolean ifFluid = this.compareIfFluid(stack, 0);
        if (ifFluid != null) {
            return ifFluid;
        }
        if (stack.getType() != EntryStack.Type.ITEM) {
            return false;
        }
        return this.itemStack.method_7909() == stack.getItem();
    }

    public boolean equalsAll(EntryStack stack) {
        if (stack.getType() != EntryStack.Type.ITEM) {
            return false;
        }
        return this.itemStack.method_7909() == stack.getItem() && this.getAmount() != stack.getAmount() && class_1799.method_7975((class_1799)this.itemStack, (class_1799)stack.getItemStack());
    }

    public boolean equalsIgnoreAmount(EntryStack stack) {
        class_2487 o2;
        Boolean ifFluid = this.compareIfFluid(stack, 2);
        if (ifFluid != null) {
            return ifFluid;
        }
        if (stack.getType() != EntryStack.Type.ITEM) {
            return false;
        }
        if (this.itemStack.method_7909() != stack.getItem()) {
            return false;
        }
        class_1799 otherStack = stack.getItemStack();
        class_2487 o1 = this.itemStack.method_7969();
        return o1 == (o2 = otherStack.method_7969()) || o1 != null && o2 != null && this.equalsTagWithoutCount(o1, o2);
    }

    private boolean equalsTagWithoutCount(class_2487 o1, class_2487 o2) {
        int o1Size = 0;
        int o2Size = 0;
        for (String key : o1.method_10541()) {
            if (key.equals("Count")) continue;
            ++o1Size;
        }
        for (String key : o2.method_10541()) {
            if (key.equals("Count") || ++o2Size <= o1Size) continue;
            return false;
        }
        if (o1Size != o2Size) {
            return false;
        }
        try {
            for (String key : o1.method_10541()) {
                class_2520 otherValue;
                class_2520 value;
                if (key.equals("Count") || this.equalsTag(value = o1.method_10580(key), otherValue = o2.method_10580(key))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
        return true;
    }

    private boolean equalsTag(class_2520 tag, class_2520 otherTag) {
        if (tag == null || otherTag == null) {
            return tag == otherTag;
        }
        if (tag instanceof class_2499 && otherTag instanceof class_2499) {
            return this.equalsList((class_2499)tag, (class_2499)otherTag);
        }
        return tag.equals(otherTag);
    }

    private boolean equalsList(class_2499 listTag, class_2499 otherListTag) {
        if (listTag.size() != otherListTag.size()) {
            return false;
        }
        for (int i = 0; i < listTag.size(); ++i) {
            class_2520 otherValue;
            class_2520 value = listTag.method_10534(i);
            if (this.equalsTag(value, otherValue = otherListTag.method_10534(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreTags(EntryStack stack) {
        Boolean ifFluid = this.compareIfFluid(stack, 1);
        if (ifFluid != null) {
            return ifFluid;
        }
        if (stack.getType() != EntryStack.Type.ITEM) {
            return false;
        }
        if (this.itemStack.method_7909() != stack.getItem()) {
            return false;
        }
        return this.getAmount() == stack.getAmount();
    }

    public int hashOfAll() {
        int result = this.hashIgnoreAmount();
        result = 31 * result + this.itemStack.method_7947();
        return result;
    }

    public int hashIgnoreTags() {
        int result = this.hashIgnoreAmountAndTags();
        result = 31 * result + this.itemStack.method_7947();
        return result;
    }

    public int hashIgnoreAmount() {
        int result = this.hashIgnoreAmountAndTags();
        result = this.itemStack.method_7985() ? 31 * result + this.itemStack.method_7969().toString().hashCode() : 31 * result;
        return result;
    }

    public int hashIgnoreAmountAndTags() {
        int result = 1;
        result = 31 * result + this.itemStack.method_7909().hashCode();
        return result;
    }

    public @Nullable Tooltip getTooltip(Point point) {
        if (this.isEmpty() || !((Boolean)((Supplier)this.get(EntryStack.Settings.TOOLTIP_ENABLED)).get()).booleanValue()) {
            return null;
        }
        List<class_2561> toolTip = this.tryGetItemStackToolTip(true);
        toolTip.addAll((Collection)((Function)this.get(EntryStack.Settings.TOOLTIP_APPEND_EXTRA)).apply(this));
        if (((Boolean)((Supplier)this.get(EntryStack.Settings.TOOLTIP_APPEND_MOD)).get()).booleanValue() && ConfigObject.getInstance().shouldAppendModNames()) {
            String modId = ClientHelper.getInstance().getModFromItem(this.getItem());
            boolean alreadyHasMod = false;
            for (class_2561 s : toolTip) {
                if (!FormattingUtils.stripFormatting((String)s.getString()).equalsIgnoreCase(modId)) continue;
                alreadyHasMod = true;
                break;
            }
            if (!alreadyHasMod) {
                toolTip.add(ClientHelper.getInstance().getFormattedModFromItem(this.getItem()));
            }
        }
        return Tooltip.create(toolTip);
    }

    public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
        this.optimisedRenderStart(matrices, delta);
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        this.optimisedRenderBase(matrices, immediate, bounds, mouseX, mouseY, delta);
        immediate.method_22993();
        this.optimisedRenderOverlay(matrices, bounds, mouseX, mouseY, delta);
        this.optimisedRenderEnd(matrices, delta);
    }

    @Override
    public void optimisedRenderStart(class_4587 matrices, float delta) {
        this.optimisedRenderStart(matrices, delta, true);
    }

    public void optimisedRenderStart(class_4587 matrices, float delta, boolean isOptimised) {
        boolean sideLit;
        class_310.method_1551().method_1531().method_22813(class_1059.field_5275);
        class_310.method_1551().method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
        RenderSystem.pushMatrix();
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22523);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (isOptimised && !(sideLit = this.getModelFromStack(this.itemStack).method_24304())) {
            class_308.method_24210();
        }
    }

    @Override
    public void optimisedRenderEnd(class_4587 matrices, float delta) {
        this.optimisedRenderEnd(matrices, delta, true);
    }

    public void optimisedRenderEnd(class_4587 matrices, float delta, boolean isOptimised) {
        boolean sideLit;
        RenderSystem.enableDepthTest();
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        if (isOptimised && !(sideLit = this.getModelFromStack(this.itemStack).method_24304())) {
            class_308.method_24211();
        }
        RenderSystem.popMatrix();
    }

    private class_1087 getModelFromStack(class_1799 stack) {
        return class_310.method_1551().method_1480().method_4019(stack, null, null);
    }

    @Override
    public int groupingHash() {
        return 1738923 + (this.getModelFromStack(this.itemStack).method_24304() ? 1 : 0);
    }

    @Override
    public void optimisedRenderBase(class_4587 matrices, class_4597.class_4598 immediate, Rectangle bounds, int mouseX, int mouseY, float delta) {
        if (!this.isEmpty() && ((Boolean)((Supplier)this.get(EntryStack.Settings.RENDER)).get()).booleanValue()) {
            class_1799 stack = this.getItemStack();
            ((ItemStackHook)stack).rei_setRenderEnchantmentGlint((Boolean)((Supplier)this.get(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT)).get());
            matrices.method_22903();
            matrices.method_22904((double)bounds.getCenterX(), (double)bounds.getCenterY(), (double)(100.0f + (float)this.getZ()));
            matrices.method_22905((float)bounds.getWidth(), (float)(bounds.getWidth() + bounds.getHeight()) / -2.0f, (float)bounds.getHeight());
            class_310.method_1551().method_1480().method_23179(stack, class_809.class_811.field_4317, false, matrices, (class_4597)immediate, 0xF000F0, class_4608.field_21444, this.getModelFromStack(stack));
            matrices.method_22909();
            ((ItemStackHook)stack).rei_setRenderEnchantmentGlint(false);
        }
    }

    @Override
    public void optimisedRenderOverlay(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
        if (!this.isEmpty() && ((Boolean)((Supplier)this.get(EntryStack.Settings.RENDER)).get()).booleanValue()) {
            class_310.method_1551().method_1480().field_4730 = this.getZ();
            class_310.method_1551().method_1480().method_4022(class_310.method_1551().field_1772, this.getItemStack(), bounds.x, bounds.y, (Boolean)((Supplier)this.get(EntryStack.Settings.RENDER_COUNTS)).get() != false ? (String)((Function)this.get(EntryStack.Settings.COUNTS)).apply(this) : "");
            class_310.method_1551().method_1480().field_4730 = 0.0f;
        }
    }

    public @NotNull class_2561 asFormattedText() {
        if (!SEARCH_BLACKLISTED.contains((Object)this.itemStack.method_7909())) {
            try {
                return this.itemStack.method_7964();
            }
            catch (Throwable e) {
                e.printStackTrace();
                SEARCH_BLACKLISTED.add((Object)this.itemStack.method_7909());
            }
        }
        try {
            return new ImmutableLiteralText(class_1074.method_4662((String)("item." + class_2378.field_11142.method_10221((Object)this.itemStack.method_7909()).toString().replace(":", ".")), (Object[])new Object[0]));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new ImmutableLiteralText("ERROR");
        }
    }

    private List<class_2561> tryGetItemStackToolTip(boolean careAboutAdvanced) {
        if (!SEARCH_BLACKLISTED.contains((Object)this.itemStack.method_7909())) {
            try {
                return this.itemStack.method_7950((class_1657)class_310.method_1551().field_1724, (class_1836)(class_310.method_1551().field_1690.field_1827 && careAboutAdvanced ? class_1836.class_1837.field_8935 : class_1836.class_1837.field_8934));
            }
            catch (Throwable e) {
                e.printStackTrace();
                SEARCH_BLACKLISTED.add((Object)this.itemStack.method_7909());
            }
        }
        return Lists.newArrayList((Object[])new class_2561[]{this.asFormattedText()});
    }
}

