/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.autocrafting;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.AutoTransferHandler;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.TransferRecipeDisplay;
import me.shedaniel.rei.server.ContainerContext;
import me.shedaniel.rei.server.ContainerInfo;
import me.shedaniel.rei.server.ContainerInfoHandler;
import me.shedaniel.rei.server.RecipeFinder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_518;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class DefaultCategoryHandler
implements AutoTransferHandler {
    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull AutoTransferHandler.Result handle(@NotNull AutoTransferHandler.Context context) {
        if (!(context.getRecipe() instanceof TransferRecipeDisplay)) {
            return AutoTransferHandler.Result.createNotApplicable();
        }
        TransferRecipeDisplay recipe = (TransferRecipeDisplay)context.getRecipe();
        class_465 containerScreen = context.getContainerScreen();
        class_1703 container = context.getContainer();
        ContainerInfo containerInfo = ContainerInfoHandler.getContainerInfo((class_2960)recipe.getRecipeCategory(), container.getClass());
        if (containerInfo == null) {
            return AutoTransferHandler.Result.createNotApplicable();
        }
        if (recipe.getHeight() > containerInfo.getCraftingHeight(container) || recipe.getWidth() > containerInfo.getCraftingWidth(container)) {
            return AutoTransferHandler.Result.createFailed((String)class_1074.method_4662((String)"error.rei.transfer.too_small", (Object[])new Object[]{containerInfo.getCraftingWidth(container), containerInfo.getCraftingHeight(container)}));
        }
        List input = recipe.getOrganisedInputEntries(containerInfo, container);
        IntList intList = this.hasItems(container, (ContainerInfo<class_1703>)containerInfo, input);
        if (!intList.isEmpty()) {
            return AutoTransferHandler.Result.createFailed((String)"error.rei.not.enough.materials", (IntList)intList);
        }
        if (!ClientHelper.getInstance().canUseMovePackets()) {
            return AutoTransferHandler.Result.createFailed((String)"error.rei.not.on.server");
        }
        if (!context.isActuallyCrafting()) {
            return AutoTransferHandler.Result.createSuccessful();
        }
        context.getMinecraft().method_1507((class_437)containerScreen);
        if (containerScreen instanceof class_518) {
            ((class_518)containerScreen).method_2659().field_3092.method_2571();
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10812(recipe.getRecipeCategory());
        buf.writeBoolean(class_437.method_25442());
        buf.writeInt(input.size());
        for (List stacks : input) {
            buf.writeInt(stacks.size());
            for (EntryStack stack : stacks) {
                if (stack.getItemStack() != null) {
                    buf.method_10793(stack.getItemStack());
                    continue;
                }
                buf.method_10793(class_1799.field_8037);
            }
        }
        ClientSidePacketRegistry.INSTANCE.sendToServer(RoughlyEnoughItemsNetwork.MOVE_ITEMS_PACKET, buf);
        return AutoTransferHandler.Result.createSuccessful();
    }

    public double getPriority() {
        return -10.0;
    }

    public IntList hasItems(final class_1703 container, final ContainerInfo<class_1703> containerInfo, List<List<EntryStack>> inputs) {
        RecipeFinder recipeFinder = new RecipeFinder();
        containerInfo.getRecipeFinderPopulator().populate((ContainerContext)new ContainerContext<class_1703>(){

            public class_1703 getContainer() {
                return container;
            }

            public class_1657 getPlayerEntity() {
                return class_310.method_1551().field_1724;
            }

            public ContainerInfo<class_1703> getContainerInfo() {
                return containerInfo;
            }
        }).accept(recipeFinder);
        IntArrayList intList = new IntArrayList();
        for (int i = 0; i < inputs.size(); ++i) {
            List<EntryStack> possibleStacks = inputs.get(i);
            boolean done = possibleStacks.isEmpty();
            for (EntryStack possibleStack : possibleStacks) {
                int invRequiredCount;
                if (done || possibleStack.getType() != EntryStack.Type.ITEM) continue;
                int key = RecipeFinder.getItemId((class_1799)possibleStack.getItemStack());
                for (invRequiredCount = possibleStack.getAmount(); invRequiredCount > 0 && recipeFinder.contains(key); --invRequiredCount) {
                    recipeFinder.take(key, 1);
                }
                if (invRequiredCount > 0) continue;
                done = true;
                break;
            }
            if (done) continue;
            intList.add(i);
        }
        return intList;
    }
}

